package tzu.strategy;

import tzu.intel.*;
import robocode.*;
import tzu.util.*;

/**
 * Describes an abstract strategy that acts as a base for other strategies.
 */
public abstract class AbstractStrategy implements Constants {

    public AdvancedRobot            myRobot;
    public EnemyManagerInterface    enemyManager;

    public AbstractStrategy(AdvancedRobot ar, EnemyManagerInterface emi) {

        myRobot = ar;
        enemyManager = emi;
    }

    public abstract void reinitialize();
    public abstract void takeTurn();
}
