package cs.s2;

import java.awt.geom.Point2D;

import cs.s2.misc.Tools;

import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Radar extends Extension {
	long ticksSinceLastScan = 0;
	boolean initialScan = false;
	Radar() {
		/**
		 * Put Heavy Self Initialization Code Here!
		 */
	}
	
	public void run() {
		double angleToCenter = Tools.absoluteBearing(
				new Point2D.Double(bot.getX(), bot.getY()),
				new Point2D.Double(Extension.battlefield.getCenterX(), Extension.battlefield.getCenterY()));
		double angle = Utils.normalRelativeAngle(angleToCenter - bot.getRadarHeadingRadians());
		bot.setTurnRadarRightRadians(angle * Double.POSITIVE_INFINITY);
		bot.setTurnGunRightRadians(angle * Double.POSITIVE_INFINITY);
		initialScan = true;
	}
	
	public void execute() {
		
		if(bot.getOthers() == 0) {
			bot.setTurnRadarRightRadians(0);
		}
		//turn the radar
		else if(ticksSinceLastScan++ > 4) {
			bot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			ticksSinceLastScan = 0;
		}
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		if(initialScan) {
			bot.setTurnGunRightRadians(0);
			initialScan = false;
		}
	    // Absolute angle towards target
	    double absBearing = bot.getHeadingRadians() + e.getBearingRadians();
	    // Subtract current radar heading to get turn required, then normalize
	    double radarTurn = Utils.normalRelativeAngle(absBearing - bot.getRadarHeadingRadians());
	    // Width of the bot, plus twice the arc it can move in a tick, limit it to the max turn
	    double arcToScan = Math.min(Math.atan(36.0 / e.getDistance())*2.0,Math.PI/4.0);
	    // We want to sent the radar even further in the direction it's moving
	    radarTurn += (radarTurn < 0) ? -arcToScan : arcToScan;
	    bot.setTurnRadarRightRadians(radarTurn);
	    
	    if(Seraphim.isChallenge) {
	    	bot.setTurnGunRightRadians(Utils.normalRelativeAngle(absBearing - bot.getGunHeadingRadians()));
	    }
	    
	    ticksSinceLastScan = 0;
	}
}
