package kvk.Gun;
import kvk.Utils.C;
import kvk.Utils.Fct;

/**
 *  Statistiques pour un canon virtuel ou un robot
 *
 * @author     Ssin.le.Terrible
 * @created    3 fvrier 2004
 */
public class GunStats {
	private  int     shotCount;                                                    // nb de tirs
	private  int     hitCount;                                                     // nb de touches
	private  double  hitPct;                                                       // % de touche
	private  double  hitRate;                                                      // notation

	/**
	 * Constructor pour l'objet gunStats
	 */
	public GunStats() {
		shotCount = 0;
		hitCount = 0;
		hitPct = 0d;
		hitRate = 50d;
	}

	// ***************************** METHODES D'ACCES ***************************** //
	public int getShotCount() {
		return shotCount;
	}

	public int getHitCount() {
		return hitCount;
	}

	public double getHitPct() {
		return hitPct;
	}

	public double getHitRate() {
		return hitRate;
	}
	// **************************************************************************** //

	/**
	 * Ajout d'un tir
	 */
	public void addShot() {
		hitPct = ((double)hitCount / ++shotCount) * 100d;
	}

	/**
	 * Ajout d'une touche
	 *
	 * @param  power  The feature to be added to the Hit attribute
	 */
	public void addHit(double power) {
		hitPct = ((double)++hitCount / shotCount) * 100d;
		hitRate = Fct.rollingAvg(hitRate, 100d, C.HIT_RATE_LIST_SIZE, power);
	}

	/**
	 * Ajout d'un chec
	 *
	 * @param  power  The feature to be added to the Miss attribute
	 */
	public void addMiss(double power) {
		hitRate = Fct.rollingAvg(hitRate, 0d, C.HIT_RATE_LIST_SIZE, power);
	}

	// **************************************************************************** //
	/**
	 * Mthode d'affichage
	 *
	 * @return    Description of the Return Value
	 */
	public String toString() {
		String  s  = "";
		s += hitCount + "/" + shotCount + "=" + Fct.round2(hitPct) + "% / " + Fct.round2(hitRate);
		return s;
	}
}

