package trab.crusader;

import java.util.Vector;
import trab.intel.IntelligenceManager;
import trab.utils.*;
import java.awt.geom.Point2D;
import robocode.*;

public class MovementStatist {

  private boolean doGL = false;
  //private boolean doGL = true;
  
  private final int ACCEL_SEGMENTS = 3;
  //private final int LATERAL_VELOCITY_SEGMENTS = 1;
  private final int VELOCITY_SEGMENTS = 5; //5
  private final int DISTANCE_SEGMENTS = 5; //5
  private final int BULLET_TIME_SEGMENTS = 1;
  
  private final int FACTORS = 29;
  private final int MIDDLE_FACTOR = ( FACTORS - 1 ) / 2;
  /*
  private final int BIN_SMOOTH = 3;
  private final double BIN_SMOOTHING_FACTOR = 0.25d;
  */
  public WaveGrapher grapher;
  
  //double[]    statsFastest = new double[ FACTORS ];
  private int[][][][][] waveStats = new int[ ACCEL_SEGMENTS ][ VELOCITY_SEGMENTS ][ BULLET_TIME_SEGMENTS ][ DISTANCE_SEGMENTS ][ FACTORS ];
  private int[][][][][] hitStats = new int[ ACCEL_SEGMENTS ][ VELOCITY_SEGMENTS ][ BULLET_TIME_SEGMENTS ][ DISTANCE_SEGMENTS ][ FACTORS ];
  private int[] fastHitStats = new int[ FACTORS ];
  
  private int eFired = 0;
  private int eHit = 0;
  private double a[];
  private double b[];
  
  AdvancedRobot robot;
  
  private Vector enemyWaves;
  private IntelligenceManager intel;
  private double oldFlat = 0;
  
  private static MovementWave lastWave = null;
  
  public double getStatsDanger( Point2D pos, MovementWave w ) {
    
    int index = Utils.gfToIndex( w.getGuessFactor( pos ), FACTORS );
    
    
    if ( !w.equals( lastWave ) ) { // finding stats for a new wave, so update our smoothed a[] array
      
      double s = 0;
      for ( int k = 0; k < FACTORS; k++ ) {
        s += hitStats[w.accelIndex][w.velIndex][w.bulletTimeIndex][w.distIndex][k];
      }
      
      if ( s == 0 ) // if no hits in current segment; use unsegmented array. for the very first rounds vs simple targetters
        a = getSmoothed2( fastHitStats );
      else
        a = getSmoothed2( hitStats[w.accelIndex][w.velIndex][w.bulletTimeIndex][w.distIndex] );
      lastWave = w;
    }
    
    b = getSmoothed2( waveStats[w.accelIndex][w.velIndex][w.bulletTimeIndex][w.distIndex] );
    
    double aSumPop = 0;
    double aHighestPop = 1;
    double aPop = 0;
    double bSumPop = 0;
    double bHighestPop = 1;
    double bPop = 0;
    
    for ( int i = 0; i < FACTORS; i++ ) {
      aPop = a[ i ];  
      aSumPop += aPop;
      if ( aPop > aHighestPop )
        aHighestPop = aPop;
      bPop = b[ i ];  
      bSumPop += bPop;
      if ( bPop > bHighestPop )
        bHighestPop = bPop;  
    }
    
    double danger = 0;
    double aDanger = 0;
    double bDanger = 0;
    
    int gfMinIndex = Utils.gfToIndex( w.getMinGF( pos ), FACTORS );
    int gfMaxIndex = Utils.gfToIndex( w.getMaxGF( pos ), FACTORS );
    
    int runs = 0;
    for ( int k = gfMinIndex; k <= gfMaxIndex && k < FACTORS; k++  )
    {
      aDanger += a[ k ];      
      bDanger += b[ k ];
      runs++;
    }
    //danger = (danger / (runs)) / highestPop;
    aDanger = (aDanger / (runs+1)) / aHighestPop; // why + 1?
    bDanger = (bDanger / (runs+1)) / bHighestPop; // why + 1?
    
    double flattening = 0;
    if ( intel.getRound() > 1 || robot.getTime() > 60 ) {
      flattening = Math.max( Math.min( ((double)eHit/eFired)*5, 0.5 ), 0 );
    }
    /*
    if ( flattening != oldFlat )
      robot.out.println( "Flattening: " + flattening );
    */
    oldFlat = flattening;
    
    danger += aDanger * (1-flattening);
    danger += bDanger * flattening;
    
    //danger = hitStats[w.accelIndex][w.velIndex][w.bulletTimeIndex][w.distIndex][ index ];      
    //robot.out.println( "Hits danger: " + danger );
    
    //danger += hitStats[w.accelIndex][w.velIndex][w.bulletTimeIndex][w.distIndex][ index ]/highestPop;

    double dist = (intel.getEnemyPosition(0)).distance( pos ) - 38;
    double distDanger = (dist < 300d ? Math.pow((300d-dist)/300d,4) : 0 ); 
    
    danger += Math.max( distDanger, 0 );
    
    return danger; 
  }
  
  public MovementWave getWaveToHit( Point2D target, int num ) { // currently return first to hit
    if ( wavesSize() == 0 )
      return null;
    
    MovementWave w;
    
    int bestIndex = 0;
    double bestTime = 9999;
    
    for ( int i = 0; i < enemyWaves.size(); i++ ) {
      w = (MovementWave)enemyWaves.elementAt(i);
      
      if ( !w.isDead() ) {
        
        if ( w.impactEta( target ) < bestTime ) {
          bestTime = w.impactEta( target );
          bestIndex = i;
        }
      }
    }
    return (MovementWave)enemyWaves.elementAt( bestIndex );
    
    /*
    int k = 0;
    do
      w = (MovementWave)enemyWaves.elementAt(k++);
    while ( w.isDead() );
    
    return (MovementWave)enemyWaves.elementAt( enemyWaves.size()-1 );
    */
  }
  
  
  public MovementStatist( IntelligenceManager intel_ ) {
    intel = intel_;
    enemyWaves = new Vector();
    
    if ( doGL )
     grapher = new WaveGrapher();
    
    //fastHitStats[ 0 ] = 1;
    fastHitStats[ MIDDLE_FACTOR ] = 1;
    //fastHitStats[ FACTORS-1 ] = 1;

  }
  
  public void initRound() {
    while ( enemyWaves.size() > 0 )
      enemyWaves.remove(0);
    
    
    
    if ( doGL )
      grapher.startRound();  
  }
  
  public void fireRealWave() {
    fireWave( true );  
  }
  public void fireVirtualWave() {
    fireWave( false );
  }
  
  public void fireWave( boolean realWave ) {
    if ( realWave )
      eFired++;
    
    MovementWave wave = new MovementWave( intel.getEnemyPosition(1), intel.getRobotPosition(1), intel.getEnemyFirePower(0), intel.getRobotBearingDirection(1) );
    
    wave.accelIndex = getAccelIndex();
    //wave.latVelIndex = getLatVelIndex();
    wave.velIndex = getVelIndex();
    wave.bulletTimeIndex = getBulletTimeIndex();
    wave.distIndex = getDistIndex();
    wave.isReal = realWave;
    wave.advance( 1 );
    enemyWaves.add( wave );
    
    //robot.out.println( robot.getTime()-1 +  " : Wave fired! myVel at fire time: " + intel.getRobotHeadingRadians(1) );
  }
  
  // main fucntion
  public void updateWaves() {
    /*
    if ( doGL )
      grapher.drawHitBox( intel.getRobotPosition(0) );
    */
    
    MovementWave w;
    //robot.out.println( robot.getTime() + " : updating " + enemyWaves.size() + " waves." );
    
    for ( int i = 0; i < enemyWaves.size(); i++ ) {
      w = (MovementWave)enemyWaves.elementAt(i);
      w.advance(1);
      
      //if ( false ) {
      if ( w.deadTime() > 15 ) {
        //robot.out.println( robot.getTime() + " : a dead wave was removed." ); 
        enemyWaves.remove( i-- );
        
      }
      else {
        
        if ( doGL && w.isReal && !w.isDead() ) {
        
          // lets generate a danger array
          //int[] dangerArray = new int[FACTORS];
          
        
          grapher.drawWave( w.getSource(), getSmoothed2( hitStats[w.accelIndex][w.velIndex][w.bulletTimeIndex][w.distIndex] ) , w.getRadius(), w.getLowGfAngle(), w.getAngleSector()/(double)FACTORS );
        
        
        }
        if ( w.hasHit( intel.getRobotPosition(0) ) ) {
          
          //int gfIndex = Utils.gfToIndex( w.getGuessFactor( intel.getRobotPosition(0) ), FACTORS );
          int gfMinIndex = Utils.gfToIndex( w.getMinGF( intel.getRobotPosition(0) ), FACTORS );
          int gfMaxIndex = Utils.gfToIndex( w.getMaxGF( intel.getRobotPosition(0) ), FACTORS );
          
          for ( int k = gfMinIndex; k <= gfMaxIndex && k < FACTORS; k++  ) {
            waveStats[ w.accelIndex ][ w.velIndex ][ w.bulletTimeIndex ][ w.distIndex ][ k ]++;      
          }
          w.kill();
        }
        
      }
    }
    
    if ( intel.robotWasHit(0) ) {
      eHit++;
      MovementWave hitWave = null;
      MovementWave ww;
      int hitWaveIndex = 0;
      double hitWaveDist = 1000;
      hitWaveDist = 10000;
      for ( int j = 0; j < enemyWaves.size(); j++ ) {
        
        ww = (MovementWave)enemyWaves.elementAt(j);
        if ( Utils.dEquals( ww.getBulletPower(), intel.getRobotBulletHitPower(0), 0.09999 ) ) {
          
          //robot.out.println( "Bullet power match!" );
          
          if ( hitWaveDist > ww.distance( intel.getRobotPosition(0) ) ) {
            //hitWave = (MovementWave)ww.clone();
            hitWave = ww;
            hitWaveDist = ww.distance( intel.getRobotPosition(0) );
            hitWaveIndex = j;
          }
        }
      }
      
      if ( hitWave != null ) { // match found
        //robot.out.println( "Matching wave was found, distance = " + hitWaveDist );
        /*
        int gfIndex = Utils.gfToIndex( hitWave.getGuessFactor( intel.getRobotPosition(0) ), FACTORS );
        hitStats[hitWave.accelIndex][hitWave.velIndex][hitWave.bulletTimeIndex][hitWave.distIndex][ gfIndex ]++;  
        */
        
        int gfMinIndex = Utils.gfToIndex( hitWave.getMinGF( intel.getRobotPosition(0) ), FACTORS );
        int gfMaxIndex = Utils.gfToIndex( hitWave.getMaxGF( intel.getRobotPosition(0) ), FACTORS );
        
        for ( int k = gfMinIndex; k <= gfMaxIndex && k < FACTORS; k++  ) {
          
          hitStats[hitWave.accelIndex][hitWave.velIndex][hitWave.bulletTimeIndex][hitWave.distIndex][ k ]++;      
          fastHitStats[ k ]++;
        }
        
        enemyWaves.remove( hitWaveIndex );
      }
      else // if no match discard bullet
        robot.out.println( "######## No matching wave was found! ######## num waves: " + enemyWaves.size() + " dist = " + intel.getRobotDistanceToEnemy(0) + " power: " + intel.getRobotBulletHitPower(0) ); // lets hope this doesnt happen
      
    }
    /*
    if ( doGL )
      grapher.endTick();
    */  
  }
  /*
  public double[] getSmoothed( int[] a, int t ) {
    double[] b = new double[ a.length ];  
    double[] c = new double[ a.length ];  
    
    for ( int k = 0; k < a.length; k++ ){
      b[k] = a[k];  
    }
    
    for ( int j = 0; j < t; j++ ) {
      
      for ( int k = 0; k < b.length; k++ ){
        c[k] = b[k];  
      }
      
      for ( int i = 0; i < a.length; i++ ){
        b[i] += c[i]*                         (1 - 2*BIN_SMOOTHING_FACTOR);
        
        if ( i > 0 ) b[i] += c[i-1] *         BIN_SMOOTHING_FACTOR;
        else b[i] += c[i+1] *                 BIN_SMOOTHING_FACTOR;
        
        if ( i < a.length-1 ) b[i] += c[i+1]* BIN_SMOOTHING_FACTOR;
        else b[i] += c[i-1]*                  BIN_SMOOTHING_FACTOR;
      }
    
    }
    return b;
  }
  */
  public double[] getSmoothed2( int[] a ) {
    
    double[] b = new double[ a.length ];  
    
    for ( int i = 0; i < FACTORS; i++ ) { // i = current gf thats beeing smoothed 
      
      for ( int j = 0; j < FACTORS; j++ ) {
        //b[i] += (double)a[j] * Math.pow( 0.5 ,Math.abs( i-j ) );  
        b[i] += (double)a[j] / ( Math.abs( i-j )+1 );  
        //b[i] += (double)a[j] / Math.pow( Math.abs( i-j )+1, 2 );  
        //b[i] += (double)a[j] / Math.sqrt( Math.abs( i-j )+1 );
      }
    
    }
    return b;
  }
  
  public int wavesSize() {
    
    int numDead = 0;
    for ( int i = 0; i < enemyWaves.size(); i++ )
      if ( ((Wave)enemyWaves.elementAt(i)).isDead() )
        numDead++;
    
    return enemyWaves.size() - numDead;  
  }
  
  
  private int getAccelIndex() {
    
    if ( ACCEL_SEGMENTS == 1 )
      return 0;

    double accel = intel.getRobotAcceleration(1);
    if ( accel > 0 ) // accel
      return 0;
    else if ( accel == 0 ) // constant
      return 1;
    else
      return 2; // decel
  }
  
  private int getVelIndex() {
    
    if ( VELOCITY_SEGMENTS == 1 )
      return 0;
    
    double vel = Math.abs( intel.getRobotVelocity(1) );
    
    if ( vel == 0 ) return 0;
    else if ( vel <= 2 ) return 1;
    else if ( vel <= 4 ) return 2;
    else if ( vel <= 6 ) return 3;
    else return 4;
  }
  
  private int getLatVelIndex() {
    
    double vel = Math.abs(intel.getRobotLateralVelocity(1));
    
    if ( vel == 0 ) return 0;
    else if ( vel <= 2 ) return 1;
    else if ( vel <= 4 ) return 2;
    else if ( vel <= 6 ) return 3;
    else return 4;
    
    //return index;  
  }
  private int getBulletTimeIndex() {
    //int i = (int) ((intel.getRobotDistanceToEnemy(0)/(20D-intel.getEnemyFirePower(0)*3D)) / ((900D/11D)/(double)BULLET_TIME_SEGMENTS) );
    
    double i = ((intel.getRobotDistanceToEnemy(1) / (20D-intel.getEnemyFirePower(0)*3D)) / (1000d/11d)) * (double)BULLET_TIME_SEGMENTS; 
    //double i = intel.getRobotDistanceToEnemy(0) / (20D-intel.getEnemyFirePower(0)*3D) ;
    return Math.min( (int)i, BULLET_TIME_SEGMENTS-1 );
  }
  
  private int getDistIndex() {
    int i = (int) (intel.getRobotDistanceToEnemy( 1 )/1000D * (double)DISTANCE_SEGMENTS);
    return Math.min( i, DISTANCE_SEGMENTS-1 );
  }  
}