package dft.bin;

import java.util.ArrayList;

public class GunWave extends Wave {
		
	public void increment(double GF) {
		
		for (int j = 0; j < buffers.size(); j++) {			
			BufferWrapper cw = (BufferWrapper)buffers.get(j);
			double weight = real?cw.weight:1;
			double[] currentBuffer = (double[])cw.buffer;
			int index = Utils.getIndex((currentBuffer.length-1)/2,GF);
			for (int i = 1; i < currentBuffer.length; i++) {					
				currentBuffer[i]*=currentBuffer[0]/(currentBuffer[0]+weight);
			}			
			currentBuffer[0] += weight;
			currentBuffer[index] += weight/currentBuffer[0];
			currentBuffer[0] *= cw.rollPercent;
		}
	}

	public boolean isGunWave() {
		return true;
	}
	
}
