package maribo;

import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import java.awt.Color;
import robocode.util.*;
import java.awt.geom.*;


/**
 * Oscillator - a robot by Alexander MacKenzie
 */
public class Omicron extends AdvancedRobot
{
	static double oldEnemyHeading;
	static double prevEnergy = 100.0;
	static double direction = 1;
	
	public void run() {
		setColors(Color.gray,Color.white,Color.pink,Color.white,Color.pink);

		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setTurnRadarRight(Double.POSITIVE_INFINITY);
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		
		double firePower = Math.min(3,getEnergy()/8);
		double myX = getX();
		double myY = getY();
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing);
		double enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);
		double enemyHeading = e.getHeadingRadians();
		double enemyHeadingChange = enemyHeading - oldEnemyHeading;
		double enemyVelocity = e.getVelocity();
		oldEnemyHeading = enemyHeading;
		
		
		if (getDistanceRemaining() == 0) {
			direction = -direction;
			setAhead((100 + (Math.random()*150)) * direction);
		}
		setTurnRightRadians(e.getBearingRadians() + Math.PI/2 - 0.4236 * direction * (e.getDistance() >280 ? 1 : -1));
		
	 
		double deltaTime = 0;
		double battleFieldHeight = getBattleFieldHeight(), 
		       battleFieldWidth = getBattleFieldWidth();
		double predictedX = enemyX,	predictedY = enemyY;
		while((++deltaTime) * (20.0 - 3.0 * firePower) < 
		      Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
			predictedX += Math.sin(enemyHeading) * enemyVelocity;
			predictedY += Math.cos(enemyHeading) * enemyVelocity;
			enemyHeading += enemyHeadingChange;
			if(	predictedX < 18.0 
				|| predictedY < 18.0
				|| predictedX > battleFieldWidth - 18.0
				|| predictedY > battleFieldHeight - 18.0){
		 
				predictedX = Math.min(Math.max(18.0, predictedX), 
				    battleFieldWidth - 18.0);	
				predictedY = Math.min(Math.max(18.0, predictedY), 
				    battleFieldHeight - 18.0);
				break;
			}
		}
		double theta = Utils.normalAbsoluteAngle(Math.atan2(
		    predictedX - getX(), predictedY - getY()));
		setTurnRadarRightRadians(Utils.normalRelativeAngle(
    		absoluteBearing - getRadarHeadingRadians()));
		setTurnGunRightRadians(Utils.normalRelativeAngle(
		    theta - getGunHeadingRadians()));
		if (getGunHeat() == 0) {	
			fire(firePower);
		}
	}
}