package SHAM;

import robocode.*;
import java.awt.*;
import java.util.*;

/**
 * SHAM.WOW created by Steven Hatton and Aditya Majumdar
 * Period 3, JAVA Programming
 * Due: 06/05/09
 * Robocode, JAVA, Second Semester Final Project
 * 
 *  This robot utilizes many strategies depending on battlefield conditions and opponents:
 *  Pattern Matching, Wave Surfing, Linear Targeting, Walls movement, strafing, and sometimes spinning.
 *  
 *  Each strategy is split into a different class using 'pluggable framework.'
 *  In that, this main class is essentially the skeleton which shows what strategies will be used
 *  at specific times.
 *  
 *  SHAM.WOW is more suited for 1v1, but has limited melee capabilities as well.
 *  
 *  Accounts for undesirable events such as being hit by a bullet or another robot.
 *  We have wall avoidance code implemented as well.
 *  
 *  Radar varies per mode. Once in a while, we will spin it around to find the closer enemy.
 *  That's important if we're being fired upon unnoticed. 
 *  
 *  In close combat, we'll usually stay locked on just one target. 
 */

/*
 * General PluggableFramework strategy credited to Robert Ying, Robowiki
 */

public class WOW extends AdvancedRobot
{
    // Variables
    // takes several of the separate classes and create private variables
    // to reference the guns and movement methods of those classes
    private AdvancedEnemyBot enemy = new AdvancedEnemyBot();

    private static WaveSurfing rmovement; // wave surfing movement implemented

    private static PM PM; // pattern matcher

    private static LG gun; // linear gun

    private static WallMover wallmovement; // uses the movement of the sample
                                           // "walls" robot

    // strafing
    private static Strafer smovement;

    // similar to spinbot
    private static SM spinmovement;


    // constructor
    public WOW()
    {
        spinmovement = new SM( this );
        gun = new LG( this );
        PM = new PM( this );
        rmovement = new WaveSurfing( this );
        wallmovement = new WallMover( this );
        smovement = new Strafer( this );
    }


    public void run()
    {
        setColors( Color.ORANGE,
            Color.ORANGE,
            Color.ORANGE,
            Color.ORANGE,
            Color.ORANGE );
        enemy.reset();
        setAdjustGunForRobotTurn( true );
        setAdjustRadarForGunTurn( true );
        setAdjustRadarForRobotTurn( true );

        // initial scan
        setTurnRadarRightRadians( Double.POSITIVE_INFINITY );

        rmovement.run();
    }


    /**
     * onScannedRobot: What we do when another robot is scanned and seen in path
     */
    public void onScannedRobot( ScannedRobotEvent e )
    {
        // scan / overrides initial scan and locks
        setTurnRadarLeftRadians( getRadarTurnRemainingRadians() );

        // find new robot under certain conditions
        if ( enemy.none() || e.getDistance() < enemy.getDistance() - 70
            || e.getName().equals( enemy.getName() ) )
        {
            enemy.update( e, this );
        }

        // large brawl - walls and linear gun targeting
        if ( getOthers() > 5 )
        {
            wallmovement.onScannedRobot( e );
            // PM.onScannedRobot( e );
            gun.onScannedRobot( e );
        }

        // just a few enemy robots - strafing movement and linear targeting
        else if ( getOthers() > 2 )
        {
            smovement.onScannedRobot( e );
            gun.onScannedRobot( e );
        }

        // just a couple enemies - pattern matching and wavesurfing FTW!
        else
        {
            PM.onScannedRobot( e );
            rmovement.onScannedRobot( e );
        }
    }


    /**
     * onHitByBullet: What to do when you're hit by a bullet
     */
    public void onHitByBullet( HitByBulletEvent e )
    {
        System.out.println( "I got hit!" );
        if ( getOthers() < 3 )
        {
            // wave surfing avoidance kicks in when hit by bullet
            rmovement.onHitByBullet( e );
        }
    }


    public void onBulletHit( BulletHitEvent e )
    {
        // gun.onBulletHit(e);
    }


    public void onHitRobot( HitRobotEvent e )
    {
        if ( getOthers() > 2 )
        {
            // back up a bit, then go forward again - just what our walls
            // movement does

            wallmovement.onHitRobot( e );
        }

    }


    public void onRobotDeath( RobotDeathEvent e )
    {
        if ( getOthers() > 2 )
            gun.onRobotDeath( e );
    }


    public void onPaint( java.awt.Graphics2D g )
    {
        // paints wavesurfing waves :)
        rmovement.onPaint( g );
    }
    
/* SHAM WOW! SHAM WOW! SHAM WOW! SHAM WOW! SHAM WOW! SHAM WOW! SHAM WOW! SHAM WOW!
????????+++++++++++++++++=======================================++++++++++++++++
????+++++++++++++++++++===================?Z==~=:===================++++++++++++
???++++++++++++++++++===================~Z$$Z7?+7+===================+++++++++++
?+++++++++++++++++=====================77ZOO888O8ZO?=+===================+++++++
?+++++++++++=++::.,===================?ZDODD8O8DDD8$========================++++
+++++++++++I?+++=$=:I==I==========~~=7I$D88ZOO88D8O8$?=:======================++
+++++==~,.~8Z=+~~=~:~~Z??======~~~=I$D$ZODD88DD8ND8DDDZ=~~~~~===================
++++++7$~~~=7+7=Z=~===+==~~~~~~~~~I?O8OZ$8O88ODDDDDDDDD?~~~~~~~~=~==============
+++++=I====~==~=++++===~~~~~~~~~~~OI?I7II++++=?OZOOO8D8=~~~~~~~~~~~~============
++++?++======~~========~~~~~~~~~~~?7I??++==~=~+$ZZO8OOO~~~~~~~~~~~~~~~==========
++++II~====~==~========~~~~~~~~~~~7I?+==+==~~+?$O88O888~~~~~~~~~~~~~~~~~========
++++=+==========~~====~~~~~~~~~~~~I7??+?+==~=~~?$$OO7?N~~~~~~~~~~~~~~~~~~~======
+++==?I===~==========~=~~~~~~~~~~~OOI??7$ZI=~~=~7O8~NND~:::~~~~~~~~~~~~~~~~~~===
++==++77~========~====~~~~~~~~~:~:I?NO~=$+:O+~:~=$IDNO=::::~:~~:~~~~~~~~~~~~~~==
+==+I+7=================~~~~:~::::877I~~=?+=~=:~~~=:7~I::::::::~~:~~~~~~~~~~~~~=
===?7++~===============~~~~:::::::N77I=~~++=~~~=~~~~~~D::::::::::::~~~~~~~~~~~~~
==+77+========~=======~=~~:::::::::$7~8==?+=~=~~~~=+=+8::::::::::::::~~~~~~~~~~~
==$I$===============~===:::::::::.:~$+??+=++~~~~~=+===?D?:::::::::::::~~~~~~~~~~
==77$+=~+=~==~===~~===~=::::::::M?DDO7I+=$==~~~~=?==++I8NO$::::::::::::::::~~~~~
=777++=+I==~==~~~=~===~~N$Z::,:+,:$MI7?+===+===?+=+=+I$8O88O::::::::::::::::~~~~
=777~==~+=~~=~=~====~==~D8NDDD8888ODD$?++=+==+?++++?I$ODDD88O$:::::::::::::~~~~~
==?I~+==+~===========~=~NNNNNNNNNNNND77+++?$$++???7ZOOODDDDD8D88O~::::::::::::~~
==I7=I=+========~======~NNNNNNNNNNNNMDDDD8NO7Z77$$Z8O8DDDDDDDNDDDOZO=::::::::~:~
=~I7=I=I?============~=7NNNNNNNNNNNN8NNNDNODN7$$$$OZNDDDDDDDDD8D8O8888O::::::~:~
=~==+7=7?====+=========8NNNNNNNNNNNNNNNNDMDDD$$$77$DDDDNDNNDDNDDDDDDD888::::::::
=~~~~~=$I====++++?++?==DDDNNNNNNNNNNNNNNNMNNND$Z$ZNDDDNNNNNNDDNDDDDDDDD8,:::::::
=~~~~~~~~::::::::::::?$DNNNNNNNNNNNNNNNDNMNNDDDNNDDDNNNNNNDDNDDDDDDDD8DDD:::::::
=~~~~~~~~:::::::::::::,::INNDNNMMNNNNNDDNNNDNNNNNNNDNNNNNDMDNDDDDDDDDD888:::::::
=~~~~~~~~::::::::::::::,,,,,,,ONNNNDN8DNMNNN+NNNNNNNNNNDDNNDDDDDDDDDDDDD8,::::::
=~~~~~~~::::::::::::::,,,,,,,,,,,ONNDDDNMNDNNNNNNNNNNDDDDDNDDDDDDDDD88DD8=::::::
~~~~~~~~:::::::::?I??,,,,,,,,,,,,,NDDDDNMNNNDNN?NNNNNDNNDDDDDDDDDDDDDD8DD8::::::
=?+===~+?++?+=~:::::::=,,,,,,,,,,,NNDNNNMNNDNNNIZONNNNDNDDDDDDDDDDDDDDD8D8::::::
~~~?7II++?I7++====~==~~~~,,,,,,,,,NNDNNNMNDNNDDNNNDDNNNDDDDDDDDDDDDDDDDDD:::::::
~~~~~~~~:::~II?77II$:~+=~~:,,,,,,,,NNNNNMMNNDDDDNNNNNNDDDDDDDDDDDDDDDDDD8,,:::::
~~~~~~~::::::::::,:,II??=====,,,,,,NNNNNMMNDDDNNNDNNNDDDDDDDDDDDDDDDD8888,,:::::
~~~~~~~:::::::::::,,,,=$II?++==:,,,NNNNNNMMNDNDNNNNDNDDDDDDDDDDDDDDDD8888:,,,:::
~~~~~~:::::::::::,,,,,,,~$7??++==+,NNNNNNMMNNNNNNNNNNNDDDDDDDDDDDDDD8DDDD,,,,,,:
~~~~~~:::::::::::,,,,,,,,,~Z7I++====8DNDNMMMNNNNNNDDDDDDDDDDDDDDDDD8DDDDD,,,,,,:
~~~~~~~:::::::::,,,,,,,,,,,,ZZI??I+=+===DNNMNNNNNDNDDDDDDDDDDDDDDD88DDDDD,,,,,,:
~~~~~~:::::::::,:,,,,,,,,,,,,,$77II+++=+=++?NMNMMDDDND8DDDDDDDDDDDDDDDDD7,,,,,,:
~~~~~~~::::::::::,,,,,,,,,,,,,,,7I7I?=+=+=++=?+?DDDNNDDDDDDDDDDDDDDDDDDD.,,,,,,,
~~~~~~~::::::::::,,,,,,,,,,,,,,,,?7II?++?++==~=+?DDDDDDDDDDDDDDDDDDDDDD8,,,,,,,,
~~~~~~:~::::::::,,,,,,,,,,,,,,,....77II++++++==~=~+DDDDDDDDDD8DN8DDDDDD8,,,,,,,,
~~~~~~:~:::::::::,,,,,,,,,,,,,.....DD$7II?+=+=++=~===8DDDDDD8DDNDDDDDDD?,,,,,,,:
~~~~~~~~:::::::::,,,,,,,,,,,,,.....DDDD7II???+==+==~:~~ZDDDDDDDDNDDD888,,,,,,,,,
~~~~~~~::::::::::,,,,,,,,,,,,,.....DDDDDD$I?++=~~~~~~~~=MN8DDNNDDDD8DD8,,,,,,,,:
~~~~~~~~:::::::::,,,,,,,,,,,,,,....DDDDDNNN7?+===~~~~~+NDNNNDDDDDDD8DD.,,,,,,,,:
~~~~~~~~~::::::::,,,,,,,,,,,,,,...+DDDDNNNNNN7I??==+ZNNNDDDDDDDDDDDDD8~,,,,,,,::
=~~~~~~~~~:::::::,,,,,,,,,,,,,,...DDNNNNNNNNNNMII?NDDDDDDDDDDDDDDDDDDD,,,,,,,,::
==~~~~~~~~:::::::,,,,,,,,,,,,,....8DDNNNNDDNNDNNDDDDDDDDDDDDDDDDD8D8D+,,,,,,,:::
===~~~~~~~:::::::,,,,,,,,,,,,,,.,.DDNNNNNNDDDDDDDDDDDDDDDDDDDDDDDD8D88,,,,,,,:::
===~~~~~~~~:::::::,,,,,,,,,,,,,,.,DDNNNNNNDDDDDDDDDDDDDDDDDDDDDDDDDD8D,,,,,,,:::
GlassGiant.com
*/
                                                                         
}