package cjm.chalk;

import java.util.ArrayList;
import java.awt.geom.Rectangle2D;

public abstract class BaseGun {
	
	ArrayList<VirtualBullet> _virtualShots = new ArrayList<VirtualBullet>();
	private Averager _averager = new Averager(200);

	abstract void addScan(Scan s);
	
	abstract double projectBearing(Scan scan, double x, double y, double enemyHeading);
	
	public void checkVirtualBullets(long time, Rectangle2D.Double enemyBox){		
		
		for(int i = _virtualShots.size() - 1; i >= 0; i--){
			VirtualBullet vb = _virtualShots.get(i);
			double d = vb.TheScan.getDistance(time);
			double heading = vb.TheScan.EnemyHeading + vb.TheBearing;
			double nextX = vb.TheScan.RX + Math.sin(heading) * d;
			double nextY = vb.TheScan.RY + Math.cos(heading) * d;
			
			if(enemyBox.contains(nextX, nextY)){
				_averager.addValue(1d);
				_virtualShots.remove(i);
			}
		}
	}
	
	public double getRatingPercent(){
		return _averager.getAverage();
	}
	
	public void takeVirtualShot(Scan s, double bearing){
		_virtualShots.add(new VirtualBullet(s, bearing));
	}
	
	public void removePassed(Scan s){
		for(int i = _virtualShots.size() - 1; i >= 0; i--){
			if((_virtualShots.get(i)).TheScan == s){
				_virtualShots.remove(i);
				_averager.addValue(0d);
				break;
			}
		}
	}
	
	public void clear(){
		_virtualShots.clear();
	}
	
	class VirtualBullet{
		public Scan TheScan;
		public double TheBearing;
		
		VirtualBullet(Scan s, double bearing){
			TheScan = s;
			TheBearing = bearing;
		}
	}
}
