package zyx.mega.utils;

import static java.lang.Boolean.parseBoolean;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

import robocode.AdvancedRobot;
import zyx.mega.movement.WaveSurfing;
import zyx.mega.movement.melee.MinimumRisk;
import zyx.mega.radar.Radar;
import zyx.mega.targeting.VGunSystem;
import zyx.mega.targeting.melee.MeleeGun;

public class Config {
  public static boolean _raiko_;
  public static boolean _hawk_;
  public static boolean _mc_;
  public static boolean _tc_;
  public static boolean movement_enabled_;
  public static boolean targeting_enabled_;
  public static boolean radar_enabled_;
  public static boolean _raiko_fire_power_;
  public static boolean _pc_;

  public static void Load(AdvancedRobot robot) {
    Properties properties = new Properties();
    try {
      properties.load(new FileInputStream(robot.getDataFile("config.properties")));
    } catch (IOException e) {
      e.printStackTrace();
    }
    _raiko_fire_power_ = parseBoolean(properties.getProperty("raiko.fire_power"));
    String test = properties.getProperty("test");
    if ( robot.getOthers() == 1 ) {
      if ( test.equalsIgnoreCase("raiko") ) {
        _raiko_ = true;
      } else if ( test.equalsIgnoreCase("mc") ) {
        _mc_ = true;
      } else if ( test.equalsIgnoreCase("tc") ) {
        _tc_ = true;
      } else if ( test.equalsIgnoreCase("pc") ) {
        _pc_ = true;
      }
    } else if ( test.equalsIgnoreCase("hawk") ) _hawk_ = true;
    targeting_enabled_ = !(_raiko_ || _mc_);
    movement_enabled_ = !(_tc_ || _pc_);
    radar_enabled_ = !(_raiko_);
    if ( properties.getProperty("paint", "disabled").equals("enabled") ) {
      MinimumRisk._paint_ = parseBoolean(properties.getProperty("paint.minimum_risk"));
      MeleeGun._paint_ = parseBoolean(properties.getProperty("paint.melee_gun"));
      WaveSurfing._paint_ = parseBoolean(properties.getProperty("paint.wave_surfing"));
      VGunSystem._paint_ = parseBoolean(properties.getProperty("paint.dc_gf"));
      Radar._paint_ = parseBoolean(properties.getProperty("paint.radar"));
    }
    /**
    paint_level_ = properties.getProperty("paint.level", "GAME");
    print_level_ = properties.getProperty("print.level", "GAME");
    /**/
  }
}
