package dft.inject.util;
import dft.inject.util.Utils;
import robocode.*;
import java.awt.*;
import java.awt.geom.*;

public class Position {
	
		private Point2D myLocation;
		private double myHeading;
		private double myVelocity;
		
		public Point2D getLocation() {
			return myLocation;
		}
		
		public Position(Point2D location, double heading, double velocity) {
			myLocation = location;
			myHeading = heading;
			myVelocity = velocity;
		}
		
		public Position predict(Point2D source, double maxVelocity, double targetAngle, double orbitDirection, Rectangle2D battleField) {
			double x = myLocation.getX(), y = myLocation.getY();		
			double heading = myHeading;
			double velocity = myVelocity;
			
			double absBearing = Math.atan2(source.getX()-x,source.getY()-y);
			double m = .25*Math.toRadians(40d - 3d*Math.abs(velocity));
			
			Point2D destination;
			Point2D myLocation = new Point2D.Double(x, y);
			double angle = targetAngle;
			while (!battleField.contains(destination = Utils.project(myLocation, absBearing + orbitDirection*(angle-=0.08), 120))&&  angle > -targetAngle);
			double ang = Utils.absoluteBearing(myLocation, destination) - heading;
			heading += Math.min(m,Math.max(-m,robocode.util.Utils.normalRelativeAngle(Math.tan(ang))));
			
			double tVelocity = (Math.cos(ang)>0?1:-1)*maxVelocity;
			if (angle < 0) tVelocity = 0;
			
			double lastVelocity = velocity;
			if (tVelocity != velocity) {
				if (tVelocity < velocity) {
					velocity--;
					if (Math.abs(lastVelocity)-Math.abs(velocity)>0)
						velocity--;
				}
				else {
					velocity++;
					if (Math.abs(lastVelocity)-Math.abs(velocity)>0)
						velocity++;
				}
			}
			
			x += Math.sin(heading)*velocity;
			y += Math.cos(heading)*velocity;
				
			return new Position(new Point2D.Double(x,y), heading, velocity);
		}	

}