package gg;
import robocode.*;
import java.awt.Color;
import java.util.*;
import java.lang.*;

/**
 * Squaraus - a robot by (Gilbyit)
 */
public class Squaraus extends AdvancedRobot
{
	//System variabiles
	private HashMap Nemici=new HashMap();
	private HashMap Targets=new HashMap();
	private MoveCompleteCondition MoveControl=new MoveCompleteCondition(this);
	private RadarTurnCompleteCondition RadarControl=new RadarTurnCompleteCondition(this);
	private GunTurnCompleteCondition GunControl=new GunTurnCompleteCondition(this);
	private Nemico maintTarget;
	private double PI=Math.PI;
	private int radarDirection=1;
	
	/**
	 * run: Squaraus's default behavior
	 */
	public void run() {
		
		// Starting settings
		setColors(new Color(0,180,0),new Color(50,250,50),new Color(200,200,200));
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		
		// Radar initialize
		addCustomEvent(new RadarTurnCompleteCondition(this));
		setTurnRadarRight(360);

		//Start the radar system
		while(true) {
			if(Nemici.size()>0)
				fuga();
			else
				stop();
				
			// Tattica, cerca il pi vicino e allontanati fino a una certa distanza
			//scansiona();
			mira();
			execute();
		}
	}
	
	private void scansiona() {
		double maxBearingAbs=0, maxBearing=0;
  		int scannedBots=0;
	  	Iterator iterator = Nemici.values().
    	iterator();

		while(iterator.hasNext()) {
  		Nemico tmp = (Nemico)iterator.next();

    	if (tmp!=null && tmp.isUpdated(getTime())) {
			double bearing=NormaliseBearing(getHeading() + tmp.bearing - getRadarHeading());
		    if (Math.abs(bearing)>maxBearingAbs) { 
	        	maxBearingAbs=Math.abs(bearing); 
  	      		maxBearing=bearing; 
    	  	}
      		scannedBots++;
	    }
  	}

		double radarTurn=180*radarDirection;
  		if (scannedBots==getOthers()) 		
    		radarTurn=maxBearing+sign(maxBearing)*22.5; 

		setTurnRadarRight(radarTurn);
		radarDirection=sign(radarTurn);
	}
	
	private int sign(double numero) {
		if(numero>=0) return 1;
		else return -1;
	}

	
	public void scansiona2(int caso) {
		double RadarHeading;
		long start,move;
		boolean A,B,C,D;
		
		if(RadarControl.test()) {
			RadarHeading=getRadarHeading();
		
			A=(getX()<(getWidth()+20));
			B=(getY()<(getWidth()+20));
			C=(getX()>(getBattleFieldWidth()-getWidth()-20));
			D=(getY()>(getBattleFieldHeight()-getWidth()-20));
		
			move=360;
			if((A && B) || (C && D)) {
				move=90;
			}
			if((A || B || C || D) && !((A && B) || (C && D))) {
				move=180;
			}
			
			start=0;
			if(!A && B && !C && !D) {
				start=-90;
			}
			if(!A && !B && !C && D) {
				start=90;
			}
			if(!A && !B && C) {
				start=-180;
			}
			
			setTurnRadarRight(360);
		}
	}
	
	void fuga () {
		boolean bCurva;
		Nemico prossimo;
		Random Caso=new Random();
		
		if(getDistanceRemaining()<30)
			setAhead(2000);
		// Check the wall distance
		if(getTurnRemaining()<2) {
			bCurva=false;
			if(getX()<180) {
				if(getHeading()>270)
					setTurnRight(100);
				if(getHeading()<=270 && getHeading()>180)
					setTurnLeft(100);
				bCurva=true;
			}
			if(getY()<180) {
				if(getHeading()<270 && getHeading()>180)
					setTurnRight(100);
				if(getHeading()<=180 && getHeading()>90)
					setTurnLeft(100);
				bCurva=true;
			}
			if(getX()>(getBattleFieldWidth()-180)) {
				if(getHeading()>90 && getHeading()<180)
					setTurnRight(100);
				if(getHeading()>0 && getHeading()<=90)
					setTurnLeft(100);
				bCurva=true;
			}
			if(getY()>(getBattleFieldHeight()-180)) {
				if(getHeading()>=0 && getHeading()<90)
					setTurnRight(100);
				if(getHeading()>270)
					setTurnLeft(100);
				bCurva=true;
			}
			
			//Check for vicino
			if(maintTarget!=null && !bCurva)
				if(maintTarget.distance<(400-Nemici.size()*30))
					if(maintTarget.bearing>getHeading())
						setTurnRight(30);
					else
						setTurnLeft(30);
						
			
			//Curve randomiche
			if(Caso.nextLong()>0.06 && !bCurva)
				if(Caso.nextLong()>0.05)
					setTurnLeft(30);
				else
					setTurnRight(30);
					
			// cerco se ci sono robots in traiettoria
			if(!Nemici.isEmpty()) {
				Iterator coreIter =Nemici.values().iterator();
				while(coreIter.hasNext()) {
					prossimo=(Nemico)coreIter.next();
					if(Math.abs(prossimo.bearing)<10 && prossimo.distance<=200) {
						out.println("Spostati");
						if(prossimo.bearing>=0)
							setTurnLeft(60);
						else
							setTurnRight(60);
					}
	      }
			}
			
			
		}
		
	}
	
	void gira () {
		double angolo;
		
		if(getHeading()>270) {
			setTurnRight(360-getHeading());
			setAhead(200);
		}
		else
			if(getHeading()>180) {
				setTurnRight(270-getHeading());
				setAhead(200);
			}
			else
				if(getHeading()>90) {
					setTurnLeft(getHeading()-90);
					setAhead(200);
				}
				else
					if(getHeading()>0) {
						setTurnLeft(getHeading());
						setAhead(200);
					}	
		execute();
	}
	
	public void mira() {
		double gunDiff;
		double firePower=0;
		Nemico vicino;
		
		clearAllEvents();
		maintTarget=cercaVicino();
		
			
	if(maintTarget!=null && GunControl.test() && getEnergy()>0.15) {
			firePower=(400/maintTarget.distance);
			if(firePower>3)
				firePower=3;
			if(getEnergy()>1 && 10>getEnergy())
				firePower=0.5;
			if(getEnergy()>0.1 && 1>getEnergy())
				firePower=getEnergy()-0.1;
      		//works out how long it would take a bullet to travel to where the enemy is *now*
      		//this is the best estimation we have, without using a complicated iteration
      		long time = getTime() + (int)(maintTarget.distance/(20-(3*firePower)));

      		//offsets the gun by the angle to the next shot based on linear targeting provided by the enemy class
      		double gunOffset = getGunHeadingRadians() - absbearing(getX(),getY(),maintTarget.guessX(time),maintTarget.guessY(time));
      		setTurnGunLeftRadians(NormaliseBearing(gunOffset));
			fire(firePower);
		}
	}
	
	Nemico cercaVicino () {
		int i;
		Nemico vicino,prossimo;
		
		if(! Nemici.isEmpty()) {
			Iterator coreIter =Nemici.values().iterator();
			vicino=(Nemico)coreIter.next();
			while(coreIter.hasNext()) {
				prossimo=(Nemico)coreIter.next();
	        	if(prossimo.distance<vicino.distance) {
					vicino=prossimo;
				} 
	       	}
			return vicino;
		}
		return null;
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		Nemico presente;
	
		presente=(Nemico)Nemici.get(e.getName());
		if(presente==null)
			Nemici.put(e.getName(),new Nemico(e,getX(),getY(),getHeadingRadians(),getTime()));
		else
			presente.refresh(e,getX(),getY(),getHeadingRadians(),getTime());
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		if(getTurnRemaining()<2) {
			if(e.getBearing()>0)
				setTurnLeft(40);
			else
				setTurnRight(40);
			execute();
		}
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		Nemici.remove(e.getName());
		if(maintTarget.name==e.getName())
			maintTarget=null;
	}
	
	public void onHitWall(HitWallEvent event) {
		if(event.getBearing()>0) {
			setTurnLeft(100);
			setBack(40);
		}
		else {
			setTurnRight(100);
			setBack(40);
		}
		execute();
	}
	
	public void onHitRobot(HitRobotEvent event) {
     	if (event.getBearing() > -90 && event.getBearing() <= 90) {
       		setBack(100);
			}
   	}
	
	public void onCustomEvent(CustomEvent e) {
  	if (e.getCondition() instanceof RadarTurnCompleteCondition) scansiona();
	}


double NormaliseBearing(double ang) {
        if (ang > PI)
        ang -= 2*PI;
        if (ang < -PI)
        ang += 2*PI;
        return ang;
}
	//returns the distance between two x,y coordinates
public double getrange( double x1,double y1, double x2,double y2 )
{
        double xo = x2-x1;
        double yo = y2-y1;
        double h = Math.sqrt( xo*xo + yo*yo );
        return h;
}

//gets the absolute bearing between to x,y coordinates
public double absbearing( double x1,double y1, double x2,double y2 )
{
        double xo = x2-x1;
        double yo = y2-y1;
        double h = getrange( x1,y1, x2,y2 );
        if( xo > 0 && yo > 0 )
        {
                return Math.asin( xo / h );
        }
        if( xo > 0 && yo < 0 )
        {
                return Math.PI - Math.asin( xo / h );
        }
        if( xo < 0 && yo < 0 )
        {
                return Math.PI + Math.asin( -xo / h );
        }
        if( xo < 0 && yo > 0 )
        {
                return 2.0*Math.PI - Math.asin( -xo / h );
        }
        return 0;
}

}




