package dsekercioglu.mega.wfMove;

import dsekercioglu.mega.wfMove.Lightning.BattleInfo;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import static robocode.util.Utils.normalRelativeAngle;

public class Wave {

    public Point2D.Double fireLocation;
    public Point2D.Double enemyLocation;
    public int timeLeft;

    public double waveVelocity;
    public double waveDamage;
    public double distanceTraveled;
    public double absBearing;
    public int lateralDirection;

    public double maxEscapeAngle;
    public int binNum;
    public double binWidth;

    public double[] bins;
    public double[] shadows;
    public BattleInfo data;

    public boolean hitBot = false;

    public boolean visitedBot = false;

    public int fireTime;

    Object information;

    public ArrayList<Line2D.Double> bulletSegments = new ArrayList<>();
    public ArrayList<Line2D.Double> binSegments = new ArrayList<>();

    public Wave(double power, Point2D.Double fireLocation, Point2D.Double enemyLocation, int lateralDirection, int fireTime) {
        this.fireLocation = (Point2D.Double) fireLocation.clone();
        this.enemyLocation = (Point2D.Double) enemyLocation.clone();
        this.lateralDirection = lateralDirection;
        absBearing = MoveUtils.absoluteBearing(fireLocation, enemyLocation);
        waveVelocity = 20 - 3 * power;
        distanceTraveled = waveVelocity * 2;
        waveDamage = 4 * power + 2 * Math.max(0, power - 1);
        maxEscapeAngle = MoveUtils.calculateMEA(waveVelocity);
        this.fireTime = fireTime;
    }

    public void addShadow(Point2D.Double bulletLocation, double bulletSpeed, double bulletAngle) {
        Point2D.Double previousBulletLocation = MoveUtils.project(bulletLocation, bulletAngle, -bulletSpeed);
        Line2D.Double bulletSegment = new Line2D.Double(previousBulletLocation, bulletLocation);
        bulletSegments.add(bulletSegment);
        int pblBin = getBinOutOfBounds(previousBulletLocation);
        int cblBin = getBinOutOfBounds(bulletLocation);
        int minBin = Math.min(pblBin, cblBin);
        int maxBin = Math.max(pblBin, cblBin);
        if (!(minBin < 0 && maxBin > binNum - 1)) {
            for (int i = Math.max(minBin, 0); i <= Math.min(maxBin, binNum - 1); i++) {
                int bin = i - (binNum / 2);
                double binAngle = absBearing + bin * binWidth * lateralDirection;
                Line2D.Double binSegment = new Line2D.Double(MoveUtils.project(fireLocation, binAngle, distanceTraveled),
                        MoveUtils.project(fireLocation, binAngle, distanceTraveled - waveVelocity));
                binSegments.add(binSegment);
                if (binSegment.intersectsLine(bulletSegment)) {
                    shadows[i] = 1;
                }
            }
        }
    }

//    public void addShadow(ShadowBullet b) {
//        Point2D.Double bulletLocation = b.location;
//        double bulletAngle = b.absBearing;
//        double bulletSpeed = b.speed;
//        Point2D.Double previousBulletLocation = MoveUtils.project(bulletLocation, bulletAngle, -bulletSpeed);
//        Line2D.Double bulletSegment = new Line2D.Double(previousBulletLocation, bulletLocation);
//        bulletSegments.add(bulletSegment);
//        int pblBin = getBinOutOfBounds(previousBulletLocation);
//        int cblBin = getBinOutOfBounds(bulletLocation);
//        int minBin = Math.min(pblBin, cblBin);
//        int maxBin = Math.max(pblBin, cblBin);
//        if (!(minBin < 0 && maxBin > binNum - 1)) {
//            for (int i = Math.max(minBin, 0); i <= Math.min(maxBin, binNum - 1); i++) {
//                int bin = i - (binNum / 2);
//                double binAngle = absBearing + bin * binWidth * lateralDirection;
//                Line2D.Double binSegment = new Line2D.Double(MoveUtils.project(fireLocation, binAngle, distanceTraveled),
//                        MoveUtils.project(fireLocation, binAngle, distanceTraveled - waveVelocity));
//                binSegments.add(binSegment);
//                if (binSegment.intersectsLine(bulletSegment)) {
//                    shadows[i] = 1;
//                }
//            }
//        }
//    }
    public void setData(BattleInfo data) throws CloneNotSupportedException {
        this.data = (BattleInfo) data.clone();
    }

    public void setBins(double[] bins) {
        this.bins = bins.clone();
        binNum = bins.length;
        this.shadows = new double[binNum];
        binWidth = maxEscapeAngle / (binNum / 2);
    }

    public void setInformation(Object information) {
        this.information = information;
    }

    public boolean update(Point2D.Double enemyLocation) {
        binSegments = new ArrayList<>();
        bulletSegments = new ArrayList<>();
        distanceTraveled += waveVelocity;
        timeLeft = (int) ((fireLocation.distance(enemyLocation) - distanceTraveled - 18) / waveVelocity);
        if (distanceTraveled > fireLocation.distance(enemyLocation)) {
            return true;
        }
        return false;
    }

    public boolean remove(Point2D.Double enemyLocation) {
        return distanceTraveled > fireLocation.distance(enemyLocation) + 25;
    }

    public int getBin(Point2D.Double location) {
        double angleDif = normalRelativeAngle(MoveUtils.absoluteBearing(fireLocation, location) - absBearing);
        return (int) MoveUtils.limit(0, Math.round((angleDif / (lateralDirection * binWidth)) + (binNum / 2)), binNum - 1);
    }

    public double getExactBin(Point2D.Double location) {
        double angleDif = normalRelativeAngle(MoveUtils.absoluteBearing(fireLocation, location) - absBearing);
        return MoveUtils.limit(0, angleDif / (lateralDirection * binWidth) + (binNum / 2), binNum - 1);
    }

    public int getBinOutOfBounds(Point2D.Double location) {
        double angleDif = normalRelativeAngle(MoveUtils.absoluteBearing(fireLocation, location) - absBearing);
        return (int) Math.round((angleDif / (lateralDirection * binWidth)) + (binNum / 2));
    }
}
