package dsekercioglu.mega.wfMove.move.formulas;

import dsekercioglu.mega.wfMove.Lightning;
import java.util.Arrays;

public class FormulaSimple2 extends Formula {

    private final double[] WEIGHTS = {3, 1, 1, 2};

    @Override
    public double[] getDataPoint(Lightning.BattleInfo data) {
        double[] dataPoint = {Math.abs(data.velocity) / 8,
            (data.relativeHeading) / Math.PI,
            data.distance / 1000,
            Math.min(data.getMEA(1) / Math.PI * 2, 1)};
        return dataPoint;
    }

    @Override
    public double[] getWeights() {
        return WEIGHTS;
    }

    @Override
    public Formula setDecay(double d) {
        WEIGHTS[WEIGHTS.length - 1] = d;
        return this;
    }

}
