package nat.radar;

import robocode.RobotStatus;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;

import nat.base.EventListener;
import nat.base.Logger;
import nat.base.Radar;
import nat.base.Time;
import nat.base.actors.RadarActor;
import nat.gfx.RobocodeGraphics;
import nat.utils.M;

public class DuelRadar extends EventListener implements Radar {
	private RobotStatus status;
	private Time time;
	private double enemyBearing, enemyDistance;
	private long lastScanTime = -1;

	private final Logger logger;

	public DuelRadar(Logger logger, RobocodeGraphics g) {
		this.logger = logger;
	}

	@Override
	public void doRadar(RadarActor actor) {
		if (time.getOthers() == 0) {
			// TODO do radar victory dance
		} else if (lastScanTime != time.getTime()) {
			if (time.getTime() > 10 && lastScanTime != -1) {
				logger.log("WARNING: Lost radar lock");
			}
			actor.turnRadar(Double.POSITIVE_INFINITY);
		} else {
			double radarTurn = M.normalRelativeAngle(enemyBearing
					- status.getRadarHeadingRadians());
			double botWidth = M.atan(25d / enemyDistance);
			radarTurn += botWidth * M.sign(radarTurn);
			actor.turnRadar(radarTurn);
		}
	}

	@Override
	public void onScannedRobot(ScannedRobotEvent e) {
		enemyBearing = status.getHeadingRadians() + e.getBearingRadians();
		enemyDistance = e.getDistance();
		lastScanTime = e.getTime();
	}

	@Override
	public void onStatus(StatusEvent e, Time time) {
		status = e.getStatus();
		this.time = time;
	}
}
