package gg;
import robocode.*;
import java.util.*;
import java.awt.Color;

public class Wolverine extends AdvancedRobot {
    static int currentTime;
    static int dodgeStopRobotMode;
    static int colorMode;
    Random rand;
    Hashtable lastUpdateTimes;
    
    int logLength;
    double pi;
    double maxGunTurn;
    double maxBotTurn;
    double maxScanTurn;
    Condition aTurn;
    
    static {
        dodgeStopRobotMode = 0;
        colorMode = 0;
        currentTime = 0;
    }
    
    {
        rand = new Random();
        lastUpdateTimes = new Hashtable();
        logLength = 2000;
        pi = Math.PI;
        maxScanTurn = 45.0/360.0*pi*2;
        maxGunTurn = 20.0/360.0*pi*2;
        maxBotTurn = 10.0/360.0*pi*2;
        aTurn = null;
    }
    
    class ShotModel {
        double angle;
        double power;
    }
    class Position {
        double x;
        double y;
    }
    
    
    double shotPowerCurrent;
    boolean isShooting;
    
    int maxTurnsToAttemptDisable = 50;
    
    RobotLog log;
    /* 
     * This run method is where I connect up all the sensory methods to the 
     * action methods.  The entire strategy of the bot is in this method.
     */
    public void run() {
        
        log = new RobotLog(this);
        
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
        
        setColorsNormal();
        
        while(true) {
            
            String closestRobotName = getClosestRobotName();
            
            if (getOthers()==0) {
                doVictoryDance();
            } else if (closestRobotName.equals("") && getOthers()>0) {
                // This is the case where no bots have been seen yet
                // Scan quickly
                setTurnRightRadians(maxBotTurn);
                setTurnGunRightRadians(maxGunTurn);
                setTurnRadarRightRadians(maxScanTurn);
            } else if (log.get(closestRobotName).life>0 && log.get(closestRobotName).life<16 && getEnergy()>25 && maxTurnsToAttemptDisable>0) {
                // Limit number of turns to attempt to disable.
                maxTurnsToAttemptDisable--;
                shootToDisable(closestRobotName);
            } else if (log.get(closestRobotName).life==0) {
                fatalityBurstFire(closestRobotName);
            } else if (getOthers()>1) {
                if (getEnergy()>12){
                    if (getDistToBot(closestRobotName)>200) {
                        setTurnRadarRightRadians(maxScanTurn);
                        //directFireOn(closestRobotName,3);
                        simpleFireOn(closestRobotName,3);
                        hugWalls();
                    } else {
                        watchRobot(closestRobotName);
                        fireOn(closestRobotName,3);
                        dodgeStopRobot(closestRobotName);
                    }
                } else {
                    setTurnRadarRightRadians(maxScanTurn);
                    hugWalls();
                }
                
            } else if(getOthers()==1) {
                
                watchRobot(closestRobotName);
                if (getDistToBot(closestRobotName)>500) {
                    fireOn(closestRobotName,.1);
                } else {
                    fireOn(closestRobotName,3);
                }
                
                if (isLifeAheadBy(60)) {
                    chaseRobot(closestRobotName);
                    if (isLifeAheadBy(70)) {
                        setColorsAttack();
                    }
                } else {
                    if (getDistToBot(closestRobotName)>300) {
                        chaseDodgeRobot(closestRobotName);
                    } else {
                        dodgeStopRobot(closestRobotName);
                    }
                }
            }
            
            executeActions();
        }
    }
    public void executeActions(){
        currentTime++;
        if (isShooting) {
            // Fire and move
            fire(shotPowerCurrent);
            isShooting = false;
        } else {
            // Only move
            execute();
        }
    }
    
    
    ////////////////////////////////////////////////////////////////////////////
    ///////////// Movement /////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    double direction;
    double dodgeMode; {
        direction = 1;
        dodgeMode = 1;
    }
    void dodgeBulletsRobot(String robotName) {
        RobotModel bot = log.get(robotName);
        double angle = getAngle(bot.x, bot.y);
        if (bot.shot>0) {
            dodgeMode++;
            if (dodgeMode>2) dodgeMode=1;
            
        }
        if (dodgeMode == 1) {
            setMaxVelocity(8+rand.nextInt(10)/10.0);
            setAhead(100*direction);
            setTurnRightRadians(getBotTurn(angle+(pi/2)-direction*(pi/6))+(rand.nextInt(10)-5)/20.0);
        } else if (dodgeMode == 2) {
            setAhead(rand.nextInt(5)-1);
        } else if (dodgeMode == 3) {
            setMaxVelocity(8+rand.nextInt(10)/10.0);
            setAhead(-100);
            setTurnRightRadians(getBotTurn(angle+2*pi/3)+(rand.nextInt(10)-5)/20.0);
        }
        
    }
    int tact = 1;
    void chaseDodgeRobot(String robotName) {
        RobotModel bot = log.get(robotName);
        double angle = getAngle(bot.x, bot.y);
        
        if (bot.shot>0) {
            tact = -tact;
        }
        setMaxVelocity(8);
        setAhead(100);
        
        setTurnRightRadians(getBotTurn(angle+tact*(pi/8))+(rand.nextInt(10)-5)/20.0);
    }
    
    int numberOfTurnsToMove;
    void dodgeStopRobot(String robotName) {
        RobotModel bot = log.get(robotName);
        double angle = getAngle(bot.x, bot.y);
        double distToBot = getDist(bot.x, bot.y,getX(),getY());
        
        if (log.get(robotName).recharge>0) {
            if (dodgeStopRobotMode!=1){
                dodgeStopRobotMode=1;
            }
        }
        
        if (bot.shot>0) {
            // randomize dist
            int maxIndex = Math.min(3,1+(int)distToBot/200);
            maxIndex = Math.max(0,maxIndex);
            int destinations[] = {8,12,17,22,27};
            int destIndex = rand.nextInt(maxIndex);
            numberOfTurnsToMove = destinations[destIndex];
            
            // begin movement part of dodge mode
            dodgeMode=1;
            
            if (dodgeStopRobotMode == 0) {
                // Keep going straight
                if (getVelocity()>0)numberOfTurnsToMove=0;
            }else if (dodgeStopRobotMode == 1) {
                // Reverse direction
                direction = -direction;
                
                dodgeStopRobotMode = 0;
                
            }else if (dodgeStopRobotMode == 2) {
                if (getVelocity()>0)numberOfTurnsToMove=0;
            }
            
            
        }
        setMaxVelocity(0);
        setAhead(0);
        if (dodgeMode == 0) {
            setTurnRightRadians(getBotTurn(angle+(pi/2)));
        }
        if (dodgeMode == 1) {
            setAhead(100*direction);
            setMaxVelocity(7+rand.nextInt(10)/10.0);
            
            if (distToBot>250) {
                // if far, move in
                setTurnRightRadians(getBotTurn(angle+(pi/2)-direction*(pi/4))+(rand.nextInt(10)-5)/20.0);
            } else if (distToBot>150) {
                // if at a good range, move in slowly
                setTurnRightRadians(getBotTurn(angle+(pi/2)-direction*(pi/6))+(rand.nextInt(10)-5)/20.0);
            } else {
                // if near, move away
                setTurnRightRadians(getBotTurn(angle+(pi/2)+direction*(pi/8))+(rand.nextInt(10)-5)/20.0);
            }
            numberOfTurnsToMove--;
            if (numberOfTurnsToMove<0){
                dodgeMode = 0;
            }
        }
    }
    
    void sineEvadeRobot(String robotName) {
        RobotModel bot = log.get(robotName);
        double angle = getAngle(bot.x, bot.y);
        double angleToTurn = getBotTurn(angle+(pi/2));
        double speed = 5+rand.nextInt(10)/10.0+1.5*Math.sin(currentTime/8.0);
        
        setTurnRightRadians(angleToTurn);
        if (Math.abs(angleToTurn)<.5){
            setMaxVelocity(speed);
        } else {
            setMaxVelocity(0);
        }
        setAhead(100*direction);
    }
    void stopNGoEvadeRobot(String robotName) {
        RobotModel bot = log.get(robotName);
        double angle = getAngle(bot.x, bot.y);
        setTurnRightRadians(getBotTurn(angle+(pi/2))+(rand.nextInt(10)-5)/20.0);
        if (currentTime%15>7) {
            setMaxVelocity(8);
        } else {
            setMaxVelocity(0);
        }
        setAhead(100*direction);
    }
    
    void spaceInvaders(String robotName) {
        if (getY()>35) {
            goTo(getX(),25);
        } else {
            setTurnRightRadians(getBotTurn(pi/2));
            
            RobotModel bot = log.get(robotName);
            
            if (getDistToBot(robotName)>300) {
                if (getX()<getBattleFieldWidth()/2) setAhead(100);
                if (getX()>getBattleFieldWidth()/2) setAhead(-100);
            } else {
                if (bot.x>getX()) setAhead(-100);
                if (bot.x<getX()) setAhead(100);
            }
            setMaxVelocity(8);
        }
        
    }
    
    double distFromSide(double x, double y) {
        double distX = Math.min(getBattleFieldWidth()-x,x);
        double distY = Math.min(getBattleFieldHeight()-y,y);
        return Math.min(distY,distX);
    }
    
    void patternRandom() {
        if (getDistanceRemaining()==0) {
            setAhead(rand.nextInt(70)*(rand.nextBoolean()?1:-1)+25);
        }
        if (getTurnRemaining()==0) {
            setTurnRightRadians(rand.nextInt(40)/10-2);
        }
    }
    
    void pattern3() {
        if (currentTime%16>5) {
            setMaxVelocity(8);
        } else {
            setMaxVelocity(0);
        }
        if ((currentTime-4)%16<7) {
            setTurnRightRadians(999);
        } else {
            setTurnRightRadians(0);
        }
        setAhead(100);
    }
    
    void escapeRobot(String robotName) {
        RobotModel bot = log.get(robotName);
        double angle = getAngle(bot.x, bot.y);
        double targetDist = 300;
        
        double myDistFromSide = distFromSide(getX(),getY());
        double botDistFromSide = distFromSide(bot.x,bot.y);
        
        if (myDistFromSide>100) {
            setMaxVelocity(8);
            double turn = getBotTurn(angle);
            if (turn>pi/2) {
                turn = turn-pi;
                direction = -1;
            } else if (turn<-pi/2) {
                turn = turn+pi;
                direction = -1;
            } else {
                direction = 1;
            }
            setTurnRightRadians(turn);
            setAhead(-100*direction);
        } else {
            // If robot is near, dodgeStopRobot(robotName);
            setMaxVelocity(8);
            setTurnRightRadians(getBotTurn(angle+pi/2));
            setAhead(-100*direction);
        }
        
        if (currentTime%15>7) {
            setMaxVelocity(8);
        } else {
            setMaxVelocity(0);
        }
    }
    
    void evadeRobot(String robotName) {
        RobotModel bot = log.get(robotName);
        double angle = getAngle(bot.x, bot.y);
        setTurnRightRadians(getBotTurn(angle+pi/2));
    }
    
    void hugWalls() {
        double turn =0;
        if (distFromSide(getX(),getY())>120) {
            // Get close to the walls first
            double x = log.get(getClosestRobotName()).x;
            double y = log.get(getClosestRobotName()).y;
            double angle = getAngle(x, y);

            turn = getBotTurn(angle+pi);
            setMaxVelocity(8);
            setAhead(100);
        } else {
            Position p1 = getClockwisePosition();
            Position p2 = getCounterClockwisePosition();
            Position p = null;
            
            double p1Danger = getDangerLevel(p1.x,p1.y);
            double p2Danger = getDangerLevel(p2.x,p2.y);
            
            if (p1Danger<p2Danger) {
                p=p1;
            } else {
                p=p2;
            }
            
            double angle = getAngle(p.x, p.y);
            turn = getBotTurn(angle);
            
            // start and stop
            if (currentTime%20<4) {
                setMaxVelocity(0);
            } else {
                setMaxVelocity(8);
            }
        }
        if (turn>pi/2) {
            turn = turn-pi;
            direction = -1;
        } else if (turn<-pi/2) {
            turn = turn+pi;
            direction = -1;
        } else {
            direction = 1;
        }
        setTurnRightRadians(turn);
        setAhead(100*direction);
    }
    
    Position getClockwisePosition() {
        return getWallAviodedPosition(1);
    }
    Position getCounterClockwisePosition() {
        return getWallAviodedPosition(-1);
    }
    Position getWallAviodedPosition(int dodgeDirection) {
        double turnRadius = 120*dodgeDirection;
        double angle = getHeadingRadians();
        double goalX = getX()+turnRadius*Math.sin(angle);
        double goalY = getY()+turnRadius*Math.cos(angle);
        
        while (!isInBounds(goalX,goalY)) {
            angle+=pi/16*dodgeDirection;
            goalX = getX()+turnRadius*Math.sin(angle);
            goalY = getY()+turnRadius*Math.cos(angle);
        }
        
        Position p = new Position();
        p.x=goalX;
        p.y=goalY;
        return p;
    }
    
    
    void chaseRobot(String robotName) {
        RobotModel bot = log.get(robotName);
        double angle = getAngle(bot.x, bot.y);
        setTurnRightRadians(getBotTurn(angle));
        setMaxVelocity(8);
        setAhead(10);
    }
    
    void shootToDisable(String robotName) {
        // Wait for it to run out of power
        watchRobot(robotName);
        dodgeStopRobot(robotName);
        double shotPower = getPowerNeededToDisable(robotName);
        fireOn(robotName,shotPower);
    }
    int fatalityBurstFireMode=0;
    void fatalityBurstFire(String robotName) {
        if (fatalityBurstFireMode==0) {
                fatalityBurstFireMode = 1;
        }
        if (fatalityBurstFireMode==1) {
            // Go to a corner
            watchRobot(robotName);
            goToCorner();
            if (isNearCorner()) {
                fatalityBurstFireMode = 2;
            }
            if (log.get(robotName).life!=0) {
                fatalityBurstFireMode = 0;
            }
        }
        if (fatalityBurstFireMode==2) {
            // Wait for right time
            watchRobot(robotName);
            RobotModel bot = log.get(robotName);
            double angle = getAngle(bot.x, bot.y);
            setTurnRightRadians(getBotTurn(angle));
            if (currentTime%80==0) {
                fatalityBurstFireMode = 3;
            }
            if (log.get(robotName).life!=0) {
                fatalityBurstFireMode = 0;
            }
        }
        if (fatalityBurstFireMode==3) {
            // Execute fatality
            watchRobot(robotName);
            burstFireOn(robotName);
            if (log.get(robotName).life!=0) {
                fatalityBurstFireMode = 0;
            }
        }
    }
    double getPowerNeededToDisable(String robotName) {
        RobotModel bot = log.get(robotName);
        double energy = bot.life;
        double shotPower = 0;
        double damage = 0;
        if (energy>3+16) {
            while (energy-damage>0 && shotPower<3) {
                shotPower+=.1;
                if (shotPower<1) damage=shotPower*4;
                else damage=(shotPower*6)-2;
            }
        } else if (energy>0) {
            // Slow down
            while (energy-damage>3.6 && shotPower<3) {
                shotPower+=.1;
                if (shotPower<1) damage=shotPower*4;
                else damage=(shotPower*6)-2;
            }
        }
        return shotPower;
    }
    
    String getClosestRobotNameTo(String targetBot) {
        RobotModel botModel = log.get(targetBot);
        return getClosestRobotNameTo(targetBot, botModel.x, botModel.y);
    }
    String getClosestRobotNameTo(String targetBot, double x, double y) {
        String[] botArray = log.getLivingBotNames();
        double currentDist=0;
        double closestDist=99999;
        String closestBotName = "";
        int currentTime = log.getCurrentTime();
        if (targetBot.equals(getName())){
            // Look for tobot closest to this
            for (int botIndex = 0; botIndex<botArray.length; botIndex++) {
                String botName = (String)botArray[botIndex];
                RobotModel botModel = log.get(botName);
                currentDist = getDist(x,y,botModel.x,botModel.y);
                if (currentDist<closestDist && log.get(botName).time>-9) {
                    closestDist = currentDist;
                    closestBotName = botName;
                }
            }
        } else {
            // Look for tobot closest to targetBot
            RobotModel botTarget = log.get(targetBot);
            for (int botIndex = 0; botIndex<botArray.length; botIndex++) {
                String botName = (String)botArray[botIndex];
                if (!botName.equals(targetBot)){
                    RobotModel botModel = log.get(botName);
                    currentDist = getDist(x,y,botModel.x,botModel.y);
                    if (currentDist<closestDist && log.get(botName).time>currentTime-9) {
                        closestDist = currentDist;
                        closestBotName = botName;
                    }
                } else {
                    // Put this robot in in place of target
                    currentDist = getDist(x,y,getX(),getY());
                    if (currentDist<closestDist) {
                        closestDist = currentDist;
                        closestBotName = getName();
                    }
                }
            }
        }
        return closestBotName;
    }
    
    RobotModel getClosestBotTo(double x, double y) {
        String [] botArray = log.getLivingBotNames();
        double dist = 99999;
        RobotModel bot=null;
        for (int botIndex = 0; botIndex<botArray.length; botIndex++) {
            String botName = (String)botArray[botIndex];
            RobotModel currentBot = log.get(botName);
            double currentDist = getDist(currentBot.x, currentBot.y, x, y);
            if (currentDist<dist) {
                dist = currentDist;
                bot = currentBot;
            }
        }
        return bot;
    }
    String getClosestRobotName() {
        return getClosestRobotNameTo(getName(),getX(),getY());
    }
    
    double getTotalDamageFrom(String botName, int timeSpan) {
        double totalDamage=0;
        int currentTime = log.getCurrentTime();
        for (int timeIndex = 0; timeIndex<timeSpan; timeIndex++) {
            RobotModel botModel = log.get(botName, currentTime-timeIndex);
            // Since damage and recharge corrilate, we'll use recharge until
            // we have team information.
            totalDamage += botModel.recharge;
        }
        return totalDamage;
    }
    
    double getDangerLevel(double x, double y) {
        double dangerTally = 0;
        String[] botArray = log.getLivingBotNames();
        for (int botIndex = 0; botIndex<botArray.length; botIndex++) {
            String botName = (String)botArray[botIndex];
            RobotModel botModel = log.get(botName);
            double dangerHittingMe = getTotalDamageFrom(botName,60)*10000;
            double dangerTargettingMe = getClosestRobotNameTo(botName, x, y).equals(getName())?1000:0;
            double dangerDistance = getDist(botModel.x, botModel.y, x, y);
            double dangerLevel = (10+dangerHittingMe+dangerTargettingMe)/dangerDistance;
            dangerTally += dangerLevel;
        }
        return dangerTally;
    }
    
    boolean isLifeAheadBy(int i) {
        // Assume unseen bots have full life
        double lifeTally = getOthers()*100;
        Object[] botArray = log.getLivingBotNames();
        for (int botIndex = 0; botIndex<botArray.length; botIndex++) {
            String botName = (String)botArray[botIndex];
            RobotModel botModel = log.get(botName);
            lifeTally = lifeTally + botModel.life - 100;
        }
        return getEnergy()>lifeTally+i;
    }
    
    public void onHitWall(HitWallEvent event){
        direction=-direction;
        setAhead(100*direction);
    }
    public void onDeath(DeathEvent event){
        // If i lost, change movement strategy
        dodgeStopRobotMode = (dodgeStopRobotMode+1)%3;
        setColorsNormal();
    }
    
    ////////////////////////////////////////////////////////////////////////////
    ///////////// End Movement /////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    
    ////////////////////////////////////////////////////////////////////////////
    ///////////// Melee ////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    void goTo(double x, double y) {
        double angle = getAngle(x, y);
        RobotModel bot = getClosestBotTo(getX(),getY());
        double offestAngle = 0;
        double speed = 8.0;
        if (bot!=null) {
            double botAngle = getAngle(bot.x, bot.y);
            double angleDiff = angleDiff(botAngle, angle);
            double dist = getDist(bot.x, bot.y, getX(), getY());
            if ((angleDiff>-pi/2 && angleDiff < pi/2 && dist<200 ) || (angleDiff>-pi/4 && angleDiff < pi/4 )) {
                if (dist<70) {
                    double goalAngle = botAngle+pi/1.5*(angleDiff>0?-1:1);
                    if (Math.abs(getHeadingRadians()-goalAngle)>.05) speed = 0;
                    offestAngle = goalAngle-angle;
                } else {
                    offestAngle = (pi/2-Math.abs(angleDiff)) * ((angleDiff>0)?-1:1);
                    if (dist<100) {
                        speed = (pi/2-getTurnRemainingRadians())/pi*2*3+5;
                    } else {
                        speed = 8;
                    }
                }
            }
        }
        
        // If we're next to the edge, dont try to dodge.
        if (isNextToEdge()) {
            offestAngle = 0;
            speed = 8;
        }
        setTurnRightRadians(getBotTurn(angle+offestAngle));
        setMaxVelocity(speed);
        setAhead(100);
    }
    
    
    int cornerHidingMode;
    double cornerTargetX;
    double cornerTargetY;
    double[][] corners;
    int cornerTest; {
        cornerHidingMode=1;
        cornerTargetX=60;
        cornerTargetY=60;
        corners = null;
        cornerTest=1;
    }
    
    void findBestCorner() {
        if (corners==null) {
            corners = new double[][] {{40,40},{getBattleFieldWidth()-40,40},{40,getBattleFieldHeight()-40},{getBattleFieldWidth()-40,getBattleFieldHeight()-40}};
        }
        Object[] botArray = log.getLivingBotNames();
        
        double bestDiff = 0;
        for (int c=0; c<corners.length; c++) {
            // Find own dist
            double myDist=getDist(corners[c][0],corners[c][1],getX(),getY());
            // Find distance of others
            double totalDist=0;
            for (int botIndex = 0; botIndex<botArray.length; botIndex++) {
                String botName = (String)botArray[botIndex];
                RobotModel currentBot = log.get(botName);
                totalDist+=getDist(corners[c][0],corners[c][1],currentBot.x,currentBot.y);
            }
            // Get difference
            double distDiff = totalDist/botArray.length;
            
            if (distDiff > bestDiff){
                bestDiff = distDiff;
                cornerTargetX=corners[c][0];
                cornerTargetY=corners[c][1];
            }
        }
    }
    
    boolean isNearCorner() {
        findBestCorner();
        double distToCorner = getDist(cornerTargetX,cornerTargetY,getX(),getY());
        if (cornerHidingMode==0) {
            // run close to corner
            if (distToCorner<100) {
                cornerHidingMode = 1;
                cornerTest = (cornerTest+1)%4;
            }
        }
        if (cornerHidingMode==1) {
            // dont run to corner - we're close enough
            if (distToCorner>200) {
                cornerHidingMode = 0;
            }
        }
        return cornerHidingMode==1;
    }
    void goToCorner() {
        goTo(cornerTargetX,cornerTargetY);
    }
    boolean isNextToEdge() {
        double padding = 30;
        double x = getX();
        double y = getY();
        double x1 = padding;
        double y1 = padding;
        double x2 = getBattleFieldWidth()-padding;
        double y2 = getBattleFieldHeight()-padding;
        return (x<=x1 || y<=y1 || x>=x2 || y>=y2);
    }
    
    void guardCorner() {
        
        double x=0;
        double y=0;
        Object[] botArray = log.getLivingBotNames();
        for (int botIndex = 0; botIndex<botArray.length; botIndex++) {
            String botName = (String)botArray[botIndex];
            RobotModel currentBot = log.get(botName);
            x+=currentBot.x;
            y+=currentBot.y;
        }
        double angle = getAngle(x/botArray.length, y/botArray.length);
        
        setTurnRightRadians(getBotTurn(angle+pi/2));
        setMaxVelocity(8);
        
        if (currentTime%56<28) direction = 1;
        else direction = -1;
        
        if (currentTime%14<7) setAhead(1);
        else setAhead(10*direction);
    }
    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    ///////////// End Melee ////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    
    ////////////////////////////////////////////////////////////////////////////
    ///////////// From Memory //////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    
    void watchRobot(String robotName) {
        RobotModel bot = log.get(robotName);
        wideRadarTarget = getAngle(bot.x, bot.y);
        wideRadarScan();
    }
    
    void watchCenter() {
        wideRadarTarget = getAngle(getBattleFieldWidth()/2, getBattleFieldHeight()/2);
        
        double wideRadarAngle = 0;
        if (currentTime%6==0) wideRadarAngle = wideRadarTarget+pi*1/8;
        if (currentTime%6==1) wideRadarAngle = wideRadarTarget+pi*3/8;
        if (currentTime%6==2) wideRadarAngle = wideRadarTarget+pi*1/8;
        if (currentTime%6==3) wideRadarAngle = wideRadarTarget-pi*1/8;
        if (currentTime%6==4) wideRadarAngle = wideRadarTarget-pi*3/8;
        if (currentTime%6==5) wideRadarAngle = wideRadarTarget-pi*1/8;
        
        wideRadarAngle = getScanTurn(wideRadarAngle);
        
        setTurnRadarRightRadians(wideRadarAngle);
    }
    
    
    
    boolean isRobotsAlive(int i) {
        return getOthers()==i;
    }
    boolean isReadyToFire() {
        return getGunHeat()==0;
    }
    
    int fireOnTargetMode;
    ShotModel fireOnTargetShot; {
        fireOnTargetMode = 0;
    }
    
    void fireOn(String botName) {
        double botDistance = getDist(getX(),getY(),log.get(botName).x,log.get(botName).y);
        double shotPower = 3.0-(botDistance-150)/100;
        shotPower = Math.min(3.0, Math.max(0.1, shotPower));
        fireOn(botName, shotPower);
    }
    
    void fireOn(String botName, double shotPower) {
        if (fireOnTargetMode==0) {
            fireOnTargetShot = findBestShotOn(botName, shotPower);
            
            // If we cant calculate, use a more simple prediction
            if (fireOnTargetShot.power<=0){
                fireOnTargetShot = findSimpleProjectionShotOn(botName,shotPower);
            }
            
            if (fireOnTargetShot.power>0){
                setTurnGunRightRadians(getGunTurn(fireOnTargetShot.angle));
                fireOnTargetMode = 1;
            }
        }
        if (fireOnTargetMode==1) {
            if (getGunTurnRemaining()==0) {
                isShooting = true;
                shotPowerCurrent = fireOnTargetShot.power;
                fireOnTargetMode = 0;
            }
        }
    }
    void simpleFireOn(String botName) {
        double botDistance = getDist(getX(),getY(),log.get(botName).x,log.get(botName).y);
        double shotPower = 3.0-(botDistance-150)/100;
        shotPower = Math.max(shotPower,0.1);
        simpleFireOn(botName,shotPower);
    }
    void simpleFireOn(String botName, double shotPower) {
        if (fireOnTargetMode==0) {
            
            
            fireOnTargetShot = findSimpleProjectionShotOn(botName, shotPower);
            
            if (fireOnTargetShot.power>0){
                setTurnGunRightRadians(getGunTurn(fireOnTargetShot.angle));
                fireOnTargetMode = 1;
            }
        }
        if (fireOnTargetMode==1) {
            if (getGunTurnRemaining()==0) {
                isShooting = true;
                shotPowerCurrent = fireOnTargetShot.power;
                fireOnTargetMode = 0;
            }
        }
    }
    void directFireOn(String botName) {
        double botDistance = getDist(getX(),getY(),log.get(botName).x,log.get(botName).y);
        double power = 3.0-(botDistance-150)/100;
        directFireOn(botName,power);
    }
    void directFireOn(String botName, double power) {
        double botAngle = getAngle(log.get(botName).x,log.get(botName).y);
        shotPowerCurrent = power;
        setTurnGunRightRadians(getGunTurn(botAngle));
        isShooting = true;
    }
    
    int burstFireOnMode;
    double[] burstFireOnPowers; {
        burstFireOnMode = 0;
        burstFireOnPowers = new double[]{3,2.3,.1};
    }
    void burstFireOn(String botName) {
        if (currentTime%80==0) setAhead(-1000);
        if (currentTime%80==40) setAhead(1000);
        
        if (fireOnTargetMode==0) {
            
            double botDistance = getDist(getX(),getY(),log.get(botName).x,log.get(botName).y);
            
            double botAngle = getAngle(log.get(botName).x,log.get(botName).y);
            
            setTurnGunRightRadians(getGunTurn(botAngle));
            setTurnRightRadians(getBotTurn(botAngle));
            
            if (currentTime%80==50) {fireOnTargetMode = 1;burstFireOnMode=0;}
            if (currentTime%80==60) {fireOnTargetMode = 1;burstFireOnMode=1;}
            if (currentTime%80==70) {fireOnTargetMode = 1;burstFireOnMode=2;}
        }
        if (fireOnTargetMode==1) {
            if (getGunTurnRemaining()==0 && isReadyToFire()) {
                isShooting = true;
                shotPowerCurrent = burstFireOnPowers[burstFireOnMode];
                fireOnTargetMode = 0;
                burstFireOnMode=(burstFireOnMode+1)%3;
            }
        }
    }
    ShotModel findSimpleProjectionShotOn(String botName, double bulletPower) {
        ShotModel sm = new ShotModel();
        sm.power=0;
        
        // Predict next movements
        double currentAngle=0;
        double bestAngle=0;
        double currentGoodness=0;
        double bestGoodness=0;
        
        // Get the current position
        double botX=log.get(botName).x;
        double botY=log.get(botName).y;
        double botA=log.get(botName).angle;
        double botV=log.get(botName).v;
        double velocityDelta = 0;
        double angleDelta = 0;
        boolean isTurningRight = false;
        boolean isTurningLeft  = false;
        
        // If we have recorded the event before this, we gan guess more
        if (log.isBotRecorded(botName, log.getLastUpdateTime(botName)-1)) {
            angleDelta = log.get(botName).angle-log.get(botName, log.getLastUpdateTime(botName)-1).angle;
            velocityDelta = log.get(botName).v-log.get(botName, log.getLastUpdateTime(botName)-1).v;
        }
        
        int currentTime = log.getCurrentTime();
        int lagTime = currentTime - log.getLastUpdateTime(botName);
        
        for (int timeDelta=0; timeDelta<50; timeDelta++) {
            
            double bulletDist = 0;
            
            // Guess next speed
            botV = botV + velocityDelta;
            if (botV>8) botV = 8;
            if (botV<-8) botV = -8;
            
            // Guess next angle
            botA -= angleDelta;
            
            // Guess next position
            botX = botX + botV*Math.sin(botA);
            botY = botY + botV*Math.cos(botA);
            currentAngle = getAngle(botX, botY);
            
            double bulletSpeed = 20.0 - (3.0*bulletPower);
            // should calculate this based on angle
            int timeFoGunToTurn = 1;
            double bulletDistance = (timeDelta-lagTime-timeFoGunToTurn)*bulletSpeed;
            
            // See if we hit the bot
            double botDist = getDist(botX,botY,getX(),getY());
            double botDistToShot = Math.abs(botDist-bulletDistance);
            
            // If we have hit the bot, record it
            if (botDistToShot<20 && isInBounds(botX, botY)) {
                bestGoodness = currentGoodness;
                bestAngle = currentAngle;
                
                ///////////////////////////////////////////////////////////////
                // Return first found because it is the most accurate
                ///////////////////////////////////////////////////////////////
                
                sm.power = bulletPower;
                sm.angle = bestAngle;
                return sm;
            }
        }
        return sm;
    }
    
    double[] shotAngles = new double[10000];
    
    ShotModel findBestShotOn(String botName, double shotPower) {
        
        ShotModel sm = new ShotModel();
        sm.power=0;
        
        // Guess bot's movement
        int bestTime=0;
        double currentCloseness=0;
        double bestCloseness=10000;
        boolean isMatchFound = false;
        
        int bestShotCount=0;
        
        double shotAngle = 0;
        
        int currentTime = log.getCurrentTime();
        
        for (int logTime=currentTime-logLength; logTime<currentTime; logTime++) {
            currentCloseness = getPathDifference(botName, currentTime, logTime);
            
            if (currentCloseness<=bestCloseness) {
                bestCloseness = currentCloseness;
                bestTime = logTime;
                
                shotAngle = getInterceptAngle(botName, bestTime, shotPower);
                
                if (currentCloseness<50 && shotAngle!=999999) {
                    // Record all projected angles
                    shotAngles[bestShotCount] = shotAngle;
                    bestShotCount++;
                    isMatchFound = true;
                }
            }
        }
        
        if (!isMatchFound) {
            return sm;
        }
        
        if (bestShotCount==0) {
            sm.power = shotPower;
            sm.angle = shotAngle;
            return sm;
        }
        
        // Chose middle angle
        double angleTally = 0;
        double averageAngle = 0;
        double bestAngle = 0;
        double bestGoodness = 99999;
        double currentGoodness=0;
        for (int i=0; i<bestShotCount; i++) {
            angleTally+=getGunTurn(shotAngles[i]);
        }
        averageAngle = angleTally/bestShotCount;
        
        for (int i=0; i<bestShotCount; i++) {
            currentGoodness = Math.abs(averageAngle-getGunTurn(shotAngles[i]));
            if (currentGoodness<bestGoodness) {
                bestGoodness = currentGoodness;
                bestAngle = shotAngles[i];
            }
        }
        sm.power = shotPower;
        sm.angle = bestAngle;
        
        return sm;
    }
    
    public double getInterceptAngle(String botName, int startTime, double bulletPower) {
        double currentAngle=0;
        double bestAngle=0;
        double currentGoodness=0;
        double bestGoodness=0;
        
        // Get the current position
        double botX=log.get(botName).x;
        double botY=log.get(botName).y;
        double botA=log.get(botName).angle;
        
        
        for (int timeDelta=0; timeDelta<50; timeDelta++) {
            
            // If nothing is recorded for this time, stop predicting
            if (!log.isBotRecorded(botName,startTime+timeDelta)) {
                return 999999;
            }
            
            double bulletDist = 0;
            
            // Guess next position
            botA = botA+getBotAV(botName, startTime+timeDelta);
            botX = botX+log.get(botName, startTime+timeDelta).v*Math.sin(botA);
            botY = botY+log.get(botName, startTime+timeDelta).v*Math.cos(botA);
            currentAngle = getAngle(botX, botY);
            
            // For bots that hang out near walls, assume they wont hit them...
            if (!isInBounds(botX, botY)) {
                botX = Math.min(getBattleFieldWidth()-19, Math.max(19,botX));
                botY = Math.min(getBattleFieldHeight()-19, Math.max(19,botY));
            }
            
            // Use less power for larger distance
            double bulletSpeed = 20.0 - (3.0*bulletPower);
            // should calculate this based on angle
            int timeFoGunToTurn = 1;
            double bulletDistance = (timeDelta-timeFoGunToTurn)*bulletSpeed;
            
            // See if we hit the bot
            double botDist = getDist(botX,botY,getX(),getY());
            double botDistToShot = Math.abs(botDist-bulletDistance);
            
            // If we have hit the bot, record it
            if (botDistToShot<25 && isInBounds(botX, botY)) {
                bestGoodness = currentGoodness;
                bestAngle = currentAngle;
                
                ///////////////////////////////////////////////////////////////
                // Return first found because it is the most accurate
                ///////////////////////////////////////////////////////////////
                
                return bestAngle;
            }
        }
        
        return 999999;
    }
    double getBotV(String botName, int time){
        return log.get(botName,time).v;
    }

    double getBotAV(String botName, int time){
        return angleDiff(log.get(botName,time).angle,log.get(botName,time-1).angle);
    }
    
    ////////////////////////////////////////////////////////////////////
    // Bonus sensors
    ////////////////////////////////////////////////////////////////////
    boolean getBotHitWall(String botName, int time){
        return Math.abs(log.get(botName,time).v-log.get(botName,time-1).v)>1;
    }
    
    double getPathDifference(String botName, int time1, int time2) {
        
        
        // Only fire if this is a perfect match
        if (getBotV(botName,time1)!=getBotV(botName,time2) || getBotAV(botName,time1)!=getBotAV(botName,time2)) {
            return 999999;
        }
        double diff=0;
        double scalar[] = {32,16,13,10,8,6,5,4,3,2,1,1,1,1,1,1,1};
        
        for (int i=1; i<16; i++) {
            // If nothing is recorded for this time, stop predicting
            if (!log.isBotRecorded(botName,time2-i) || !log.isBotRecorded(botName,time1-i)) {
                return 999999;
            }
            diff += scalar[i]*Math.abs(log.get(botName,time1-i).v-log.get(botName,time2-i).v);
            diff += scalar[i]*Math.abs(getBotAV(botName,time1-i)-getBotAV(botName,time2-i))/100;
        }
        return diff;
    }
    
    boolean isFutureRecorded(String botName, int logTime,int duration) {
        for (int i=0; i<duration; i++) {
            if (!log.isBotRecorded(botName,i+logTime)){
                return false;
            }
        }
        return true;
    }

    public double getGunTurn(double angle) {
        double targetTurnAngle = angle-getGunHeadingRadians();
        return normalizeAngle(targetTurnAngle);
    }
    public double getBotTurn(double angle) {
        double targetTurnAngle = angle-getHeadingRadians();
        return normalizeAngle(targetTurnAngle);
    }
    public double getScanTurn(double angle) {
        double targetTurnAngle = angle-getRadarHeadingRadians();
        return normalizeAngle(targetTurnAngle);
    }
    
    public double getDistToBot(String botName) {
        return getDist(getX(),getY(),log.get(botName).x,log.get(botName).y);
    }
    
    
    public boolean isInBounds(double x, double y) {
        return  !(x<18 || y<18 || x>getBattleFieldWidth()-18 || y>getBattleFieldHeight()-18);
    }
    
    public double getDist(double x1, double y1, double x2, double y2) {
        return Math.sqrt((y1-y2)*(y1-y2) +(x1-x2)*(x1-x2));
    }
    public double getAngle(double x, double y) {
        return Math.atan2(getX()-x, getY()-y)+3.14159;
    }
    public double normalizeAngle(double d) {
        while (d>pi) d-=pi*2;
        while (d<-pi) d+=pi*2;
        return d;
    }
    public double angleDiff(double a1, double a2) {
        return normalizeAngle(a1-a2);
    }
    
    double wideRadarTarget;
    double wideRadarCurrent; {
        wideRadarTarget=0;
        wideRadarCurrent=0;
    }
    public void wideRadarScan() {
        double wideRadarTargetL = wideRadarTarget - pi/8;
        double wideRadarTargetR = wideRadarTarget + pi/8;
        
        double wideRadarDeltaL = getScanTurn(wideRadarTargetL);
        double wideRadarDeltaR = getScanTurn(wideRadarTargetR);
        
        if (Math.abs(wideRadarDeltaR)>Math.abs(wideRadarDeltaL)) {
            setTurnRadarRightRadians(wideRadarDeltaR);
        } else {
            setTurnRadarRightRadians(wideRadarDeltaL);
        }
    }
    
    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    ///////////// End From Memory //////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    
    boolean isColorSet = false;
    void setColorsOnce(Color a,Color b,Color c) {
        if(!isColorSet){
            isColorSet = true;
            setColors(a,b,c);
        }
    }
    
    void setColorsNormal() {
        if (colorMode!=1 && !isColorSet){
            colorMode = 1;
            setColorsOnce(Color.green,Color.white,Color.white);
        }
    }
    void setColorsAttack() {
        if (colorMode!=2 && !isColorSet){
            colorMode = 2;
            setColorsOnce(Color.red,Color.black,Color.red);
        }
    }
    
    ////////////////////////////////////////////////////////////////////////////
    ///////////// Game Envionment //////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    
    double getMaxTurnRateRadians(double velocity) {
        return (4+6*(8-velocity)/8)/360*pi*2;
    }
    
    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    ///////////// End Game Envionment //////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    
    public void doVictoryDance() {
        setColorsNormal();
        
        setTurnGunRightRadians(getGunTurn(getHeadingRadians()));
        setTurnRadarRightRadians(getScanTurn(getHeadingRadians()));
        
        double goalX = getBattleFieldWidth()/2;
        double goalY = getBattleFieldHeight()/2;
        double dist = getDist(getX(), getY(), goalX, goalY);
        double angle = getAngle(goalX, goalY);
        double turn = getBotTurn(angle);
        
        setMaxVelocity(8.0-Math.abs(turn)*6);
        setTurnRightRadians(turn);
        setAhead(dist);
        if (dist<10) {
            
            setMaxVelocity(8.0);
            setMaxTurnRate(99);
            setAdjustGunForRobotTurn(false);
            setAdjustRadarForGunTurn(false);
            
            turnRightRadians(getBotTurn(0));
            
            for (int i=0; i<16; i++){
                setTurnRightRadians(.05);
                ahead(-2);
            }
            
            setTurnRightRadians(-0.8);
            ahead(getBattleFieldHeight()/2-50);
            
            setMaxVelocity(1);
            ahead(100);
            setMaxVelocity(8.0);
        }
    }
}
