package djc.gun;

import djc.*;
import djc.util.*;

import java.awt.*;
import java.awt.geom.*;

/**
 * Angular Targetting
 *
 * Based on Gouldingi:
 *    http://robowiki.net/cgi-bin/robowiki?Gouldingi/Code
 */
public class AngularGun extends BaseGun
{
	private double meanAimFactorLeft;
	private double meanAimFactorMiddle;
	private double meanAimFactorRight;		
	
	public AngularGun(AbstractDynaBot themyrobot) {
		super(themyrobot);
		name = "ANGULARGUN";
		gunID = DynaBotConstants.ANGULARGUN;
	}
	
	public double calcGunTurnRadians(Enemy e) {
		double guessedDistance = e.lastDistance;
		double meanAimFactor = ((Double)myrobot.theEnemyManager.meanAimFactorMiddle.get(e.name)).doubleValue();
		double meanOffsetFactor = ((Double)myrobot.theEnemyManager.meanAimFactor.get(e.name)).doubleValue();
		if(e.deltaBearing < -0.3) {
			meanAimFactor = ((Double)myrobot.theEnemyManager.meanAimFactorLeft.get(e.name)).doubleValue();
		} else if (e.deltaBearing > .3) {
			meanAimFactor = ((Double)myrobot.theEnemyManager.meanAimFactorRight.get(e.name)).doubleValue();		
		}
		double guessedHeading = MyUtils.absoluteBearing(myrobot.location, e.location);
		if(Math.abs(e.deltaBearing) > 0.05) {
			guessedHeading += e.deltaBearing * meanAimFactor;
		} else {
			guessedHeading += meanOffsetFactor;
		}
	
		Point2D.Double impactLocation;
		
		impactLocation = MyUtils.project(myrobot.location, guessedHeading, guessedDistance);
		myrobot.theBattleManager.translateInsideField(impactLocation, 1);
		guessedHeading = MyUtils.absoluteBearing(myrobot.location, impactLocation);
		
		return guessedHeading;
	}	
}
