package hirataatsushi;

import robocode.*;


/**
 * CircularMovingStrategy - a class by A.Hirata.
 * G̎锼ał邭
 */
public class CircularMovingStrategy implements MovingStrategy
{
	//Gƕۂ
	private final long RADIUS = 150;
	//is  
	private static int direction = 1;
	
	//@ւ̎Q
	private AdvancedRobot myBot = null;
	//^[Qbg}l[Wւ̎Q
	private TargetManager manager = TargetManager.getInstance();
	//RXgN^
	public CircularMovingStrategy(AdvancedRobot bot){
		myBot = bot;
	}
	//̎
	public void doAction(){
		Enemy currTarget = manager.getNearestTarget();

		//ǂ߂ÂogtB[hS߂ֈړ
		if ( (myBot.getX() < 100 || myBot.getX() > (myBot.getBattleFieldWidth() -100) ) ||
		     (myBot.getY() < 100 || myBot.getY() > (myBot.getBattleFieldHeight() -100)) ) {

			double midX = myBot.getBattleFieldWidth() /2;
			double midY = myBot.getBattleFieldHeight() /2;
			
        	if (Math.abs(midX - myBot.getX()) > 50 ||
            	Math.abs(midY - myBot.getY()) > 50) {
            	if (myBot.getTurnRemaining() == 0) {
					double robotTurn =
                    	Helper.atan((midY - myBot.getY()),
                        	           (midX - myBot.getX()));
                	myBot.setTurnRightRadians(Helper.normalizeBearingRadians(robotTurn));
            	}
            	myBot.setAhead(Math.sqrt(Math.pow(midX - myBot.getX(), 2) +
                                 Math.pow(midY - myBot.getY(), 2)));
				System.out.println("Go to the Center");
            	//setSpeed(SPEED_MAX);
        	} else {

            	//r.atCenter = true;
        	}		


		} else {
			//GƂ̋K̋ɂȂAGƂ̊pxXOxɁB
			//GƂ̋Ă΂STxɁB
			if (currTarget.getDistance() > RADIUS) {
				myBot.setTurnRightRadians((currTarget.getBearing() + Math.PI/4) % Math.PI*2);
			} else {
				myBot.setTurnRightRadians((currTarget.getBearing() + Math.PI/2) % Math.PI*2);
			}
			myBot.setAhead(100);
		}
		
	}
}
