package winamp32.micro;
import robocode.*;
import robocode.util.Utils;
import java.util.*;
import java.awt.Color;
import java.awt.geom.*;
import java.awt.*;
public class MicroMacro extends AdvancedRobot {
	/*
	TODO:
	improve Radar
	
	*/
	int turnDir = 90;
	int moveDir = 1;
	boolean onTheWall;
	public String target;
	double power;
	double x,y,aimX,aimY;
	double distance;
	double scanTime;
	
	public void run() {
		//setColors(Color.orange,null, null);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setTurnRadarRight(Double.POSITIVE_INFINITY);
		while(true) {
			checkBounds();
			if(getVelocity() == 0||getTime()%20==0) {
				doMove();
				moveDir *= -1;
			}
			setTurnGunRightRadians(getAngle(aimX,aimY,getGunHeadingRadians()));
			if(getTurnRemaining() == 0) {
				setTurnRight(turnDir);
				turnDir *= -1;
			}
			if(getEnergy()>.1&&target!=null&&new Rectangle.Double(18, 18, getBattleFieldWidth() - 18, getBattleFieldHeight() - 18).contains(aimX,aimY))
				setFire(power);
			execute();
		}
	}
	public void onScannedRobot(ScannedRobotEvent e) {
		double dist = e.getDistance();
		double bearing =e.getBearingRadians();
		double absBearing=getHeadingRadians()+bearing;
		double 	 newX=getX()+Math.sin(absBearing)*dist
				,newY=getY()+Math.cos(absBearing)*dist;
		double currentTime=getTime();
			
		if(dist < 120 && !onTheWall) {
			moveDir =(Math.abs(bearing) >Math.PI / 2)?1:-1;
			doMove();
		}
		if(e.getName() == target) {
		
			double deltaTime=currentTime-scanTime;
			double vX=(newX-x)/deltaTime,vY=(newY-y)/deltaTime; 
			power=400/ (dist<134?134:dist);
			x=newX;
			y=newY;
			deltaTime=0;
			while(Point2D.Double.distance(getX(),getY(),newX,newY)>=((20.0 - 3.0 * power)*deltaTime++)){
/*			if(deltaTime>100){
                        	out.println("power:"+power);
				out.println("deltaTime"+ deltaTime);
				out.println("Vx: "+vX+ " vY:"+vY);
				out.println("Point2D.Double.distance(myX,myY,newX,newY):"+Point2D.Double.distance(getX(),getY(),newX,newY));
				out.println("((20.0 - 3.0 * power)*time)"+((20.0 - 3.0 * power)*deltaTime));
			}*/
				newX+=vX;
				newY+=vY;
			}
			
			if(Math.abs(Math.asin(Math.sin(bearing)))<Math.PI/4)
				setTurnRightRadians(Utils.normalRelativeAngle(Math.PI/2-Math.abs(bearing)));
		}else if(target == null || 0 > ((dist + 100) - distance)){
			x=newX;
			y=newY;
			target = e.getName();
				
		}else return;
		aimX=newX;
		aimY=newY;
		distance = dist;
		scanTime=currentTime;
		
	}
	public void doMove() {
		setAhead(Double.POSITIVE_INFINITY * moveDir);
	}
	public void onRobotDeath(RobotDeathEvent e) {
			target = null;
	}
	public void checkBounds() {
		Rectangle.Double rect = new Rectangle.Double(50, 50, getBattleFieldWidth() - 100, getBattleFieldHeight() - 100);
		double turnAng=getAngle(getBattleFieldWidth() / 2,getBattleFieldHeight() / 2,getHeadingRadians());
		if(onTheWall=!rect.contains(getX(), getY())) {
			if(Math.abs(turnAng) > Math.PI / 2){ 
				turnAng = Utils.normalRelativeAngle(turnAng - Math.PI);
				moveDir=-1;
			}
			else
				moveDir=1;
			doMove();
			setTurnRightRadians(turnAng);
		}
	}

	public double getAngle(double x,double y,double heading){
		double deltaX=getX()-x;
		double alpha=Math.atan((getY()-y)/(deltaX));
		if(deltaX > 0)
			alpha += (Math.PI * (alpha < 0 ? 1 : -1));
		return Utils.normalRelativeAngle(Math.PI / 2 - alpha - heading);
	}
}
