package nz.jdc.nano;

import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

/**
 * Grid Fu
 * A an advanced fleet maneouver technique from the MMO Eve Online,
 * which seemed appropriate for this bot.
 * 
 * It uses a lookuptable (based on the bots x-y coord) to determine which way to turn 
 * and move. After each move it increments to the next pattern, so theoreticly it could
 * do all kinds of fancy stuff, but I have yet to really play with patterns.
 *
 * This is by no means tuned and there are some bugs with maneouvering around the
 * walls, but it is a PITA to tune melee bots and even more so to work with turn/move
 * (rather than coordinate) table driven movement.
 * Even the dodge pattern hasn;t been thought about much, it is just a square like infinity.

 * Credits: Ideas liberally lifted from DustBunny, Infinity and LittleBlackBook by
 * Michael Dorgan and Lib by Kawigi. With additional inspiration from DoctorBob 
 * by Radnor.
 * 
 * 1.0 : initial version.
 *   Codesize 246
 */
public class GridFu extends AdvancedRobot {
  // constants
  private final static double FIRE_POWER_FACTOR   = 4; //4;
  private final static int    TARGET_RANGE_MARGIN = 73; // should be at least 8*8 to cover max move while doing a full radar spin
  private final static double RANGE_FACTOR        = 700; 
  private final static int    NO_TARGET           = 5000;
  
  // static vars
  private static int    patternPos;
  private static int    tDistance;
  
  /** bot run */
  public void run() {
    // setAllColors(Color.MAGENTA);
    
    setAdjustGunForRobotTurn(true);
    
    // clear lock distance and start radar
    turnRadarRightRadians(tDistance = NO_TARGET);
  }

  /** scan handler */
  public void onScannedRobot(ScannedRobotEvent r2e) {
    // registers
    int    r3i;
    double r4d;
    
    // other locals
    double bulletPower;

    // do movement
    // 5 bits (32, 0-31) for each of x, y and patternPos
    // can use 0f or 07 instead of 1f if we want less patterns, but then there will be table gaps
    if (getDistanceRemaining() == 0) {
      r3i = (((int) getY() & 0x03e0) << 5) + ((int) getX() & 0x03e0) + (patternPos++ & 0x001f);
      setTurnRight(Utils.normalRelativeAngleDegrees(TAB_MV_ANG_DEG.charAt(r3i) - getHeading()));
      setAhead((short) TAB_MV_DIST.charAt(r3i));
      
      // out.printf("x %d\ty %d\ta %d\tm %d\n", (int) getX() / 32, (int) getY() / 32, (int) TAB_MV_ANG_DEG.charAt(r3i), (short) TAB_MV_DIST.charAt(r3i));
    }

    // fire with greater power if close or many opponents, reduce power when we get low
    r3i = (int) r2e.getDistance();
    r4d = getEnergy();
    bulletPower = FIRE_POWER_FACTOR * getOthers() * r4d / r3i;
    if (r4d > 5 && getGunTurnRemaining() == 0 && setFireBullet(bulletPower) != null) {
      tDistance = NO_TARGET;
    }
    
    // found a close bot (or the previous closest again)
    if (r3i <= (tDistance + TARGET_RANGE_MARGIN)) {
      // set lock range
      tDistance = r3i;
      
      // aim gun
      r4d = r2e.getBearingRadians() + getHeadingRadians(); // absolute bearing
      setTurnGunRightRadians(Utils.normalRelativeAngle(r4d - getGunHeadingRadians() 
        + r2e.getVelocity() * Math.sin(r2e.getHeadingRadians() - r4d) / Rules.getBulletSpeed(bulletPower)
        * (1 - r3i / RANGE_FACTOR)
      ));

      if (getGunHeat() < 1) {
        // radar lock when approaching firing time
        setTurnRadarLeftRadians(getRadarTurnRemaining());
      }
    }
    
    // closest scan result is first, clear the rest to avoid switching to a further one
    clearAllEvents();
  }

  //---------------------------------------------------------------------------
  private final static int  NCELLS = 32;
  private final static int  CELL_SIZE = 1000 / NCELLS;

  // move distance constants
  private final static char MF_   = 2 * CELL_SIZE;
  private final static char MB_   = (char) -MF_;
  private final static char DF_   = 2 * MF_;
  private final static char DB_   = (char) -DF_;
  private final static char SF_   = 72;
  private final static char SB_   = (char) -SF_;
  
  // angle constants (degrees)
  private final static char AN_   = 0;
  private final static char ANE_  = 45;
  private final static char AE_   = 90;
  private final static char ASE_  = 135;
  private final static char AS_   = 180;
  private final static char ASW_  = 215;
  private final static char AW_   = 270;
  private final static char ANW_  = 315;
  
  //                                       0      1      2      3      4      5      6      7      8      9      10     11     12     13     14     15     16     17     18     19     20     21     22     23     24     25     26     27     28     29    30      31
  private final static String MF    = "" + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_  + MF_;  
  private final static String MDF   = "" + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_  + DF_;  
  
  private final static String AN    = "" + ANW_ + ANE_ + ANW_ + ANE_ + ANW_ + ANE_ + ANW_ + ANE_ + ANW_ + ANE_ + ANW_ + ANE_ + ANW_ + ANE_ + ANW_ + ANE_ + ANW_ + ANE_ + ANW_ + ANE_ + ANW_ + ANE_ + ANW_ + ANE_ + ANW_ + ANE_ + ANW_ + ANE_ + ANW_ + ANE_ + ANW_ + ANE_;  
  private final static String ANE   = "" + AN_  + AE_  + AN_  + AE_  + AN_  + AE_  + AN_  + AE_  + AN_  + AE_  + AN_  + AE_  + AN_  + AE_  + AN_  + AE_  + AN_  + AE_  + AN_  + AE_  + AN_  + AE_  + AN_  + AE_  + AN_  + AE_  + AN_  + AE_  + AN_  + AE_  + AN_  + AE_;
  private final static String AE    = "" + ANE_ + ASE_ + ANE_ + ASE_ + ANE_ + ASE_ + ANE_ + ASE_ + ANE_ + ASE_ + ANE_ + ASE_ + ANE_ + ASE_ + ANE_ + ASE_ + ANE_ + ASE_ + ANE_ + ASE_ + ANE_ + ASE_ + ANE_ + ASE_ + ANE_ + ASE_ + ANE_ + ASE_ + ANE_ + ASE_ + ANE_ + ASE_;  
  private final static String ASE   = "" + AS_  + AE_  + AS_  + AE_  + AS_  + AE_  + AS_  + AE_  + AS_  + AE_  + AS_  + AE_  + AS_  + AE_  + AS_  + AE_  + AS_  + AE_  + AS_  + AE_  + AS_  + AE_  + AS_  + AE_  + AS_  + AE_  + AS_  + AE_  + AS_  + AE_  + AS_  + AE_; 
  private final static String AS    = "" + ASE_ + ASW_ + ASE_ + ASW_ + ASE_ + ASW_ + ASE_ + ASW_ + ASE_ + ASW_ + ASE_ + ASW_ + ASE_ + ASW_ + ASE_ + ASW_ + ASE_ + ASW_ + ASE_ + ASW_ + ASE_ + ASW_ + ASE_ + ASW_ + ASE_ + ASW_ + ASE_ + ASW_ + ASE_ + ASW_ + ASE_ + ASW_;  
  private final static String ASW   = "" + AS_  + AW_  + AS_  + AW_  + AS_  + AW_  + AS_  + AW_  + AS_  + AW_  + AS_  + AW_  + AS_  + AW_  + AS_  + AW_  + AS_  + AW_  + AS_  + AW_  + AS_  + AW_  + AS_  + AW_  + AS_  + AW_  + AS_  + AW_  + AS_  + AW_  + AS_  + AW_; 
  private final static String AW    = "" + ASW_ + ANW_ + ASW_ + ANW_ + ASW_ + ANW_ + ASW_ + ANW_ + ASW_ + ANW_ + ASW_ + ANW_ + ASW_ + ANW_ + ASW_ + ANW_ + ASW_ + ANW_ + ASW_ + ANW_ + ASW_ + ANW_ + ASW_ + ANW_ + ASW_ + ANW_ + ASW_ + ANW_ + ASW_ + ANW_ + ASW_ + ANW_;
  private final static String ANW   = "" + AN_  + AW_  + AN_  + AW_  + AN_  + AW_  + AN_  + AW_  + AN_  + AW_  + AN_  + AW_  + AN_  + AW_  + AN_  + AW_  + AN_  + AW_  + AN_  + AW_  + AN_  + AW_  + AN_  + AW_  + AN_  + AW_  + AN_  + AW_  + AN_  + AW_  + AN_  + AW_; 

  //                                       0      1      2      3      4      5      6      7      8      9      10     11     12     13     14     15     16     17     18     19     20     21     22     23     24     25     26     27     28     29    30      31
  private final static String AP    = "" + AN_  + AW_  + AS_  + AE_  + AN_  + AW_  + AS_  + AE_  + AN_  + AW_  + AS_  + AE_  + AN_  + AW_  + AS_  + AE_  + AN_  + AW_  + AS_  + AE_  + AN_  + AW_  + AS_  + AE_  + AN_  + AW_  + AS_  + AE_  + AN_  + AW_  + AS_  + AE_;
  private final static String MP    = "" + DB_  + DF_  + DB_  + DF_  + DB_  + DF_  + DB_  + DF_  + DB_  + DF_  + DB_  + DF_  + DB_  + DF_  + DB_  + DF_  + DB_  + DF_  + DB_  + DF_  + DB_  + DF_  + DB_  + DF_  + DB_  + DF_  + DB_  + DF_  + DB_  + DF_  + DB_  + DF_;

  //                                       0      1      2      3      4      5      6      7      8      9      10     11     12     13     14     15     16     17     18     19     20     21     22     23     24     25     26     27     28     29    30      31
  private final static String AT_31 = "" + ASE  + ASE  + ASE  + AS   + AS   + AS   + AS   + ASW  + ASW  + ASW  + ASW  + ASW  + ASW  + ASW  + ASW  + ASW  + ASE  + ASE  + ASE  + ASE  + ASE  + ASE  + ASE  + ASE  + ASE  + AS   + AS   + AS   + AS   + ASW  + ASW  + ASW;
  private final static String AT_30 = "" + ASE  + ASE  + ASE  + AS   + AS   + AS   + AS   + ASW  + ASW  + ASW  + ASW  + ASW  + ASW  + ASW  + ASW  + ASW  + ASE  + ASE  + ASE  + ASE  + ASE  + ASE  + ASE  + ASE  + ASE  + AS   + AS   + AS   + AS   + ASW  + ASW  + ASW;
  private final static String AT_29 = "" + ASE  + ASE  + ASE  + AS   + AS   + AS   + AS   + ASW  + ASW  + ASW  + ASW  + ASW  + ASW  + ASW  + ASW  + ASW  + ASE  + ASE  + ASE  + ASE  + ASE  + ASE  + ASE  + ASE  + ASE  + AS   + AS   + AS   + AS   + ASW  + ASW  + ASW;
  
  private final static String AT_28 = "" + AE   + AE   + AE   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AW   + AW   + AW;
  private final static String AT_27 = "" + AE   + AE   + AE   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AW   + AW   + AW;
  private final static String AT_26 = "" + AE   + AE   + AE   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AW   + AW   + AW;
  private final static String AT_25 = "" + AE   + AE   + AE   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AW   + AW   + AW;
  private final static String AT_24 = "" + AE   + AE   + AE   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AW   + AW   + AW;
  
  private final static String AT_23 = "" + ANE  + ANE  + ANE  + AP   + AP   + AP   + AP   + AP   + ANW  + ANW  + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + ANE  + ANE  + AP   + AP   + AP   + AP   + AP   + ANW  + ANW  + ANW;
  private final static String AT_22 = "" + ANE  + ANE  + ANE  + AP   + AP   + AP   + AP   + AP   + ANW  + ANW  + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + ANE  + ANE  + AP   + AP   + AP   + AP   + AP   + ANW  + ANW  + ANW;
  private final static String AT_21 = "" + ANE  + ANE  + ANE  + AP   + AP   + AP   + AP   + AP   + ANW  + ANW  + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + ANE  + ANE  + AP   + AP   + AP   + AP   + AP   + ANW  + ANW  + ANW;
  private final static String AT_20 = "" + ANE  + ANE  + ANE  + AP   + AP   + AP   + AP   + AP   + ANW  + ANW  + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + AN   + ANE  + ANE  + AP   + AP   + AP   + AP   + AP   + ANW  + ANW  + ANW;
  private final static String AT_19 = "" + ANE  + ANE  + ANE  + AP   + AP   + AP   + AP   + AP   + AW   + AW   + AW   + AW   + AW   + AW   + AW   + AW   + AE   + AE   + AE   + AE   + AE   + AE   + AE   + AE   + AP   + AP   + AP   + AP   + AP   + ANW  + ANW  + ANW;
  private final static String AT_18 = "" + ANE  + ANE  + ANE  + AP   + AP   + AP   + AP   + AP   + AW   + AW   + AW   + AW   + AW   + AW   + AW   + AW   + AE   + AE   + AE   + AE   + AE   + AE   + AE   + AE   + AP   + AP   + AP   + AP   + AP   + ANW  + ANW  + ANW;
  private final static String AT_17 = "" + ANE  + ANE  + ANE  + AP   + AP   + AP   + AP   + AP   + AW   + AW   + AW   + AW   + AW   + AW   + AW   + AW   + AE   + AE   + AE   + AE   + AE   + AE   + AE   + AE   + AP   + AP   + AP   + AP   + AP   + ANW  + ANW  + ANW;
  private final static String AT_16 = "" + ANE  + ANE  + ANE  + AP   + AP   + AP   + AP   + AP   + AW   + AW   + AW   + AW   + AW   + AW   + AW   + AW   + AE   + AE   + AE   + AE   + AE   + AE   + AE   + AE   + AP   + AP   + AP   + AP   + AP   + ANW  + ANW  + ANW;
  private final static String AT_15 = "" + ASE  + ASE  + ASE  + AP   + AP   + AP   + AP   + AP   + AW   + AW   + AW   + AW   + AW   + AW   + AW   + AW   + AE   + AE   + AE   + AE   + AE   + AE   + AE   + AE   + AP   + AP   + AP   + AP   + AP   + ASW  + ASW  + ASW;
  private final static String AT_14 = "" + ASE  + ASE  + ASE  + AP   + AP   + AP   + AP   + AP   + AW   + AW   + AW   + AW   + AW   + AW   + AW   + AW   + AE   + AE   + AE   + AE   + AE   + AE   + AE   + AE   + AP   + AP   + AP   + AP   + AP   + ASW  + ASW  + ASW;
  private final static String AT_13 = "" + ASE  + ASE  + ASE  + AP   + AP   + AP   + AP   + AP   + AW   + AW   + AW   + AW   + AW   + AW   + AW   + AW   + AE   + AE   + AE   + AE   + AE   + AE   + AE   + AE   + AP   + AP   + AP   + AP   + AP   + ASW  + ASW  + ASW;
  private final static String AT_12 = "" + ASE  + ASE  + ASE  + AP   + AP   + AP   + AP   + AP   + AW   + AW   + AW   + AW   + AW   + AW   + AW   + AW   + AE   + AE   + AE   + AE   + AE   + AE   + AE   + AE   + AP   + AP   + AP   + AP   + AP   + ASW  + ASW  + ASW;
  private final static String AT_11 = "" + ASE  + ASE  + ASE  + AP   + AP   + AP   + AP   + AP   + ASW  + ASW  + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + ASE  + ASE  + AP   + AP   + AP   + AP   + AP   + ASW  + ASW  + ASW;
  private final static String AT_10 = "" + ASE  + ASE  + ASE  + AP   + AP   + AP   + AP   + AP   + ASW  + ASW  + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + ASE  + ASE  + AP   + AP   + AP   + AP   + AP   + ASW  + ASW  + ASW;
  private final static String AT_09 = "" + ASE  + ASE  + ASE  + AP   + AP   + AP   + AP   + AP   + ASW  + ASW  + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + ASE  + ASE  + AP   + AP   + AP   + AP   + AP   + ASW  + ASW  + ASW;
  private final static String AT_08 = "" + ASE  + ASE  + ASE  + AP   + AP   + AP   + AP   + AP   + ASW  + ASW  + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + AS   + ASE  + ASE  + AP   + AP   + AP   + AP   + AP   + ASW  + ASW  + ASW;
 
  private final static String AT_07 = "" + AE   + AE   + AE   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AW   + AW   + AW;
  private final static String AT_06 = "" + AE   + AE   + AE   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AW   + AW   + AW;
  private final static String AT_05 = "" + AE   + AE   + AE   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AW   + AW   + AW;
  private final static String AT_04 = "" + AE   + AE   + AE   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AW   + AW   + AW;
  private final static String AT_03 = "" + AE   + AE   + AE   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AP   + AW   + AW   + AW;
  
  private final static String AT_02 = "" + ANE  + ANE  + ANE  + AN   + AN   + AN   + AN   + ANW  + ANW  + ANW  + ANW  + ANW  + ANW  + ANW  + ANW  + ANW  + ANE  + ANE  + ANE  + ANE  + ANE  + ANE  + ANE  + ANE  + ANE  + AN   + AN   + AN   + AN   + ANW  + ANW  + ANW;
  private final static String AT_01 = "" + ANE  + ANE  + ANE  + AN   + AN   + AN   + AN   + ANW  + ANW  + ANW  + ANW  + ANW  + ANW  + ANW  + ANW  + ANW  + ANE  + ANE  + ANE  + ANE  + ANE  + ANE  + ANE  + ANE  + ANE  + AN   + AN   + AN   + AN   + ANW  + ANW  + ANW;
  private final static String AT_00 = "" + ANE  + ANE  + ANE  + AN   + AN   + AN   + AN   + ANW  + ANW  + ANW  + ANW  + ANW  + ANW  + ANW  + ANW  + ANW  + ANE  + ANE  + ANE  + ANE  + ANE  + ANE  + ANE  + ANE  + ANE  + AN   + AN   + AN   + AN   + ANW  + ANW  + ANW;

                                        // 0      1      2      3      4      5      6      7      8      9      10     11     12     13     14     15     16     17     18     19     20     21     22     23     24     25     26     27     28     29    30      31
  private final static String MT_31 = "" + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF;
  private final static String MT_30 = "" + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF;
  private final static String MT_29 = "" + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF;
  private final static String MT_28 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_27 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_26 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_25 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_24 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_23 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_22 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_21 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_20 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_19 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_18 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_17 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_16 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_15 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_14 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_13 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_12 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_11 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_10 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_09 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_08 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_07 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_06 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_05 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_04 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_03 = "" + MDF  + MDF  + MDF  + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MP   + MDF  + MDF  + MDF;
  private final static String MT_02 = "" + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF;
  private final static String MT_01 = "" + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF;
  private final static String MT_00 = "" + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF  + MDF;
  
  private final static String TAB_MV_ANG_DEG = ""
    + AT_00 + AT_01 + AT_02 + AT_03 + AT_04 + AT_05 +  AT_06 + AT_07 + AT_08 + AT_09
    + AT_10 + AT_11 + AT_12 + AT_13 + AT_14 + AT_15 +  AT_16 + AT_17 + AT_18 + AT_19 
    + AT_20 + AT_21 + AT_22 + AT_23 + AT_24 + AT_25 +  AT_26 + AT_27 + AT_28 + AT_29
    + AT_30 + AT_31;
  
  private final static String TAB_MV_DIST = "" 
    + MT_00 + MT_01 + MT_02 + MT_03 + MT_04 + MT_05 +  MT_06 + MT_07 + MT_08 + MT_09
    + MT_10 + MT_11 + MT_12 + MT_13 + MT_14 + MT_15 +  MT_16 + MT_17 + MT_18 + MT_19 
    + MT_20 + MT_21 + MT_22 + MT_23 + MT_24 + MT_25 +  MT_26 + MT_27 + MT_28 + MT_29
    + MT_30 + MT_31;
}
