package dummy_team;
import robocode.*;
import java.io.*;

/**
 * BlindDroid - a robot by (Kwok-Cheung Li)
 */
public class BlindDroid extends TeamRobot implements Droid
{
	double foundEnemyTimeout=-30;
	double x=0;
	double y=0;
	double tx=0;
	double ty=0;
	double target;
	double heading;
	
	public double angle_180(double ang)
	{
		return Math.atan2(Math.sin(ang), Math.cos(ang));
	}
	
	public void run()
	{
		setAdjustGunForRobotTurn(true);
		// first, find nearest wall and move in that direction
		x=getX()-.5*getBattleFieldWidth();
		y=getY()-.5*getBattleFieldHeight();
		heading=Math.rint(2*Math.atan2(x,y)/Math.PI);
		heading=(Math.PI/2)*heading;
		turnRightRadians(angle_180(heading-getHeadingRadians()));
		while(true)
		{
			target=Math.atan2((tx-getX()), (ty-getY()));
			if ((getTime()%20) < 5)
				setAhead(0);
			else
				setAhead(100);
			if ((getTime()-foundEnemyTimeout)>30)
			{
				setTurnGunRightRadians(angle_180(getHeadingRadians() + Math.PI/2 - getGunHeadingRadians()));
				fire(.1);
			}
			else
			{
				setTurnGunRightRadians(angle_180(target-getGunHeadingRadians()));
				fire(3);
			}
		}
	}
			
	
	public void onHitWall(HitWallEvent e)
	{
		turnRight(90);
	}
	
	public void onHitRobot(HitRobotEvent e)
	{
		if (!isTeammate(e.getName()))
		{
			foundEnemyTimeout=getTime();
			tx=getX() + 40*Math.sin(angle_180(getHeadingRadians() + e.getBearingRadians()));
			ty=getY() + 40*Math.cos(angle_180(getHeadingRadians() + e.getBearingRadians()));
			try
			{
				broadcastMessage(new enemypos(tx, ty));
			}
			catch (IOException ex){}
		}
	}
				
	
	public void onBulletHit(BulletHitEvent e)
	{
		if (!isTeammate(e.getName()))
		{
			foundEnemyTimeout=getTime();
			Bullet b=e.getBullet();
			tx=b.getX();
			ty=b.getY();
			try
			{
				broadcastMessage(new enemypos(tx, ty));
			}
			catch (IOException ex){}
		}
	}
	
	public void onMessageReceived(MessageEvent e)
	{
		if ((e.getMessage() instanceof enemypos) && ((getTime()-foundEnemyTimeout)>30))
		{
			foundEnemyTimeout=getTime();
			enemypos ep=(enemypos)e.getMessage();
			tx=ep.x;
			ty=ep.y;
		}
	}
			
	
}
