/*
 * Created on 2004-9-26
 */
package tide.util;

/**
 * Sotme utils in statist.
 * @author iiley(Chen Jing)
 */
public class StatistUtils {
	
	/**
	 * Return the angle of the index in a wave's statist.
	 * @param direction the direction of target move.
	 * @param index the index of factor in statist.
	 * @param power the power of bullet.
	 * @param factorSize the factor size.
	 * @return the angle of the index in a statist.
	 */
	public static double getAngle(double direction,int index,double power, int factorSize){
		return (2d*maxEscapAngle(power)*(index)/(factorSize-1)-maxEscapAngle(power))*direction;
	}
	
	
	/**
	 * Return the index of the angle in a wave's statist.
	 * @param hitAngle the angle.
	 * @param originBearing the wave's originBearing.
	 * @param power the power of bullet.
	 * @param direction the direction of target move.
	 * @param factorSize the factor size.
	 * @return the index of the angle in a wave's statist.
	 */
	public static int getIndex(double hitAngle, double originBearing, double power, double direction, int factorSize){
		return (int)Math.round(
					(MathUtils.anglePI(hitAngle-originBearing)*direction
					+maxEscapAngle(power))/
					((maxEscapAngle(power)*2d)/(factorSize-1)));
	}
	
	
	/**
	 * Return the angle of a enemy can escape as fast as it can.
	 * @param power the power of my bullet's which use to hit enemy
	 * @return the angle of a enemy can escape as fast as it can.
	 */
	public static double maxEscapAngle(double power){
		return Math.asin(8d/Utils.bulletVelocity(power));
	}
	
	/**
	 * Paul Evans' rolling average function.
	 * @param n the speed of the rolling.
	 * @param oldVal old value
	 * @param entry entry,usually 1 means rate hitted,0 means others not hitted.
	 * @return the rolled value
	 */
	public static float rollingAverage(float n, float oldVal, float entry){
		return (n*oldVal + entry)/(n + 1f);
	}
}
