package sgp;
import robocode.*;
import java.util.*;

/**
 * Impact - a class by Simon Parker
 */

public class Impact extends Object
{
	private Coordinate position = new Coordinate();
	private double time = 0;
	private Coordinate bulletStartingPosition = new Coordinate();
	private double bulletVelocity = 17.0;
	private double bulletPower = 1.0;
	private double bulletHeading_deg = 0.0;
	private double bulletStartTime = 0;
	private double weight = 1.0;

	private static double ROBOT_RADIUS = 20.0;
	private static double TIME_BOUNDARY = 3.0;
	private static double TIME_WEIGHT = 0.01;

	public static void resetParameters
	(
		double robotRadius,
		double timeBoundary,
		double timeWeight
	)
	{
		ROBOT_RADIUS = robotRadius;
		TIME_BOUNDARY = timeBoundary;
		TIME_WEIGHT = timeWeight;
	}

	public void set
	(
		Coordinate impactPos,
		double impactTime,
		Coordinate bStartPos,
		double heading,
		double power,
		double startTime,
		double theWeight
	)
	{
		position = impactPos;
		time = impactTime;
		bulletStartingPosition = bStartPos;
		setBulletPower(power);
		bulletHeading_deg = heading;
		bulletStartTime = startTime;
		weight = theWeight;
	}

	private void setBulletPower(double power)
	{
		bulletPower = power;
		bulletVelocity = 20.0 - 3.0 * power;
	}

	public double distanceFrom(Coordinate robotPosition, double currentTime)
	{

/*
		//this technique did not work very well
		Coordinate currentBulletPosition = getBulletPosition(currentTime);
		Coordinate futureBulletPosition = getBulletPosition(currentTime + TIME_BOUNDARY);

		double distance = robotPosition.distanceFrom(currentBulletPosition, futureBulletPosition);
		//distance += TIME_WEIGHT * robotPosition.distanceFrom(currentBulletPosition);
		distance = Math.min(distance, ROBOT_RADIUS);

		return distance;
*/


		double distance = robotPosition.distanceFrom(position);
		distance = Math.min(distance, ROBOT_RADIUS);


		double timeWeight = 1.0 - Math.abs(currentTime - time) / TIME_BOUNDARY;
		timeWeight = Math.max(0.0, timeWeight);

		distance *= timeWeight;

		return distance * weight;

	}

	private Coordinate getBulletPosition(double currentTime)
	{
		double dt = currentTime - bulletStartTime;
		return new Coordinate
		(
			bulletStartingPosition.x + dt * bulletVelocity * Math.sin(Math.toRadians(bulletHeading_deg)),
			bulletStartingPosition.y + dt * bulletVelocity * Math.cos(Math.toRadians(bulletHeading_deg))
		);
	}
}