package sgp;
import robocode.*;
import java.util.*;

/**
 * StrategyManager - a class by Simon Parker
 */

public class StrategyManager extends Object
{
	public final int MAD_HATTER_STRATEGY_ID = 0;
	public final int MELEE_STRATEGY_ID = 1;
	public final int EVASION_STRATEGY_ID = 2;

	public int currentStrategyId = MELEE_STRATEGY_ID;

	private Strategy madHatterStrategy = null;
	private static Strategy meleeStrategy = null;
	private static Strategy evasionStrategy = null;

	static private StrategyManager instance = null;
	JollyNinja jollyNinja = null;
	
	static StrategyManager getInstance()
	{
		if (instance == null)
		{
			instance = new StrategyManager();
		}
		
		return instance;
	}
	
	

	private StrategyManager()
	{
		jollyNinja = JollyNinja.getInstance();
		madHatterStrategy = new MadHatterStrategy(this);

		if (meleeStrategy == null)
		{
			meleeStrategy = new MeleeStrategy(this);
		}

		if (evasionStrategy == null)
		{
			evasionStrategy = new EvasionStrategy(this);
		}

		jollyNinja.currentStrategy = meleeStrategy;
	}

	public void setStrategyId(int newStrategyId)
	{
		if (newStrategyId != currentStrategyId)
		{
			currentStrategyId = newStrategyId;

			switch (currentStrategyId)
			{
				case MAD_HATTER_STRATEGY_ID:
					jollyNinja.currentStrategy = madHatterStrategy;
					break;
				case EVASION_STRATEGY_ID:
					jollyNinja.currentStrategy = evasionStrategy;
					break;
				case MELEE_STRATEGY_ID:
					jollyNinja.currentStrategy = meleeStrategy;
			}
			jollyNinja.out.println("Strategy: " + getStrategyName(currentStrategyId));
		}
	}

	public void reset()
	{
		jollyNinja = JollyNinja.getInstance();
		jollyNinja.currentStrategy = meleeStrategy;
		currentStrategyId = MELEE_STRATEGY_ID;
		madHatterStrategy.reset();
		meleeStrategy.reset();
		evasionStrategy.reset();
	}

	public Strategy getStrategy()
	{
		Strategy currentStrategy = null;
		switch (currentStrategyId)
		{
			case MAD_HATTER_STRATEGY_ID:
				currentStrategy = madHatterStrategy;
				break;
			case EVASION_STRATEGY_ID:
				currentStrategy =  evasionStrategy;
				break;
			case MELEE_STRATEGY_ID:
				currentStrategy =  meleeStrategy;
				break;
		}
		return currentStrategy;
	}

	public String getStrategyName(int id)
	{
		String name = "Unknown Strategy";
		switch (currentStrategyId)
		{
			case MAD_HATTER_STRATEGY_ID:
				name = "Mad Hatter";
				break;
			case EVASION_STRATEGY_ID:
				name = "Evasion";
				break;
			case MELEE_STRATEGY_ID:
				name = "Melee";
				break;
		}
		return name;
	}


}