package gh.ghutils;

import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.util.*;

/**
 * EnemyWave
 *
 * This class represents the firing waves of the enemy
 * Credit: Refactoring inspired by Dookious by Voidious
 *
 * This code is open source, released under the RoboWiki Public Code License:
 * http://robowiki.net/cgi-bin/robowiki?RWPCL
 */
public class EnemyWave {

	public long fireTime;
	public double bulletVelocity;
	public double direction;
	public double HOTAngle;
	public int myVelocityBin;
	public int myNearWallBin;
	public int myAccelerationBin;
	public int myDistLast14Bin;
	public int attracBin = -1;		// very attractive bin, an intercepted bullet would end up here.
	public boolean trueWave = true;

	public Point2D.Double fireLocation = new Point2D.Double();

	// Surfing
	public double[] binrisks = new double[GHUtils.MBINS];
	public double avgrisk;
	// Flattener (future)
	public double[] binhitted = new double[GHUtils.MBINS];
	public int minimumBin = GHUtils.MBINS -1;
	public int maximumBin = 0;
	// Bulletshadows (future)
	public double[] binshadow = new double[GHUtils.MBINS];
	
	private boolean activeWave = true;
	private boolean passedWave = false;
	private double maxEscAngle;
	private double hitTime;

	public EnemyWave() { }

//	public EnemyWave( int d) {
//        direction = d;
//        maxEscAngle = Math.asin( Rules.MAX_VELOCITY / bulletVelocity);
//    }

	// updateStatus: update things like waveHitTime, passed, active etc
	public void updateStatus( long t, Point2D.Double tloc) {
		activeWave = ((getWaveDistance( t) - GHUtils.BOTWIDTH) < fireLocation.distance( tloc));
		passedWave = ((getWaveDistance( t) - GHUtils.BOTWIDTH)  > (1.4*fireLocation.distance( tloc)));
		hitTime = getWaveHitTime( tloc);
		if (!trueWave) hitTime += 1000;
	}

    // get the maximum angle I can move
	private double maxEscAngle() {
		return Math.asin( Rules.MAX_VELOCITY / bulletVelocity);
	}

	// getWaveDistance: return the distance this wave travelled
	public double getWaveDistance( long t) {
        return bulletVelocity * ( t - fireTime);
	}

	// getHitTime: get the remaining time before the wave hits
	public double getHitTime() {
		return hitTime;
	}
	// getWaveHitTime: get the remaining time before the wave hits
	private double getWaveHitTime( Point2D.Double tloc) {
		return fireTime + (tloc.distance( fireLocation) - GHUtils.HALFBOTWIDTH) / bulletVelocity;
	}

	// getWaveHitTime: get the remaining time before the wave hits
	public double getWaveHitTime( Point2D.Double tloc, boolean offset) {
		return fireTime + (tloc.distance( fireLocation) / bulletVelocity);
	}

	// checkActive: check if wave is active
	public boolean checkActive() {
		return activeWave;
	}
	// checkPassed: check if wave passed the given location
	public boolean checkPassed() {
		return passedWave;
	}

	// setRisks: set the risks for the bins and calc the average
	public void setRisks( double[] risks) {
		avgrisk = 0;
		for (int i = 0; i < GHUtils.MBINS; i++) {
			avgrisk += binrisks[i] = risks[i];
		}
		avgrisk /= GHUtils.MBINS;
	}

	// setVirtDefault: set the defaults for the virtual wave
	public void setVirtDefault() {
		bulletVelocity = 14.0;
		trueWave = false;
		binrisks[GHUtils.MMIDBIN] = 10;
		binrisks[GHUtils.MMIDBIN-1] = binrisks[GHUtils.MMIDBIN+1] = 8;
		binrisks[GHUtils.MMIDBIN-2] = binrisks[GHUtils.MMIDBIN+2] = 6;
		binrisks[GHUtils.MMIDBIN-3] = binrisks[GHUtils.MMIDBIN+3] = 4;
		binrisks[GHUtils.MMIDBIN-4] = binrisks[GHUtils.MMIDBIN+4] = 2;
		for (int i = 0; i < GHUtils.MBINS; i++) {
			avgrisk += binrisks[i];
		}
		avgrisk /= GHUtils.MBINS;
	}

	// getHittedBin: Return the bin that was hit
	public int getHittedBin( Point2D.Double hitLocation) {
		double hitAngle = GHUtils.doGetAngle( fireLocation, hitLocation);
		double angleDiff = Utils.normalRelativeAngle( hitAngle - HOTAngle);
		double guessFactor = Math.max(-2, Math.min(2, angleDiff / maxEscAngle())) * direction;
		return (int)Math.round( GHUtils.MMIDBIN * ( guessFactor + 1.0));
	}
	// getHittedBin: Return the bin that was hit
	public int getHittedBin( double hitAngle) {
		double angleDiff = Utils.normalRelativeAngle( hitAngle - HOTAngle);
		double guessFactor = Math.max(-2, Math.min(2, angleDiff / maxEscAngle())) * direction;
		return (int)Math.round( GHUtils.MMIDBIN * ( guessFactor + 1.0));
	}

	// checkDanger: Return the danger of the indexed bin
	// now takes a pyramid, but should make use of the botwidth-number-of-bins
    public double checkDanger( int index, boolean shadow) {
		double danger = 0;
		if (shadow == false) {
			danger = binrisks[index];
			if (index > 1) {
				danger += (binrisks[index-1] * 0.6);
				danger += (binrisks[index-2] * 0.2);
			}
			else if (index > 0)
				danger += (binrisks[index-1] * 0.8);
			else
				danger += (binrisks[index  ] * 0.8);
			if (index < GHUtils.MBINS-2) {
				danger += (binrisks[index+1] * 0.6);
				danger += (binrisks[index+2] * 0.2);
			}
			else if (index < GHUtils.MBINS-1)
				danger += (binrisks[index+1] * 0.8);
			else
				danger += (binrisks[index  ] * 0.8);
		}
		else { // use shadows too
			if (binshadow[index] == 0) { danger = binrisks[index]; }
			if (index > 1) {
				if (binshadow[index-1] == 0) { danger += (binrisks[index-1] * 0.6); }
				if (binshadow[index-2] == 0) { danger += (binrisks[index-2] * 0.2); }
			} else if (index > 0)
				if (binshadow[index-1] == 0) { danger += (binrisks[index-1] * 0.8); }
			else
				if (binshadow[index  ] == 0) { danger += (binrisks[index  ] * 0.8); }

			if (index < GHUtils.MBINS-2) {
				if (binshadow[index+1] == 0) { danger += (binrisks[index+1] * 0.6); }
				if (binshadow[index+2] == 0) { danger += (binrisks[index+2] * 0.2); }
			}
			else if (index < GHUtils.MBINS-1)
				if (binshadow[index+1] == 0) { danger += (binrisks[index+1] * 0.8); }
			else
				if (binshadow[index  ] == 0) { danger += (binrisks[index  ] * 0.8); }
		}
		danger /= avgrisk;	// normalise against average for this wave
		return danger;
	}

	// Calculate danger of total botwidth
//	public double checkDanger(enemyWave surfWave, int direction) {
//		double danger = 0.0;
//		int index, mindex, maxdex;
//		Point2D.Double botpos = new Point2D.Double();
//		Point2D.Double tmppos = new Point2D.Double();
//		botpos = predictPosition( surfWave, direction);
//		tmppos.setLocation( botpos.getX() - HALFBOTWIDTH, botpos.getY() - HALFBOTWIDTH);
//		index = mindex = maxdex = getHittedBin( surfWave, tmppos);
//		tmppos.setLocation( botpos.getX() - HALFBOTWIDTH, botpos.getY() + HALFBOTWIDTH);
//		index = getHittedBin( surfWave, tmppos);
//		if (index < mindex) mindex = index;
//		if (index > maxdex) maxdex = index;
//		tmppos.setLocation( botpos.getX() + HALFBOTWIDTH, botpos.getY() + HALFBOTWIDTH);
//		index = getHittedBin( surfWave, tmppos);
//		if (index < mindex) mindex = index;
//		if (index > maxdex) maxdex = index;
//		tmppos.setLocation( botpos.getX() + HALFBOTWIDTH, botpos.getY() - HALFBOTWIDTH);
//		index = getHittedBin( surfWave, tmppos);
//		if (index < mindex) mindex = index;
//		if (index > maxdex) maxdex = index;
//System.out.println(currTime+" "+direction+" MIN: "+mindex+" MAX: "+maxdex);

////		index = getHittedBin( surfWave, botpos);

//		for (index = mindex; index <= maxdex; index++) {
//			danger += surfWave.binrisks[index];
//		}
////		predictPosition( surfWave, direction));

//		danger /= surfWave.avgrisk;									// normalise against average for this wave
//		danger *= (10.0 / (4.0 + getWaveHitTime( surfWave)));		// bullet flighttime dependent
//		danger *= (1.0 + (20.0 - surfWave.bulletVelocity)/3.0);		// bulletpower dependent
////			System.out.println("WHT "+getWaveHitTime( surfWave)+" bulV "+surfWave.bulletVelocity);
//		return danger;
//	}

}
