package dam.targetting;




public class CircularTargettingSimple extends TargettingStrategy
{
	
	public void guess(long when)
	{
		double diff = when - target.getLastScanTime();
		double head = target.getHeading();
		double newx, newy;
		double changehead = target.getHeadingChange();
		double averageSpeed = target.getVelocity();
		if(Math.abs(changehead) > 0.00001){
			double radius = averageSpeed / changehead;
			double tothead = diff * changehead;
			newy = target.y + (Math.sin(head + tothead) * radius) - (Math.sin(head) * radius);
			newx = target.x + (Math.cos(head) * radius) - (Math.cos(head + tothead) * radius);
		}
		else
		{
			newy = target.y + Math.cos(head) * averageSpeed * diff;
			newx = target.x + Math.sin(head) * averageSpeed * diff;
		}
		setPoint(newx, newy);
	}
	

}