package bvh.mini;

/**********************************************************************
** Constanten zijn apart vastgelegd in interface.
**********************************************************************/
public interface Constanten {
//
   static final double TWEEPI               = 2D*Math.PI;   // 360 graden draaien
   static final double PI                   = Math.PI;      // 180 graden draaien
   static final double DRIEKWARTPI          = 3D*Math.PI/4D;// 135 graden draaien
   static final double HALFPI               = Math.PI/2D;   //  90 graden draaien
   static final double DRIEACHTSTEPI        = 3D*Math.PI/8D;//  67.5 graden draaien
   static final double KWARTPI              = Math.PI/4D;   //  45 graden draaien
   static final double EENACHTSTEPI         = Math.PI/8D;   //  22.5 graden draaien
   static final double EENZESTIENDEPI       = Math.PI/16D;  //  11.25 graden draaien

	static final double VOORKEURSAFSTAND     = 600; //525;

   static final int    COUNTRESET           = 10;       // tijd waarna huidig doel wordt 'vergeten'
   static final double MAXIMUM_SNELHEID     = 8;
   static final double STANDAARDLOOPAFSTAND = 72D;      // kleine stapjes (draaihoek is belangrijker)
   static final double MINIMUMLOOPAFSTAND   = 36D;      // kleine stapjes (draaihoek is belangrijker)
   static final double MAXIMUMLOOPAFSTAND   = 144D;      // kleine stapjes (draaihoek is belangrijker)
   static final double DIAMETERBINNENCIRKEL = 300D;     // straal binnen cirkel
   static final double DIAMETERBUITENCIRKEL = 800D;     // straal buiten cirkel

   static final double WANDAFSTAND          = 54D;      // minimale afstand tot wand: anders bewegingsrichting omkeren
   static final double RONDING              = 108D;     // ronding van slagveld

   static final double STANDAARDVUURKRACHT  = 2.3D;       // stapjes waarmee vuurkracht wordt vergroot (was 0.4)
   static final double MAXVUURKRACHT        = 3.0D;     // maximale vuurkracht
   static final double MINVUURKRACHT        = 0.1D;     // minimale vuurkracht: doel is constante overbruggingstijd
   static final double MAXKOGELSNELHEID     = 19.7;
   static final double MINKOGELSNELHEID     = 11.0;
   static final int    PATROONLENGTE        = 100000;
   static final int    ZOEK_DIEPTE          = 5;        // lengte in patroon dat moet worden ge-matched (niet groter dan 25 a 30 maken!)
	static final int    GF_MIDDEN            = 13;       // hoeksegmenten = 2*GF_MIDDEN+1
   static final int    AFSTANDSEGMENTEN     = 8;
   static final int    POSITIESEGMENTEN     = 3;
   static final int    VERSNELLINGSSEGMENTEN= 3;
   static final int    TIJDSEGMENTEN        = 5;
   static final int    SNELHEIDSSEGMENTEN   = 5; // was 3: nu 5 voor rotatie

   static final int    DEBUGMODE            = 1;        // 0: geen debug meldingen, 1: doel/schiet-info, 2: incl. bewegingsinfo, 3: alle info
}
