/*
 * Copyright (c) 2004 Marcin Fuszara
 */  
package fushi.PvP1;
import robocode.*;

/* a simple simulator for predicting enemy positions based
 * on data from a pattern matcher;
 */
public class EnemySimulator
{
   Vector2d position; //< enemy position
   double heading;    //< enemy heading
   
   public EnemySimulator()
   {
      position = new Vector2d();
      heading = 0;
   }
   
   /* use this method to set enemy's position and heading
    */
   public void set( Vector2d position, double heading )
   {
      this.position.set( position );
      this.heading = heading;
   }
   
   /* run this method for each simulated frame giving robot's
    * speed and change in heading
    */
   public void frame( double speed, double headingDelta )
   {
      heading = Util.normalAbsoluteAngle( heading + headingDelta );
      Vector2d positionDelta = new Vector2d();
      positionDelta.setFromAngleDistance( heading, speed );
      position.add( positionDelta );
   }
   
   /* return current enemy position in simulator
    */
   public Vector2d getPosition()
   {
      return new Vector2d( position );
   }
   
}
      