package maribo;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

import maribo.utils.MoveSim;
import maribo.utils.M;

import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

/**
 * 
 * @author Alexander MacKenzie (a.k.a. Maribo)
 * 
 * Using M by:
 * @author Alexander Schultz (a.k.a. Rednaxela)
 * @author Julian Kent (a.k.a. Skilgannon)
 * @author Flemming N. Larsen
 * @author Mathew A. Nelson
 * @author Nat Pavasant
 * 
 * also using a modified version of Future Position by:
 * @author Albert
 *
 */

public class Quester extends AdvancedRobot {
	static { M.init(); }
	
	static int[] finishes;
	public static Point2D.Double pred = new Point2D.Double();
	static ArrayList<TestPoint> points = new ArrayList<TestPoint>();
	static ArrayList<Point2D.Double> evalMe = new ArrayList<Point2D.Double>();
	static ArrayList<Point2D.Double> evalVB = new ArrayList<Point2D.Double>();
	
	static int numEn;
	static int curNumEn;
	static final double PI = Math.PI;
	static final int distFact = 350;
	static final int distSeg = (1400/distFact)+1;
	static double bFHeight, bFWidth;
	
	static HashMap<String, Enemy> en = new HashMap<String, Enemy>();
	static Enemy targ;
	static String targName;
	static Enemy myRobo;
	
	static TestPoint nextDestination;
	static Point2D.Double lastPos;
	static Rectangle2D.Double moveField;
	static ArrayList<VirtualBullet> enVirtBullets = new ArrayList<VirtualBullet>();
	static ArrayList<Gun> enGuns;
	
	static ArrayList<Gun> guns;
	static Rectangle2D.Double board;
	static ArrayList<VirtualBullet> virtualBullets = new ArrayList<VirtualBullet>();
	
	public void run() {
		if (finishes == null) finishes = new int[getOthers()+1];
		setBulletColor(Color.BLACK);
		
		setBodyColor(new Color((float)Math.random(),(float)Math.random(),(float)Math.random()));
		setGunColor(new Color((float)Math.random(),(float)Math.random(),(float)Math.random()));
		setRadarColor(new Color((float)Math.random(),(float)Math.random(),(float)Math.random()));
		//setBulletColor(new Color((float)Math.random(),(float)Math.random(),(float)Math.random()));
		setScanColor(new Color((float)Math.random(),(float)Math.random(),(float)Math.random()));
		
		moveField = new Rectangle2D.Double(30, 30,
				(bFWidth = getBattleFieldWidth())-60, (bFHeight = getBattleFieldHeight())-60);
		board = new Rectangle2D.Double(17.9, 17.9, bFWidth-35.8, bFHeight-35.8);
		
		curNumEn = numEn = getOthers();
		
		if (guns == null) {
			guns = new ArrayList<Gun>();
			guns.add(new CircularGun());
			guns.add(new HeadOnGun());
			guns.add(new Linear50Gun());
			guns.add(new LinearGun());
			
			enGuns = new ArrayList<Gun>();
			enGuns.add(new HeadOnGun());
			enGuns.add(new CircularGun());
		}
		
		virtualBullets.clear();
		enVirtBullets.clear();
		targName = "";
		myRobo = new Enemy();
		targ = new Enemy();
		targ.setLocation(100000, 100000);
		
		nextDestination = new TestPoint();
		nextDestination.setLocation(getX(), getY());
		lastPos = new Point2D.Double(getX(), getY());

		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		while (true) {
			curNumEn = getOthers();
			myRobo.setLocation(calcPos(new Point2D.Double(getX(), getY()), (myRobo.velocity = getVelocity()), (myRobo.heading = getHeadingRadians())));
			if (getRadarTurnRemainingRadians() == 0) setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			moveVB();
			moveEnVB();
			if (targ.x != 100000) gun();
			if (!en.isEmpty()) movement();
			execute();
		}
	}
	
	public void moveVB() {
		Iterator<VirtualBullet> i = virtualBullets.iterator();
		while (i.hasNext()) {
			VirtualBullet vb = (VirtualBullet) i.next();
			vb.setLocation(calcPos(vb, vb.velocity, vb.heading));
			Iterator<Enemy> enIt = en.values().iterator();
			while (enIt.hasNext()) {
				Enemy nEn = (Enemy) enIt.next();
				if (new Rectangle((int)nEn.x-18, (int)nEn.y-18, 36, 36).contains(vb)) {
					try {
						vb.gunUsed.hits[getOthers()/3][(int) (targ.distance(myRobo)/distFact)]++;
						i.remove();
					} catch (Exception ex) { }
				}
			}
		}
	}
	
	public void moveEnVB() {
		Iterator<VirtualBullet> i = enVirtBullets.iterator();
		while (i.hasNext()) {
			VirtualBullet vb = (VirtualBullet) i.next();
			vb.setLocation(calcPos(vb, vb.velocity, vb.heading));
			if (new Rectangle((int)myRobo.x-18, (int)myRobo.y-18, 36, 36).contains(vb)) {
				try { i.remove(); }
				catch (Exception ex) { }
			}
			if (vb.distance(targ) > myRobo.distance(targ)+18) {
				try { i.remove(); }
				catch (Exception ex) { }
			}
		}
	}
	
	public void gun() {
		double dist = targ.distance(myRobo);
		
		long bestScore = -1;
		Gun bestGun = null;
		Iterator<Gun> i = guns.iterator();
		while (i.hasNext()) {
			Gun gun = (Gun) i.next();
			if (gun.hits[getOthers()/3][(int) (targ.distance(myRobo)/distFact)] > bestScore) {
				bestScore = gun.hits[getOthers()/3][(int) (targ.distance(myRobo)/distFact)];
				bestGun = gun;
			}
		}
		
		double bulletPower;
		setTurnGunRightRadians(M.normalRelativeAngle(
				bestGun.getFiringAngle(myRobo, targ, (bulletPower = M.min(2.4999, (600+90*(getOthers()-1))/dist)))
				- getGunHeadingRadians()));
		
		Bullet b = setFireBullet(bulletPower);
		if (b != null) {
			i = guns.iterator();
			while (i.hasNext()) { addBullet(i.next(), bulletPower); }
		}
	}
	
	public void addBullet(Gun gun, double bulletPower) {
		VirtualBullet newVirtualBullet = new VirtualBullet();
		newVirtualBullet.setLocation(calcPos(myRobo,
				(newVirtualBullet.velocity = Rules.getBulletSpeed(bulletPower)),
				(newVirtualBullet.heading = gun.getFiringAngle(myRobo, targ, bulletPower))));
		newVirtualBullet.gunUsed = gun;
		virtualBullets.add(newVirtualBullet);
	}
	
	public void movement() {
		double distToNextDest;
		if ((distToNextDest = myRobo.distance(nextDestination)) < 25) {
			points.clear();
			
			TestPoint testPoint = new TestPoint();
			int enMult = numEn-curNumEn;
			int i = 0;
			do {
				testPoint = new TestPoint();
				testPoint.setLocation(calcPos(myRobo, M.min(targ.distance(myRobo)*0.9,
						(192-(16*enMult))+(Math.random()*32*enMult)), i*PI/50.0));
				if (board.contains(testPoint)) {
					TestPoint temp = new TestPoint();
					temp.setLocation(testPoint);
					MoveSim sim = new MoveSim();
					temp.move = sim.futurePos(testPoint, 5, myRobo, myRobo.velocity, 2, 0.785, 8,
							myRobo.heading, 10, bFWidth, bFHeight);
					temp.moveHitWall = sim.hitWall;
					if (!temp.moveHitWall) {
						temp.eval = evaluate(temp, false);
						points.add(temp);
						if (temp.eval < evaluate(nextDestination, true)) {
							nextDestination = temp;
						}
					}
				}
			} while (i++ < 160*(numEn+1)/(curNumEn+1));
			lastPos = new Point2D.Double(myRobo.x, myRobo.y);
		} else {
			double angle = Utils.normalRelativeAngle(calcAngle(nextDestination, myRobo) - getHeadingRadians());
			double turnAngle = Math.atan(Math.tan(angle));
			setTurnRightRadians(turnAngle);
			setAhead(distToNextDest * ((angle == turnAngle) ? 1 : -1));
			setMaxVelocity(M.abs(turnAngle) > 0.785 ? 2 : 8d);
		}
	}
	
	public double evaluate(TestPoint test, boolean nextDest) {
		double danger = 0;
		Iterator<Enemy> enIt = en.values().iterator();
		while (enIt.hasNext()) {
			Enemy nEn = (Enemy) enIt.next();
			double enDang = 0;
			enDang += (nEn.energy+30)
					* (1+M.abs(M.cos(calcAngle(myRobo, test) - calcAngle(nEn, test))))
					/ M.pow(nEn.distance(test), 2-((curNumEn-1)/3)/2.0);
			int numClose = 0;
			Iterator<Enemy> enIt2 = en.values().iterator();
			while (enIt2.hasNext()) {
				if (enIt2.next().distance(nEn) < nEn.distance(myRobo)) numClose++;
			}
			if (numClose < 3) enDang *= 2;
			danger += enDang;
		}
		
		if (nextDest) {
			evalMe.clear();
			evalVB.clear();
		}
		
		if (enVirtBullets.size() != 0 && curNumEn < 3) {
			Iterator<VirtualBullet> e = enVirtBullets.iterator();
			ArrayList<VirtualBullet> move = new ArrayList<VirtualBullet>();
			while (e.hasNext()) {
				move.add(new VirtualBullet((VirtualBullet) e.next()));
			}
			double[][] bulletDist = new double[2][move.size()];
			int i = 0;
			e = move.iterator();
			while (e.hasNext()) {
				VirtualBullet tEnB = (VirtualBullet) e.next();
				bulletDist[0][i] = tEnB.velocity * M.sin(tEnB.heading);
				bulletDist[1][i++] = tEnB.velocity * M.cos(tEnB.heading);
			}
			int j = -1;
			Point2D.Double myTest;
			while (++j < test.move.size()) {
				myTest = new Point2D.Double(test.move.get(j).x, test.move.get(j).y);
				if (nextDest) evalMe.add(new Point2D.Double(myTest.x, myTest.y));
				i = 0;
				e = move.iterator();
				while (e.hasNext()) {
					VirtualBullet enB = (VirtualBullet) e.next();
					enB.x += bulletDist[0][i];
					enB.y += bulletDist[1][i++];
					danger += 50.0 / ((double)test.move.size() * enB.distanceSq(myTest));
					if (nextDest) evalVB.add(new Point2D.Double(enB.x, enB.y));
				}
			}
		}
		
		danger += (1+10*(curNumEn-1))/test.distanceSq(lastPos);
		return danger;
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		String enName = e.getName();
		
		if (curNumEn < 3 && enName.equals(targName)) {
			double bP;
			if ((bP = targ.energy - e.getEnergy()) > 0 && bP <= 3) {
				Iterator<Gun> i = enGuns.iterator();
				while (i.hasNext()) {
					Gun gun = (Gun) i.next();
					VirtualBullet enBullet = new VirtualBullet();
					enBullet.setLocation(calcPos(targ, (enBullet.velocity = 20 - 3 * bP),
							(enBullet.heading = gun.getFiringAngle(targ, myRobo, bP))));
					enBullet.gunUsed = gun;
					enVirtBullets.add(enBullet);
				}
			}
		}
		
		Enemy temp;
		temp = (en.containsKey(enName)) ? en.get(enName) : new Enemy();
		temp.updateAll(calcPos(myRobo, e.getDistance(), getHeadingRadians() + e.getBearingRadians()),
				e.getHeadingRadians(), e.getVelocity(), e.getTime(), e.getEnergy());
		en.put(enName, temp);
		
		if (temp.distance(myRobo) < targ.distance(myRobo)*.9) {
			targ = en.get(enName);
			targName = e.getName();
		}
		if (getGunHeat() < 0.7 || getOthers() < 2) {
			setTurnRadarRightRadians(2.1*M.normalRelativeAngle(calcAngle(targ, myRobo)-getRadarHeadingRadians()));
		}
	}
	
	public void onBulletHit(BulletHitEvent e) {
		try { en.get(e.getName()).energy -= Rules.getBulletDamage(e.getBullet().getPower());
		} catch (Exception ex) {}
	}
	public void onHitByBullet(HitByBulletEvent e) {
		try { en.get(e.getName()).energy += Rules.getBulletDamage(e.getBullet().getPower());
		} catch (Exception ex) {}
	}
	public void onHitRobot(HitRobotEvent e) {
		nextDestination.setLocation(myRobo);
		try { en.get(e.getName()).energy -= 0.6;
		} catch (Exception ex) {}
	}
	public void onRobotDeath(RobotDeathEvent e) {
		en.remove(e.getName());
		targ.setLocation(100000, 100000);
	}
	
	public static Point2D.Double calcPos(Point2D.Double loc, double distance, double bearing) {
		return new Point2D.Double(loc.x + distance * M.sin(bearing), loc.y + distance * M.cos(bearing));
	}
	public static double calcAngle(Point2D.Double p2, Point2D.Double p1){
		return M.atan2(p2.x - p1.x, p2.y - p1.y);
	}
	
	
	public void onWin(WinEvent e) { onDeath(null); }
	public void onDeath(DeathEvent e) {
		endRound();
		finishes[getOthers()]++;
		for (int i = 0; i < finishes.length; i++)
			out.print(finishes[i] + " ");
		out.println();
	}
	public void endRound() {
		virtualBullets.clear();
		Iterator<Gun> i = guns.iterator();
		out.println();
		out.println("Data segmented by enemies remaining");
		out.println("Also by distance");
		out.println("numEn / 3");
		out.println("distance / " + distFact);
		out.println("Virtual bullet hit table");
		out.println("------------------------");
		while (i.hasNext()) {
			Gun gun = (Gun) i.next();
			out.println(gun.getName() + ": ");
			for (int j = 0; j <= numEn/3; j++) {
				for (int k = 0; k < distSeg; k++) {
					out.print(gun.hits[j][k] + ",\t");
				}
				out.println();
			}
			out.println();
		}
		out.println();
	}
	
	public void onPaint(Graphics2D g){
		g.setColor(Color.GREEN);
		g.fillRect((int)myRobo.x-18, (int)myRobo.y-18, 36, 36);
		g.fillOval((int)nextDestination.x-9, (int)nextDestination.y-9, 18, 18);
		g.setColor(Color.green.darker().darker());
		g.fillOval((int)lastPos.x-9, (int)lastPos.y-9, 18, 18);
		g.setColor(Color.RED);
		Iterator<Enemy> e = en.values().iterator();
		while (e.hasNext()) {
			Enemy tmp = (Enemy) e.next();
			g.fillRect((int)tmp.x-18, (int)tmp.y-18, 36, 36);
		}
		g.setColor(Color.ORANGE);
		g.fillRect((int)pred.x-18, (int)pred.y-18, 36, 36);
		
		Iterator<VirtualBullet> i = virtualBullets.iterator();
		while (i.hasNext()) {
			VirtualBullet virtualBullet = (VirtualBullet) i.next();
			g.setColor(virtualBullet.gunUsed.getColor());
			g.fillOval((int)virtualBullet.x-3, (int)virtualBullet.y-3, 6, 6);
		}
		
		Iterator<VirtualBullet> eB = enVirtBullets.iterator();
		while (eB.hasNext()) {
			VirtualBullet virtualBullet = (VirtualBullet) eB.next();
			g.setColor(Color.red.darker());
			g.fillOval((int)virtualBullet.x-3, (int)virtualBullet.y-3, 6, 6);
		}
		
		int numberOfGuns = guns.size();
		for (int j = 0; j < numberOfGuns; j++) {
			Gun gun = (Gun) guns.get(j);
			g.setColor(Color.WHITE);
			int hits = 0;
			for (int k = 0; k <= numEn/3; k++) for (int l = 0; l < distSeg; l++) hits += gun.hits[k][l];
			g.drawString(gun.getName() + ": " + hits, 20, 5 + j*15);
			g.setColor(gun.getColor());
			g.fillOval(5, 5 + j * 15, 10, 10);
		}
		
		Iterator<Point2D.Double> m = evalMe.iterator();
		while (m.hasNext()) {
			Point2D.Double me = (Point2D.Double) m.next();
			g.setColor(Color.YELLOW.darker());
			g.fillRect((int) me.x-3, (int) me.y-3, 6, 6);
		}
		m = evalVB.iterator();
		while (m.hasNext()) {
			Point2D.Double vb = (Point2D.Double) m.next();
			g.setColor(Color.YELLOW.darker());
			g.fillOval((int) vb.x-4, (int) vb.y-4, 8, 8);
		}
		
		Collections.sort(points, new CustomComparator());
		
		Iterator<TestPoint> p = points.iterator();
		int q = 0;
		while (p.hasNext()) {
			TestPoint point = (TestPoint)p.next();
			int col = (int) ((255.0*q)/points.size());
			g.setColor(new Color(col, 0, 255-col));
			g.fillOval((int) point.x-3, (int) point.y-3, 6, 6);
			q++;
		}
	}
	public class CustomComparator implements Comparator<TestPoint> {
	    @Override
	    public int compare(TestPoint o1, TestPoint o2) {
	    	return (int) (1000000*o1.eval - o2.eval*1000000);
	    }
	}
}