package ags.muse.recon.events;

import robocode.StatusEvent;
import ags.muse.base.Rules;
import ags.util.points.AbsolutePoint;
import ags.util.points.RelativePoint;

public class SelfReconEvent extends ReconEvent {
    private static final long serialVersionUID = 1L;

    // Stored data
    private final double gunHeading, gunHeat, radarHeading;
    
    // Getters
    public double getGunHeading() { return gunHeading; }
    public double getGunHeat() { return gunHeat; }
    public double getRadarHeading() { return radarHeading; }
    
    // Constructor
    public SelfReconEvent(Rules rules, StatusEvent event) {
        super(
                event.getTime(),
                rules.NAME,
                AbsolutePoint.fromXY(event.getStatus().getX(), event.getStatus().getY()),
                RelativePoint.fromDM(event.getStatus().getHeadingRadians(), event.getStatus().getVelocity()),
                event.getStatus().getEnergy()
        );
        gunHeading = event.getStatus().getGunHeadingRadians();
        gunHeat = event.getStatus().getGunHeat();
        radarHeading = event.getStatus().getRadarHeadingRadians();
    }
    

}
