package hamilton;

import robocode.*;

public class Hamilton extends AdvancedRobot
{
	TargetManager t;
	RadarManager r;
	GunManager g;
	FieldManager f;
	MovementManager m;
	
	Statistic reactionAverage;
	
	public void run() 
	{
		System.out.println("width = " + getWidth());

		t = new TargetManager(this);
		r = new RadarManager(this, t);		
		g = new GunManager(this, t);
		f = new FieldManager(this, t);
		m = new MovementManager(this, t, f);
		
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		
		while(true)
		{
			if (getOthers() > 1) melee();
			else duel();
		}	
	}
	
	public void duel()
	{
		r.doDuel();
		g.doMelee();
		m.doMelee();
		execute();
	}
	
	public void melee()
	{
		r.doMelee();
		g.doMelee();
		m.doMelee();
		execute();
	}
	
	public void onScannedRobot(ScannedRobotEvent e)
	{
		t.updateTarget(e);
	}
	
	public void onBulletHit(BulletHitEvent e)
	{
		// figure out compensation for fire detection
		t.hamiltonHitTarget(e);
		g.energyGainedShooting += e.getBullet().getPower() * 3;		
	}
	
	public void onHitByBullet(HitByBulletEvent e)
	{
		// figure out compensation for fire detection
		t.targetHitHamilton(e);
		
		double damage = (4 * e.getPower());
		if (e.getPower() > 1) damage += 2 * (e.getPower() -1);
		
		g.energyLostGettingHit += damage;

	}
	
	public void onBulletMissed(BulletMissedEvent e)
	{

	}
	
	public void onRobotDeath(RobotDeathEvent e)
	{
		t.removeTarget(e.getName());
	}
	 
	public void onDeath(DeathEvent e)
	{
		
	}

}			
