package gh.nano;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.awt.Color;

/**
 * GrofGroup - a nanoteam by Gert Heijenk (GrubbmGait)
 *
 * This is just a try to get a working and reasonable performing nanoteam.
 * It is based on nano.Grofvuil for 95%, the differences are:
 * - checking if teammate is scanned
 * - strongly going away from enemy if distance < 140
 * - going slightly more towards enemy if distance > 140
 * - no hysteresis when selecting enemy (always pick closest)
 *
 * Revision information:
 * v0.1 20050607 Initial version. First attempt to make a nanoteam.
 * v0.2 20050608 Do not shoot at teammates direction, peeked at DoctorBob's behaviour
 */

public class GrofGroupMember extends TeamRobot {

	static double direction = 0.5;
	static final double halfpi = Math.PI/2;

	// some info about the current locked opponent
//	static private String	eName;		// enemy name
	static private double	eAttrac;	// enemy attractivity (less is better)

	/**
	 * run: Grofvuil's default behavior
	 */
	public void run() {
		// Give the robot an appealing look
//		setColors( Color.red, Color.white, Color.red);

		// Start with a very unattractive target (copied from mld.Infinity)
		onRobotDeath(null);

		// Let gun (and not radar) move independently
		setAdjustGunForRobotTurn( true);
//		setAdjustRadarForGunTurn( true);		// is this necessary ??
		turnRadarRight( Double.POSITIVE_INFINITY);

		// mainloop
//		while( true ) {
			// perform all actions previously set
//			execute();
//		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {

		double dist = e.getDistance();

		// first check if it is a Teammate
		if (isTeammate( e.getName()) == false) {

//			eAttrac *= 1.2;
			// second check attractivity of scanned robot
			if (dist >= (eAttrac *= 1.2)) {
				return;		// new not very appealing enemy
			}
//			eName = e.getName();	// same enemy or new more attractive enemy
			eAttrac = dist;			// set new attractivity

			// If we've reached the end of the oscillation, go back again.
			if (getDistanceRemaining() == 0)
			{
				// oscillate half the enemydistance
				setAhead((direction = -direction) * dist);
			}
			// Stay approx perpendicular to the opponent when in lock-mode
			setTurnRightRadians( Utils.normalRelativeAngle( e.getBearingRadians() + halfpi - (dist > 140 ? direction / 3 : -direction)));

			dist = (getEnergy() * 15) / dist;	// energy management

			// If the gun is cool and I do not disable myself: Fire !
			if ((getGunHeat() == 0.0) && (getEnergy() > 1)) {
				setFire( dist);
			}
			else {
				// when not firing, lock on target. After firing, perform a sweep
				setTurnRadarLeft(getRadarTurnRemaining());
			}
			// Turn gun after eventual firing
			double tmpb = (dist = getHeadingRadians() + e.getBearingRadians()) - e.getHeadingRadians() + halfpi;
			setTurnGunRightRadians( Utils.normalRelativeAngle( dist - getGunHeadingRadians() + Math.atan2(Math.cos(tmpb) * e.getVelocity(), 14 + Math.sin(tmpb))));
		}
		// Helps in melee to lock onto nearest target.
		clearAllEvents();
	}

	/**
	 * onRobotDeath: What to do when someone else dies
	 */
	public void onRobotDeath(RobotDeathEvent e) {
		// Copied from mld.Infinity, a shortcut to 'forget' killed targets
		eAttrac = Double.POSITIVE_INFINITY;		// make least attractive
	}
}