package whind;
import robocode.*;
import java.util.Hashtable;
import robocode.util.Utils.*;
import java.util.*;
import java.awt.Color;
import java.awt.geom.*;
import whind.EBullet;
import whind.VGunBattery;
import whind.VBullet;
import whind.LaserBullet;

/**
 * Dexterity - a robot by Greywhind
 */
public class Constitution extends AdvancedRobot
{
	Random gen = new Random();
	
	// for my movement
	boolean nearwall = false;
	int direction = 1;
	double timeOfLastDirChange = 0;
	static boolean musashi;
	double eBearing;
	boolean adjustForWall = false;
	int changeWait = 0;
	
	// for statistics
	static int bulletsFired = 0;
	int roundFired = 0;
	static int hits = 0;
	
	// for enemy tracking
	double prevVelocity;
	double currVelocity;
	Point2D.Double doublePrevPos;
	Point2D.Double prevPosition;
	Point2D.Double currPosition;
	double prevEnergy;
	double currEnergy;
	Rectangle2D.Double fieldRectangle;
	int timeSinceLastScan = 0;
	double absBearing;
	Vector allBullets = new Vector();
	double enemyX;
    double enemyY;
	double eGunHeat;
	int gotHit;
	int eRoundFired;
	double coolRate;
	double eDist;
	String Tracking = "";
	double lastEnemyHeading;
	double plastEnemyHeading;
	int eDirection;
	
	// for vguns
	VGunBattery myVGuns;
	VBullet tB;
	double honprednow;
	double linprednow;
	double circprednow;
	double lasprednow;
	double pmprednow;
	double gfprednow;
	Integer fireMethod;
	double power;

	// for Laser Targeting
	static Object[] allHitOffsets = new Object[14];
	Vector segmentHitOffsets;
	Vector myBullets = new Vector();
	
	// for Pattern Matching
	static StringBuffer fullPattern = new StringBuffer();
	Vector lastFew = new Vector();
	static int MAX_SEARCHES = 20;
	static Vector arcLength = new Vector();
	static int historyIndex = 0;
	static int MAX_BUFFER_SIZE = 2000;
	double paramOne;
	double paramTwo;
	
	// for GF gun
	static int wavesHit = 0;
	List waves = new ArrayList();
	static int[][] stats = new int[14][31];       //31 is the number of unique guessfactors we're using
	double gfAngleOffset;
	
	// for dynamic distancing
	final static int DISTBINS = 8;
	double[] distValues = new double[DISTBINS];
	int bestDistBin;
	double ePrevEnergy;
	double myPrevEnergy;

	/**
	 * run: Constitution's default behavior
	 */
	public void run() {
		timeOfLastDirChange = getTime();
		coolRate = getGunCoolingRate();
		fieldRectangle = new Rectangle2D.Double(0, 0, getBattleFieldWidth(), getBattleFieldHeight());
		myVGuns = new VGunBattery(getBattleFieldHeight(), getBattleFieldWidth());
		
		for (int i = 0; i < 14; i++) {
			allHitOffsets[i] = new Vector();
		}
		
		// all the things to do only the first round.
		if (getRoundNum() == 0) {
			musashi = true;
			
			setAdjustGunForRobotTurn(false);
			setAdjustRadarForRobotTurn(false);
			setColors(Color.red,Color.orange,Color.red);
			
			for (int i = 0; i <= MAX_BUFFER_SIZE; i++) {
				arcLength.add(new Double(0));
			}
		}
			
		while(true) {
			doScanner();
			
			if (eGunHeat > coolRate) {
				eGunHeat -= coolRate;
			} else {
				eGunHeat = 0;
			}
			
			
			/*if (getX()<50 || getY()<50 || getX()>getBattleFieldWidth()-50 || getY()>getBattleFieldHeight()-50) {
    			if (nearwall == false) {
        			direction *= -1;
					timeOfLastDirChange = getTime();
        			nearwall = true;
					//out.println("Near wall");
    			}
    			else {
       				//out.println("Still near wall");
    			}
			}
			else {
			    nearwall=false;
			}*/
			
			if (musashi == true) {
				moveMusashi();
			} else {
				moveDodging();
			}
			
			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		if (Tracking.equals("")) {
			Tracking = e.getName();
			out.println("Tracking " + Tracking);
		}
		if(e.getName().equals(Tracking)) {
			timeSinceLastScan = 0;
			absBearing = getHeadingRadians() + e.getBearingRadians();
			enemyX = getX() + e.getDistance() * Math.sin(absBearing);
        	enemyY = getY() + e.getDistance() * Math.cos(absBearing);
			eDist = e.getDistance();

			prevVelocity = currVelocity;
			currVelocity = e.getVelocity();
		
			doublePrevPos = prevPosition;
			prevPosition = currPosition;
			currPosition = new Point2D.Double(enemyX, enemyY);
		
			prevEnergy = currEnergy;
			currEnergy = e.getEnergy();
			
			power = Math.min(1.99, e.getEnergy()/4);
			
			// update values for dynamic distancing
				distValues[(int)eDist/(1400/(DISTBINS-1))] += ePrevEnergy - e.getEnergy();
				distValues[(int)eDist/(1400/(DISTBINS-1))] -= myPrevEnergy - getEnergy();
				double currBestVal = 0;
				for (int i = 0; i < DISTBINS; i++) {
					if (distValues[i] > currBestVal) {
						currBestVal = distValues[i];
						bestDistBin = i;
					}
				}
                ePrevEnergy = e.getEnergy();
				myPrevEnergy = getEnergy();
			
			// keep laser targeting info up to date
			updateLaserTargeting(e, power);
			updatePMTargeting(e, power);
			updateGFTargeting(e);
			
			// update VGun predictions
			honprednow = returnHeadOn(e);
			linprednow = returnLinear(e, absBearing, enemyX, enemyY);
			circprednow = returnCircular(e);
			lasprednow = returnLaser(e);
			pmprednow = returnPattern(e, power);
			gfprednow = returnGuessFactor();
			
			//out.println("Pos: " + currPosition + " Vel: " + currVelocity + " Energy: " + currEnergy);
			if (doublePrevPos != null) {
				if (prevEnergy - currEnergy <= 3 && prevEnergy - currEnergy > 0) {
					//out.println("Enemy Fired.");
					eRoundFired++;
					eGunHeat = 1 + ((prevEnergy-currEnergy) / 5);
					allBullets.add(new EBullet(doublePrevPos.getX(), doublePrevPos.getY(), getX(), getY(), doublePrevPos.distance(new Point2D.Double(getX(), getY())), prevEnergy - currEnergy));
				}
			}
			//setTurnLeft(90 - e.getBearing());
			eBearing = e.getBearing();
			double iHit = (double)hits/(double)roundFired;
			
            //don't try to figure out the direction they're moving if they're not moving, just use the direction we had before
            if (e.getVelocity() != 0) {
                if (Math.sin(e.getHeadingRadians()-absBearing)*e.getVelocity() < 0)
                    eDirection = -1;
                else
                    eDirection = 1;
			}

			if (roundFired > 0) {
            	myVGuns.addBullet(getX(), getY(), absBearing, power, eDirection, getTime(), e.getHeadingRadians(), lastEnemyHeading, e.getVelocity(), honprednow, linprednow, circprednow, lasprednow, pmprednow, gfprednow);
				tB = (VBullet)myVGuns.checkBullets(e, enemyX, enemyY, getTime(), e.getDistance());
				if (tB != null) {
					//out.println("enemyX: " + enemyX + " startX: " + tB.startx + " current time: " + getTime() + " fire time: " + tB.fireTime);
					double desiredDirection = Math.atan2(enemyX-tB.startx, enemyY-tB.starty);
             		double angleOffset = Math.toDegrees(robocode.util.Utils.normalRelativeAngle(desiredDirection));
					out.println("Hit: " + (int)angleOffset + " H= " + myVGuns.gunValues[0] + " Li= " + myVGuns.gunValues[1] + " C= " + myVGuns.gunValues[2] + " La= " + myVGuns.gunValues[3] + " PM= " + myVGuns.gunValues[4] + " GF= " + myVGuns.gunValues[5]);
					out.println("Circular at " + (int)myVGuns.cPredictedAngle + " hit at " +(int)angleOffset);
					out.println("HeadOn at " + (int)myVGuns.hPredictedAngle + " hit at " + (int)angleOffset);
					out.println("Linear at " + (int)myVGuns.lPredictedAngle + " hit at " + (int)angleOffset);
					out.println("Laser at " + (int)myVGuns.laPredictedAngle + " hit at " + (int)angleOffset);
					out.println("Pattern at " + (int)myVGuns.pmPredictedAngle + " hit at " + (int)angleOffset);
					out.println("GF at " + (int)myVGuns.gfPredictedAngle + " hit at " + (int)angleOffset);
				}
			}
			//if (getEnergy() < 20 && iHit * 100 < 8 && e.getEnergy() > 30) {
			//} else {
				if (e.getDistance() < 100) {
					fireHeadOn(e);
					power = 3;
					fireMethod = new Integer(3);
				} else {
					if (bulletsFired < 30) {
						chooseRandom(e);
					} else {
						if (roundFired > 0) {
							//if (iHit * 100 < 5) {
							//	chooseRandom(e);
							//} else {
								chooseOnMerit(e);
							//}
						} else {
							chooseOnMerit(e);
						}
					}
				}
				
				if (getGunHeat() <= 0) {
					// energy management
					if (getEnergy() <= power) {
						if (getEnergy() == .1) {
						} else {
							//myVGuns.addBullet(getX(), getY(), absBearing, power, eDirection, getTime(), e.getHeadingRadians(), lastEnemyHeading, e.getVelocity(), honprednow, linprednow, circprednow, lasprednow, pmprednow);
							power = getEnergy() - .1;
							bulletsFired++;
							roundFired++;
							setFire(power);
						}
					} else if (getEnergy() > 16 && getEnergy() - 3 < 16 && power == 1.99) {
						//myVGuns.addBullet(getX(), getY(), absBearing, power, eDirection, getTime(), e.getHeadingRadians(), lastEnemyHeading, e.getVelocity(), honprednow, linprednow, circprednow, lasprednow, pmprednow);
						power = 1;
						bulletsFired++;
						roundFired++;
						setFire(power);
					} else {
						//myVGuns.addBullet(getX(), getY(), absBearing, power, eDirection, getTime(), e.getHeadingRadians(), lastEnemyHeading, e.getVelocity(), honprednow, linprednow, circprednow, lasprednow, pmprednow);
						bulletsFired++;
						roundFired++;
						setFire(power);
					}
				}
				lastEnemyHeading=e.getHeadingRadians();
				plastEnemyHeading=e.getHeadingRadians();
			//}
		}
	}

	public void onBulletHit(BulletHitEvent event) {
		/*Integer bulletTypeObj = (Integer)myBullets.lastElement();
		int bulletType = bulletTypeObj.intValue();
		if (bulletType == 0) {
			hitLinear++;
		} else if (bulletType == 1) {
			hitHeadOn++;
		} else if (bulletType == 2) {
			hitCircular++;
		}
		hits++;
		myBullets.removeElement(myBullets.lastElement());*/
		
		hits++;
	}
	
	public void onBulletMissed(BulletMissedEvent event) {
		//myBullets.removeElement(myBullets.lastElement());
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent event) {
		//myBullets.removeElement(myBullets.lastElement());
	}
	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		gotHit++;
		if (musashi == true && Math.abs(eDist / e.getVelocity()) < Math.abs(timeOfLastDirChange - getTime())) {
			out.println("Hit by non-HOT bullet!");
			musashi = false;
		}
	}
	
	public void onRobotDeath(RobotDeathEvent e) {
		if (e.getName().equals(Tracking)) {
			Tracking = "";
		}
	}
	
    private void goTo(Point2D point) {
		Point2D location = new Point2D.Double(getX(), getY());
        double distance = location.distance(point);
        double angle = normalRelativeAngle(absBearing(location, point) - getHeading());
        if (Math.abs(angle) > 90.0) {
            distance *= -1.0;
            if (angle > 0.0) {
                angle -= 180.0;
            }
            else {
                angle += 180.0;
            }
        }
        setTurnRight(angle);
        setAhead(distance);
    }

	private void translateInsideField(Point2D point, double margin) {
        double X = Math.max(margin, Math.min(fieldRectangle.getWidth() - margin, point.getX()));
        double Y = Math.max(margin, Math.min(fieldRectangle.getHeight() - margin, point.getY()));
        point.setLocation(X, Y);
    }

	private double absBearing(Point2D source, Point2D target) {
        return Math.toDegrees(Math.atan2(target.getX() - source.getX(), target.getY() - source.getY()));
    }

    private double normalRelativeAngle(double angle) {
        double relativeAngle = angle % 360;
        if (relativeAngle <= -180)
            return 180 + (relativeAngle % 180);
        else if (relativeAngle > 180)
            return -180 + (relativeAngle % 180);
        else
            return relativeAngle;
    }

	public void doScanner() {
	    timeSinceLastScan++;
	    double radarOffset = Double.POSITIVE_INFINITY;
	    if(timeSinceLastScan < 3) {
	        radarOffset = robocode.util.Utils.normalRelativeAngle(getRadarHeadingRadians() - absBearing);
	        radarOffset += sign(radarOffset) * 0.02;
	    }
	    setTurnRadarLeftRadians(radarOffset);
	}

	int sign(double v) {
	    return v > 0 ? 1 : -1;
	}
	
	public void fireLinear(ScannedRobotEvent e, double absBearing, double enemyX, double enemyY) {
				double bulletPower = power;
				/*Math.min(3.0,getEnergy())*/
                double myX = getX();
                double myY = getY();
                double enemyHeading = e.getHeadingRadians();
                double enemyVelocity = e.getVelocity();
                
                
                double deltaTime = 0;
                double battleFieldHeight = getBattleFieldHeight(), battleFieldWidth = getBattleFieldWidth();
                double predictedX = enemyX, predictedY = enemyY;
                while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){          
                        predictedX += Math.sin(enemyHeading) * enemyVelocity;   
                        predictedY += Math.cos(enemyHeading) * enemyVelocity;
                        if(     predictedX < 18.0 
                                || predictedY < 18.0
                                || predictedX > battleFieldWidth - 18.0
                                || predictedY > battleFieldHeight - 18.0){
                                predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);     
                                predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
                                break;
                        }
                }
                double theta = robocode.util.Utils.normalAbsoluteAngle(Math.atan2(predictedX - getX(), predictedY - getY()));
                setTurnGunRightRadians(normalRelativeAngle(theta - getGunHeadingRadians()));
	}
	
	public void fireHeadOn(ScannedRobotEvent e) {
		double absBearing = getHeadingRadians() + e.getBearingRadians();
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absBearing - getGunHeadingRadians()));
	}
	
	public void fireCircular(ScannedRobotEvent e) {
				double w=e.getHeadingRadians()-plastEnemyHeading;
                plastEnemyHeading=e.getHeadingRadians();
                double absbearing=e.getBearingRadians()+getHeadingRadians();
                double eX=e.getDistance()*Math.sin(absbearing);
                double eY=e.getDistance()*Math.cos(absbearing);
				double speed = 20-power*3;
				/*(Math.min(3.0, e.getEnergy()/4))*/
                double db=0;
                double ww=lastEnemyHeading;
                do
                {
                        db+=speed;
                        double dx=e.getVelocity()*Math.sin(ww);
                        double dy=e.getVelocity()*Math.cos(ww);
                        ww+=w;
                        eX+=dx;
                        eY+=dy;
                }while (db< Point2D.distance(0,0,eX,eY));

                setTurnGunRightRadians(Math.asin(Math.sin(Math.atan2(eX, eY) - getGunHeadingRadians())));
	}
	
	public void fireLaser(ScannedRobotEvent e) {
		if (segmentHitOffsets.size() > 0) {
			if (getGunHeat() <= getGunCoolingRate()) {
				Double objFireAtOffset = (Double)segmentHitOffsets.get(gen.nextInt(segmentHitOffsets.size()));
				double fireAtOffset = objFireAtOffset.doubleValue();
				fireAtOffset *= eDirection;
				setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absBearing-getGunHeadingRadians()+fireAtOffset));
				//out.println("Would fire at: " + fireAtOffset);
			}
		} else {
			fireLinear(e, absBearing, enemyX, enemyY);
		}
	}
	
	public void firePattern(ScannedRobotEvent e) {
		setTurnGunRightRadians(Math.asin(Math.sin((paramOne - paramTwo) / e.getDistance() + absBearing - getGunHeadingRadians())));
	}
	
	public void fireGuessFactor() {
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absBearing-getGunHeadingRadians()+gfAngleOffset));
	}
	
	public void chooseOnMerit(ScannedRobotEvent e) {
		int fireType = myVGuns.returnBestGun();
		if (fireType == 1) {
			//out.println("Fired Linear.");
			fireLinear(e, absBearing, enemyX, enemyY);
			fireMethod = new Integer(0);
		} else if (fireType == 0) {
			//out.println("Fired Head On.");
			fireHeadOn(e);
			fireMethod = new Integer(1);
		} else if (fireType == 2) {
			//out.println("Fired Circular.");
			fireCircular(e);
			fireMethod = new Integer(2);
		} else if (fireType == 3) {
			//out.println("Fired Laser.");
			fireLaser(e);
			fireMethod = new Integer(3);
		} else if (fireType == 4) {
			//out.println("Fired Pattern Matching.");
			firePattern(e);
			fireMethod = new Integer(4);
		} else if (fireType == 5) {
			fireGuessFactor();
			fireMethod = new Integer(5);
		}
		//out.println("Best value: " + fireType);
	}
	
	public void chooseRandom(ScannedRobotEvent e) {
				int fireType = gen.nextInt(3);
				if (fireType == 0) {
					fireLinear(e, absBearing, enemyX, enemyY);
					fireMethod = new Integer(0);
				} else if (fireType == 1) {
					fireHeadOn(e);
					fireMethod = new Integer(1);
				} else {
					fireCircular(e);
					fireMethod = new Integer(2);
				}
	}
	
	public void onHitWall(HitWallEvent e) {
		direction *= -1;
		timeOfLastDirChange = getTime();
	}
	
	/*public void onWin(WinEvent evt) {
		out.println("Shots fired: " + roundFired);
		out.println("Shots hit: " + hits);
		double fireDec = (double)hits/(double)roundFired;
		out.println("Percentage hits: " + (fireDec * 100));
		out.println("Hits overall - Linear: " + hitLinear + " Head On: " + hitHeadOn + " Circular: " + hitCircular);
		out.println("Enemy fired: " + eRoundFired + " times.");
		out.println("Hit by a bullet: " + gotHit + " times.");
		out.println("Dodged: " + (eRoundFired-gotHit) + " bullets.");
		double hitDec = (double)gotHit/(double)eRoundFired;
		out.println("I was hit " + (hitDec * 100) + " percent of the time.");
	}
	
	public void onDeath() {
		out.println("Shots fired: " + roundFired);
		out.println("Shots hit: " + hits);
		out.println("Percentage hits: " + ((hits/roundFired) * 100));
		out.println("Hits overall - Linear: " + hitLinear + " Head On: " + hitHeadOn + " Circular: " + hitCircular);
		out.println("Enemy fired: " + eRoundFired + " times.");
		out.println("Hit by a bullet: " + gotHit + " times.");
		out.println("Dodged: " + (eRoundFired-gotHit) + " bullets.");
		out.println("I was hit " + ((gotHit/eRoundFired) * 100) + " percent of the time.");
	}*/
	public void onPaint(java.awt.Graphics2D g) {
		//if (tB != null) {
		
			g.setColor(Color.green);
			g.drawOval((int)(getX() + eDist * Math.sin(Math.toRadians(gfprednow))) +22, 600- (int)(getY() + eDist * Math.cos(Math.toRadians(gfprednow))) +22, 10,10);
			g.setColor(Color.red);
			g.drawOval((int)(getX() + eDist * Math.sin(Math.toRadians(linprednow))) +23, 600- (int)(getY() + eDist * Math.cos(Math.toRadians(linprednow))) +23, 10,10);
			g.setColor(Color.blue);
			g.drawOval((int)(getX() + eDist * Math.sin(Math.toRadians(circprednow))) +24, 600- (int)(getY() + eDist * Math.cos(Math.toRadians(circprednow))) +24, 10,10);
			g.setColor(Color.gray);
			g.drawOval((int)(getX() + eDist * Math.sin(Math.toRadians(lasprednow))) +24, 600- (int)(getY() + eDist * Math.cos(Math.toRadians(lasprednow))) +24, 10,10);
			g.setColor(Color.orange);
			g.drawOval((int)(getX() + eDist * Math.sin(Math.toRadians(pmprednow))) +22, 600- (int)(getY() + eDist * Math.cos(Math.toRadians(pmprednow))) +22, 10,10);
		//}
		g.setColor(Color.white);
		double gunHeadX = getX() + eDist * Math.sin(getGunHeadingRadians());
		double gunHeadY = getY() + eDist * Math.cos(getGunHeadingRadians());
		g.drawOval((int)(gunHeadX + 21),(int)(600- gunHeadY + 21), 10,10);
	}
	
	public double returnLinear(ScannedRobotEvent e, double absBearing, double enemyX, double enemyY) {
				double bulletPower = power;
                double myX = getX();
                double myY = getY();
                double enemyHeading = e.getHeadingRadians();
                double enemyVelocity = e.getVelocity();
                
                
                double deltaTime = 0;
                double battleFieldHeight = getBattleFieldHeight(), battleFieldWidth = getBattleFieldWidth();
                double predictedX = enemyX, predictedY = enemyY;
                while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){          
                        predictedX += Math.sin(enemyHeading) * enemyVelocity;   
                        predictedY += Math.cos(enemyHeading) * enemyVelocity;
                        if(     predictedX < 18.0 
                                || predictedY < 18.0
                                || predictedX > battleFieldWidth - 18.0
                                || predictedY > battleFieldHeight - 18.0){
                                predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);     
                                predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
                                break;
                        }
                }
                double theta = robocode.util.Utils.normalAbsoluteAngle(Math.atan2(predictedX - getX(), predictedY - getY()));
                return Math.toDegrees(robocode.util.Utils.normalRelativeAngle(theta));
	}
	
	public double returnHeadOn(ScannedRobotEvent e) {
		double absBearing = getHeadingRadians() + e.getBearingRadians();
		return Math.toDegrees(robocode.util.Utils.normalRelativeAngle(absBearing));
	}
	
	public double returnCircular(ScannedRobotEvent e) {
		double w=e.getHeadingRadians()-lastEnemyHeading;
        lastEnemyHeading=e.getHeadingRadians();
        double absbearing=e.getBearingRadians()+getHeadingRadians();
        double eX=e.getDistance()*Math.sin(absbearing);
        double eY=e.getDistance()*Math.cos(absbearing);
		double speed = 20-power*3;
        double db=0;
        double ww=lastEnemyHeading;
        do
        {
            db+=speed;
            double dx=e.getVelocity()*Math.sin(ww);
            double dy=e.getVelocity()*Math.cos(ww);
            ww+=w;
            eX+=dx;
            eY+=dy;
        }while (db< Point2D.distance(0,0,eX,eY));
        if (getY() > enemyY) {
			if (getX() > enemyX) {
            	return Math.toDegrees(Math.acos(Math.cos(Math.atan2(eX, eY)))) * -1;
			} else {
				return Math.toDegrees(Math.acos(Math.cos(Math.atan2(eX, eY))));
			}
		} else {
			return Math.toDegrees(Math.asin(Math.sin(Math.atan2(eX, eY))));
		}
	}
	
	public double returnLaser(ScannedRobotEvent e) {
		if (segmentHitOffsets != null) {
			if (segmentHitOffsets.size() > 0) {
				Double objFireAtOffset = (Double)segmentHitOffsets.get(gen.nextInt(segmentHitOffsets.size()));
				double fireAtOffset = objFireAtOffset.doubleValue();
				fireAtOffset *= eDirection;
				return Math.toDegrees(robocode.util.Utils.normalRelativeAngle(absBearing+fireAtOffset));
				//out.println("Would fire at: " + fireAtOffset);
			} else {
				return returnHeadOn(e);
			}
		} else {
			return returnHeadOn(e);
		}
	}
		
	public double returnPattern(ScannedRobotEvent e, double power) {
		double pmprednow = 0;
		if (getY() < enemyY) {
			pmprednow = Math.toDegrees(Math.asin(Math.sin((paramOne - paramTwo) / eDist + absBearing)));
		} else {
			if (getX() > enemyX) {
				pmprednow = Math.toDegrees(Math.acos(Math.cos((paramOne - paramTwo) / eDist + absBearing)) * -1);
			} else {
				pmprednow = Math.toDegrees(Math.acos(Math.cos((paramOne - paramTwo) / eDist + absBearing)));
			}
		}

		if (Math.abs(pmprednow - Math.toDegrees(robocode.util.Utils.normalRelativeAngle(absBearing))) > Math.toDegrees(Math.asin(8 / (20 - 3 * power)))) {
			return returnLinear(e, absBearing, enemyX, enemyY);
		} else {
			return pmprednow;
		}
	}
	
	public double returnGuessFactor() {
		return(Math.toDegrees(robocode.util.Utils.normalRelativeAngle(absBearing+gfAngleOffset)));
	}
	
	public void updateLaserTargeting(ScannedRobotEvent e, double power) {
		//don't try to figure out the direction they're moving if they're not moving, just use the direction we had before
        if (e.getVelocity() != 0)
            if (Math.sin(e.getHeadingRadians()-absBearing)*e.getVelocity() < 0)
                 eDirection = -1;
            else
                 eDirection = 1;
		
		segmentHitOffsets = (Vector)allHitOffsets[(int)e.getDistance()/100];
		//out.println(segmentHitOffsets.toString());
		double headOnBearing = getHeadingRadians() + e.getBearingRadians();
		
		LaserBullet newBullet = new LaserBullet(getX(), getY(), headOnBearing, power, getTime(), eDirection, segmentHitOffsets);
		
		myBullets.add(newBullet);
		
		for (int i=0; i<myBullets.size(); i++) {
            LaserBullet currentWave = (LaserBullet)myBullets.get(i);

            if (currentWave.checkHit(enemyX, enemyY, getTime())) {
                myBullets.remove(currentWave);
                i--;
            }
        }
	}
	
	public void updatePMTargeting(ScannedRobotEvent e, double power) {
		// pattern matcher - idea (and a little bit of the code) from Moebius.
		Double relVel = new Double(e.getVelocity() * Math.sin(e.getHeadingRadians() + absBearing));
		lastFew.insertElementAt(relVel, 0);
		double reldblVel = relVel.doubleValue();
		Double temp = (Double)arcLength.get(historyIndex++);
		double prevArcLength = temp.doubleValue();
		arcLength.add(historyIndex, new Double(prevArcLength + reldblVel));
		if (lastFew.size() > MAX_SEARCHES) {
			lastFew.setSize(MAX_SEARCHES);
		}
		
		int index = -1;
		
		if (lastFew.size() < MAX_SEARCHES) {
		} else {
			int tries = 0;
			StringBuffer search = new StringBuffer();
			
			if(fullPattern.length() > 0) {
				while(index == -1) {
					if (tries < MAX_SEARCHES) {
						search.setLength(0);
						for (int i = 0; i < MAX_SEARCHES - tries; i++) {
							Double currentVal = (Double)lastFew.get(i);
							double doubVal = currentVal.doubleValue();
							search.append((char)doubVal);
						}
						index = fullPattern.lastIndexOf(search.toString());
					} else {
						break;
					}
					tries++;
				}
			}
			if (index != -1) {
				index += MAX_SEARCHES - (tries - 1);
				int timeToHit = (int)Math.abs(e.getDistance()/(20 - 3 * power));
				//timeToHit += 2;
				if (index + timeToHit >= arcLength.size()) {
					index += arcLength.size() - index - timeToHit - 1;
				}
				Double convert = (Double)arcLength.get(index + timeToHit);
				paramOne = convert.doubleValue();
				convert = (Double)arcLength.get(index);
				paramTwo = convert.doubleValue();
			}

			//out.println(index + " with " + (tries - 1) + " searches.");
		}
		//out.println(reldblVel);
		fullPattern.append((char)reldblVel);
		
		// clean up if too large
		if (historyIndex == MAX_BUFFER_SIZE - 1) {
			fullPattern.delete(0, 1);
			arcLength.removeElementAt(0);
			historyIndex = MAX_BUFFER_SIZE - 2;
		} else {
			arcLength.removeElementAt(arcLength.size() - 1);
		}
		//out.println(lastFew.toString());	}
	}
	
	public void updateGFTargeting(ScannedRobotEvent e) {
		//process waves
                for (int i=0; i<waves.size(); i++)
                {
                        WaveBullet currentWave = (WaveBullet)waves.get(i);
                        if (currentWave.checkHit(enemyX, enemyY, getTime()))
                        {
								//out.println("The Index Is: " + currentWave.index);
                                waves.remove(currentWave);
                                i--;
								wavesHit++;
                        }
                }
                
                
                int[] currentStats = stats[(int)(e.getDistance()/100)];
                WaveBullet newWave = new WaveBullet(getX(), getY(), absBearing, power, eDirection, getTime(), currentStats);
				
				int bestindex = 15;     //initialize it to be in the middle, guessfactor 0.
                for (int i=0; i<31; i++) {
						//out.println("I= " + i + "Its Value: " + currentStats[i]);
                        if (currentStats[bestindex] < currentStats[i]) {
                                bestindex = i;
						}
				}
				
				//out.println("E Velocity: " + e.getVelocity());

				if (wavesHit < 50 || e.getVelocity() == 0 || e.getDistance() < 100) {
                	bestindex = 15;
				}

                //this should do the opposite of the math in the WaveBullet:
                double guessfactor = (double)(bestindex-(currentStats.length-1)/2)/((currentStats.length-1)/2);
				gfAngleOffset = eDirection*guessfactor*newWave.maxEscapeAngle();
				//out.println("angleOffset = " + (int)gfAngleOffset);
				
               	waves.add(newWave);
	}
	
	public void moveMusashi() {
		double goalDirection = absBearing-Math.PI/2*direction;
		Rectangle2D fieldRect = new Rectangle2D.Double(18, 18, getBattleFieldWidth()-36, getBattleFieldHeight()-36);
				if (!fieldRect.contains(getX()+Math.sin(goalDirection)*40, getY()+Math.cos(goalDirection)*40)) {
					if (nearwall == false) {
        				direction *= -1;
						timeOfLastDirChange = getTime();
        				nearwall = true;
						//out.println("Near wall");
    				}
    				else {
       					//out.println("Still near wall");
    				}
				} else {
					nearwall = false;
				}
				
		moveWithBackAsFront(100 * direction, Math.toRadians(Math.toDegrees(absBearing) - 90));
	}
	
	public void moveDodging() {
		if (nearwall == false) {
			if (gen.nextInt(10) == 1) {
				direction *= -1;
				timeOfLastDirChange = getTime();
				//out.println("Changing direction randomly");
			}
		}
		
		/*if (changeWait == 0) {
			changeWait = gen.nextInt(15) + 5;
			int wantedVel = gen.nextInt(8) + 4;
			setMaxVelocity(wantedVel);
		} else {
			changeWait--;
		}*/
		
		if (eGunHeat < 2*coolRate && eRoundFired > 1 && eGunHeat >= coolRate) {
			setAhead(10 * direction);
		}
		
		if (allBullets.isEmpty() == false) {
			for (int i = 0; i < allBullets.size(); i++) {
				EBullet currBullet = (EBullet)allBullets.elementAt(i);
				double distRemaining = currBullet.update();
				if (Math.abs(distRemaining) < 100) {
					if (Math.abs(timeOfLastDirChange - getTime()) >= eDist / currBullet.velocity) {
						direction *= -1;
						timeOfLastDirChange = getTime();
					}
					//out.println("Bullet close at " + distRemaining);
					//setTurnLeft(90 - normalRelativeAngle(absBearing(currBullet.getStartCoords(), currBullet.getTargetCoords())));
					double goalDirection = absBearing-Math.PI/2*direction;
					Rectangle2D fieldRect = new Rectangle2D.Double(18, 18, getBattleFieldWidth()-36, getBattleFieldHeight()-36);
					if (!fieldRect.contains(getX()+Math.sin(goalDirection)*120, getY()+Math.cos(goalDirection)*120)) {
						Rectangle2D eFieldRect = new Rectangle2D.Double(150, 150, getBattleFieldWidth() - 300, getBattleFieldHeight() - 300);
						// check if enemy is near wall
						if (!eFieldRect.contains(enemyX, enemyY)) {
							if (!fieldRect.contains(getX()+Math.sin(goalDirection)*40, getY()+Math.cos(goalDirection)*40)) {
								if (nearwall == false) {
        							direction *= -1;
									timeOfLastDirChange = getTime();
        							nearwall = true;
									//out.println("Near wall");
    							}
    							else {
       								//out.println("Still near wall");
    							}
							} else {
								nearwall = false;
							}
						} else {
							adjustForWall = true;
							//while (!fieldRect.contains(getX()+Math.sin(goalDirection)*120, getY()+Math.cos(goalDirection)*120)) {
        					//	goalDirection += direction*.1;  //turn a little toward my enemy and try again
							//}
						}
					} else {
						adjustForWall = false;
						nearwall = false;
					}
					double turn = robocode.util.Utils.normalRelativeAngle(goalDirection-getHeadingRadians());
					if (Math.abs(turn) > Math.PI/2) {
        				turn = robocode.util.Utils.normalRelativeAngle(turn + Math.PI);
        				//if (Math.abs(getDistanceRemaining()) < 10) {
							setBack(gen.nextInt(100) + 50);
						//}
					} else {
						//if (Math.abs(getDistanceRemaining()) < 10) {
							setAhead(gen.nextInt(100) + 50);
						//}
					}
		
					Rectangle2D.Double llCorner = new Rectangle2D.Double(0, 0, 150, 150);
					Rectangle2D.Double lrCorner = new Rectangle2D.Double(getBattleFieldWidth() - 150, 0, getBattleFieldWidth(), 150);
					Rectangle2D.Double ulCorner = new Rectangle2D.Double(0, getBattleFieldHeight() - 150, 150, getBattleFieldHeight());
					Rectangle2D.Double urCorner = new Rectangle2D.Double(getBattleFieldWidth() - 150, getBattleFieldHeight() - 150, getBattleFieldWidth(), getBattleFieldHeight());
		
					if ((llCorner.contains(getX(), getY()) && !llCorner.contains(enemyX, enemyY))
						|| (lrCorner.contains(getX(), getY()) && !lrCorner.contains(enemyX, enemyY))
						|| (ulCorner.contains(getX(), getY()) && !ulCorner.contains(enemyX, enemyY))
						|| (urCorner.contains(getX(), getY()) && !urCorner.contains(enemyX, enemyY))) {
						setTurnRight(Math.toDegrees(turn) + 20 * direction);
					} else {
						if (adjustForWall == true) {
							setTurnRightRadians(turn);
						} else {
							/*if (eDist < bestDistBin * (1400/(DISTBINS-1))) {
								setTurnRight(Math.toDegrees(turn) - (20 * direction));
							} else if (eDist > (bestDistBin * (1400/(DISTBINS-1))) + (1400/(DISTBINS-1))) {
								setTurnRight(Math.toDegrees(turn) + (20 * direction));
							} else {*/
								//out.println("At good distance: " + "eDist " + eDist + " is between " + (bestDistBin * (1400/(DISTBINS-1))) + " and " + ((bestDistBin * (1400/(DISTBINS-1))) + (1400/(DISTBINS-1))));
								setTurnRightRadians(turn);
							//}
						}
					}
				}
			}
		}
		//setTurnLeft(90 - eBearing);
		
		/**/
	}
	
	void moveWithBackAsFront(double distance, double bearing) {
        double angle = robocode.util.Utils.normalRelativeAngle(bearing - getHeadingRadians());
        double turnAngle = Math.atan(Math.tan(angle));
        setTurnRightRadians(turnAngle);
        int direction = angle == turnAngle ? 1 : -1;
        setAhead(distance * direction);
    }
}