package tm;

import java.util.*;

/********************************************************************
* EnemyHistory3.java -- Gʒu̗pOobt@
*
* Date:		2002/Nov/10
* Author:	Matunaga Takateru@RISE, Eng, Kagawa Univ.
*
********************************************************************/
public class EnemyHistory3 {
	Point[] po;
	double[] heading;			//Gis
	double[] distance;
	double[] absoluteBearing;		//猩G̐Ε
	long[] time;
	int startIndex = -1;
	int endIndex = -1;
	double maxAngle, minAngle;
	int maxIndex, minIndex;
	int size;
	int dataSize = 0;			//ۂ̃f[^
	
	//------------------------------------------------------------------
	// constructor
	//
	//
	//------------------------------------------------------------------
	public EnemyHistory3(int n) {
		po = new Point[n];
		heading = new double[n];
		distance = new double[n];
		time = new long[n];
		absoluteBearing = new double[n];
		size = n;
	}

	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	void put(double x, double y, double distance, double velocity, double heading, double bearing, long t) {
		dataSize++;
		if (dataSize > size) dataSize = size;
			
		if (startIndex == -1 && endIndex == -1) {
			startIndex = endIndex = 0;
		} else {
			endIndex = (endIndex+1) % size;
			if (endIndex == startIndex) {
				startIndex = (startIndex+1) % size;
			}
		}
			
		
		this.po[endIndex] = new Point(x, y);
		this.distance[endIndex] = distance;
		this.time[endIndex] = t;
		this.absoluteBearing[endIndex] = bearing;
		if (velocity >= 0) {
			this.heading[endIndex] = heading;
		} else {
			this.heading[endIndex] = (heading + 180) % 360;		
		}
	}
}