/*
 * Created on Nov 30, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package dans;

import java.awt.geom.*;


/**
 * @author Danny
 *
 * Enemy.java
 * Created on Nov 30, 2003
 * 
 */
public class Enemy {
	String name="";
	Point2D position= new Point2D.Double();
	double lastScan=0;
	double scans=0;
	double dist=Double.POSITIVE_INFINITY;
	double bearing=0;
	double lastBearing=0;
	double heading=0;
	double velocity= 0;
	double energy=100;
	double headingChange=0;
	double avVelocity=0;
	static int count;
	static double veloArray[] = new double[50000];
	static StringBuffer pattern = new StringBuffer();
	
	/**Basic Enemy Constructor, Creates an Enemy with no paramaters*/
	public Enemy() {	
	}
	/**Enemy Constructor, Fills in all data*/
	public Enemy(double yourX,double yourY,Point2D enemyLoc, String newName,double time, double itsHeading, double itsEnergy, double itsVelocity){
		this.position.setLocation(enemyLoc);
		this.name=newName;
		this.lastScan=time;
		this.velocity=itsVelocity;
		this.dist=RobocodeUtils.dist(yourX,yourY,enemyLoc.getX(),enemyLoc.getY());
		this.bearing=RobocodeUtils.getBearing(yourX,yourY,enemyLoc.getX(),enemyLoc.getY());
		this.heading=itsHeading;
		this.energy=itsEnergy;
		this.avVelocity=itsVelocity;
		
	}
	/**Updates the Enemy with New Data, Averages the Average Speed, Sets lastBearing, headingChange*/
	public void update(double yourX, double yourY,Point2D enemyLoc, double time, double itsHeading,double itsEnergy, double itsVelocity,double yourHeading){
		this.position.setLocation(enemyLoc);
		this.lastScan=time;
		this.scans++;
		this.dist=RobocodeUtils.dist(yourX,yourY,enemyLoc.getX(),enemyLoc.getY());
		this.lastBearing=bearing;
		this.bearing=RobocodeUtils.getBearing(yourX,yourY,enemyLoc.getX(),enemyLoc.getY());
		this.headingChange=itsHeading-this.heading;
		this.heading=itsHeading;
		this.energy=itsEnergy;
		this.avVelocity=RobocodeUtils.rollingAvg(velocity,itsVelocity,scans,100);
		this.velocity+=itsVelocity;
		double targetBearing = Math.toRadians(bearing) + Math.toRadians(yourHeading);
		int pointer;
		if(count!=49999){
		veloArray[++count] = veloArray[count-1] + (pointer = (int) (itsVelocity*Math.sin(Math.toRadians(itsHeading)-targetBearing)));
		pattern.append((char)pointer);
		}
		else{
			count=0;
			veloArray[count] = veloArray[49999] + (pointer = (int) (itsVelocity*Math.sin(Math.toRadians(itsHeading)-targetBearing)));
			pattern.append((char)pointer);
		}
	}
	public void setTo(Enemy a){
		this=a;
	}
	
	
	/**
	 * Returns the Enemys bearing.
	 * @return double
	 */
	public double getBearing() {
		return bearing;
	}

	/**
	 * Returns the distance to the Enemy.
	 * @return double
	 */
	public double getDistance() {
		return dist;
	}

	/**
	 * Returns the Enemys energy.
	 * @return double
	 */
	public double getEnergy() {
		return energy;
	}

	/**
	 * Returns the Enemys heading.
	 * @return double
	 */
	public double getHeading() {
		return heading;
	}

	/**
	 * Returns the Enemy's Change in heading.
	 * @return double
	 */
	public double getHeadingChange() {
		return headingChange;
	}
	/**
	 * Returns the the last time you scanned the target.
	 * @return long
	 */
	public double getLastScan() {
		return lastScan;
	}

	/**
	 * Returns the Enemys Name.
	 * @return String
	 */
	public String getName() {
		return name;
	}
	/**
	 * Returns the Enemys Velocity.
	 * @return double
	 */
	public double getVelocity() {
		return velocity;
	}
	/**
	 * Returns the Enemy's Average Velocity.
	 * @return double
	 */
	public double getAverageVelocity() {
		return Math.round(avVelocity);
	}
	/**
	 * Returns the Enemy's Position on the x axis.
	 * @return double
	 */
	public double getX() {
		return position.getX();
	}
	/**
	 * Returns the Enemy's Position on the Y axis.
	 * @return double
	 */
	public double getY() {
		return position.getY();
	}
	/**Tells you if the the Object Passed is a Enemy object*/ 	
	public boolean equals(Object o) {
		if (o instanceof Enemy) {
			Enemy t = (Enemy) o;
			return t.getName().equals(getName());
		}
		return false;
	}
	public double getScans(){
		return this.scans;
	}
	public int getCount(){
		return this.count;
	}
	public double[] getVeloArray(){
		return this.veloArray;
	}
	public StringBuffer getPattern(){
		return this.pattern;
	}
}
