package simonton.micro;

import java.awt.*;
import java.awt.geom.*;
import java.util.*;

import robocode.*;
import robocode.util.*;

/**
 */
public class Sprout extends AdvancedRobot {

	private static final int WALL_MARGIN = 23;
	private static final int BATTLEFIELD_WIDTH = 1000;
	private static final int BATTLEFIELD_HEIGHT = 1000;
	private static final int MAX_MATCH_LEN = 30;

	static Point2D.Double myLoc;
	static HashMap theDead = new HashMap();
	static HashMap enemyIntelligence = new HashMap();

	public void run() {

		int r2i;
		int r3i;
		double r4d;

		int myX;
		int myY;

		int side;
		int hangTime;
		int matchLen; // use r2i
		int matchPos; // use r3d
		double a;
		double distance; // use r4d
		double firePower;
		Intelligence enemy;
		String enemyHistory;

		int goX; // use r2i
		int goY; // use r3i

		enemyIntelligence.putAll(theDead);
		theDead.clear();

		setAdjustGunForRobotTurn(true);
		setTurnRadarRightRadians(Double.POSITIVE_INFINITY);

		side = 1;
		do {
			myLoc = new Point2D.Double(myX = (int) getX(), myY = (int) getY());
			r4d = 0;
			try {
				enemyHistory = (enemy = currentEnemy()).history;

				// fire
				r4d = myLoc.distance(enemy);
				firePower =
				// Math.min(3, Math.min(
					// 200.0 / getOthers() * r4d,
					// enemy.energy / 4));
					Math.min(3, 30 * getOthers() * getEnergy() / r4d);
				if (getEnergy() > 3) {
					setFire(firePower);
				}

				// aim
				r2i = MAX_MATCH_LEN;
				while ((r3i =
					enemyHistory
						.indexOf(
							enemyHistory.substring(0, r2i--),
							hangTime =
								(int) (r4d / (20 - 3 * firePower) + getTime() - enemy.lastScan))) < 0)
					;
				a = angle(myLoc, enemy);
				double maybeA;
				// DEBUG
//				playAngles.clear();
				do {
					maybeA = a + (short) enemyHistory.charAt(--r3i) / r4d;
					if (isOut(r4d, maybeA) == 0) {
						a = maybeA;
						// DEBUG
//						playAngles.add(a);
					}
				} while (--hangTime > 0);
				setTurnGunRightRadians(Utils.normalRelativeAngle(a
					- getGunHeadingRadians()));

			} catch (Exception ex) {
				// no enemies to aim at yet,
				// or we just changed rounds & elapsed time is negative
				// ex.printStackTrace();
			}

			// move
			r2i = WALL_MARGIN + (int) r4d / 3;
			r3i = WALL_MARGIN;

			if (getDistanceRemaining() == 0) {
				side = -side;
			}
			if (side > 0) {
				r3i = r2i;
				r2i = WALL_MARGIN;
			}

			// translate our destination to the nearest corner
			if (myX > BATTLEFIELD_WIDTH / 2) {
				r2i = BATTLEFIELD_WIDTH - r2i;
			}
			if (myY > BATTLEFIELD_HEIGHT / 2) {
				r3i = BATTLEFIELD_HEIGHT - r3i;
			}

			// goto code this small is thanks to a trick inspired by ChaseSan
			setTurnRightRadians(Math.tan(r4d =
				Math.atan2(r2i = r2i - myX, r3i = r3i - myY)
					- getHeadingRadians()));
			setAhead(Math.cos(r4d) * Math.hypot(r2i, r3i));

			execute();
		} while (true);
	}

	public void onScannedRobot(ScannedRobotEvent r2e) {

		Intelligence r3enemy;
		Point2D.Double r4newLoc;
		int elapsed;
		double latV;

		r3enemy = (Intelligence) enemyIntelligence.get(r2e.getName());
		r4newLoc =
			project(myLoc, getHeadingRadians() + r2e.getBearingRadians(), r2e
				.getDistance());
		try {
			latV =
				r3enemy.distance(r4newLoc)
					* Math
						.sin(angle(r3enemy, r4newLoc) - angle(myLoc, r3enemy))
					/ (elapsed = (int) (getTime() - r3enemy.lastScan));
			// DEBUG
//			scannedLatv = latV;
			do {
				r3enemy.history =
					String.valueOf((char) latV).concat(r3enemy.history);
			} while (--elapsed > 0);

			if (/*
				 * getOthers() == 1 ||
				 */getGunHeat() < .8 && r3enemy == currentEnemy()) {
				setTurnRadarLeft(getRadarTurnRemaining());
			}
		} catch (NullPointerException ex) {
			r3enemy = new Intelligence();
			enemyIntelligence.put(r2e.getName(), r3enemy);
		}
		r3enemy.setLocation(r4newLoc);
		r3enemy.lastScan = getTime();
		r3enemy.energy = r2e.getEnergy();
	}

	public void onRobotDeath(RobotDeathEvent e) {

		String name = e.getName();
		theDead.put(name, enemyIntelligence.remove(name));
	}

	private static Intelligence currentEnemy() {

		return (Intelligence) Collections.min(enemyIntelligence.values());
	}

	private int isOut(double distance, double angle) {

		// return !new Rectangle2D.Double(
		// WALL_MARGIN,
		// WALL_MARGIN,
		// BATTLEFIELD_WIDTH - 2 * WALL_MARGIN,
		// BATTLEFIELD_HEIGHT - 2 * WALL_MARGIN)
		// .contains(//project(distance, angle));
		// getX() + distance * Math.sin(angle),
		// getY() + distance * Math.cos(angle));
		try {
			return xOutTable
				.charAt(((int) (getX() + distance * Math.sin(angle))))
				| yOutTable
					.charAt(((int) (getY() + distance * Math.cos(angle))));
		} catch (StringIndexOutOfBoundsException ex) {
			return 1;
		}
	}

	private static Point2D.Double project(Point2D.Double p, double a, double d) {

		return new Point2D.Double(p.x + d * Math.sin(a), p.y + d * Math.cos(a));
	}

	private static double angle(Point2D.Double p1, Point2D.Double p2) {

		return Math.atan2(p2.x - p1.x, p2.y - p1.y);
	}

	static class Intelligence extends Point2D.Double implements Comparable {

		public String history;
		public long lastScan;
		public double energy;

		public Intelligence() {

			history = hotPrime;
		}

		public int compareTo(Object o) {

			return java.lang.Double.compare(distance(myLoc), ((Point2D) o)
				.distance(myLoc));
		}
	}

//	// DEBUG
//
//	public void onSkippedTurn(SkippedTurnEvent arg0) {
//
//		System.out.println(getTime() + " Skipped turn!");
//	}
//
//	static double scannedLatv;
//	static Collection<Double> playAngles = new ArrayList<Double>();
//
//	public void onPaint(Graphics2D g) {
//
//		g.setColor(Color.GREEN);
//		int x = (int) getX() + 25;
//		int y = (int) getY() - 6;
//		g.drawString("" + playAngles.size(), x, y - 6);
//		g.drawString("" + scannedLatv, x, y + 6);
//
//		try {
//			double distance = myLoc.distance(currentEnemy());
//			for (Double playAngle : playAngles) {
//				x = (int) (myLoc.x + distance * Math.sin(playAngle));
//				y = (int) (myLoc.y + distance * Math.cos(playAngle));
//				g.fillOval(x - 1, y - 1, 3, 3);
//			}
//		} catch (Throwable e) {
//			e.printStackTrace();
//		}
//	}

	private static final String xOutTable =
		"\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1";

	private static final String yOutTable =
		"\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1";

	// prime the pattern matcher with head-on targeting
	private static final String hotPrime =
		"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\177770\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\177771\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\177772\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\177773\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\177774\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\177775\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\177776\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\177777\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\5\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\10";
}
