package theo.real;
import robocode.*;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;
import java.awt.Graphics2D;
import robocode.*;
import robocode.util.Utils;
import theo.real.gun.*;
import theo.real.surf.*;
import theo.real.enemy.*;
import theo.real.utils.*;

public class Ahab extends TeamRobot
{
	
	static SurfHandler surf;
	static GunHandler gun;
	static Enemy enemy;
	
	public static Rectangle2D.Double playField;
	
	public static Point2D.Double pos;
	
	public static double heading;
	public static double lastHeading;
	public static double velocity;
	public static double lastVelocity;
	public static double lastVelocity2;
	
	public static int latDirection;
	public static int lastLatDirection;
	
	public static double wins, winRate;
	
	public static boolean isMC = false;
	public static boolean isTC = false;
	
	static {
		pos = new Point2D.Double();
		lastLatDirection = latDirection;
	}


	public void run() {
	
		enemy = new Enemy();
		
		if (surf==null){
			surf = new SurfHandler(this, enemy);
		}
		if (gun==null){
			gun = new GunHandler(this, enemy);
		}

		Color orchid1 = new Color(255,131,250);
		Color deepSkyBlue = new Color(0,191,255);
		Color springGreen = new Color(0,255,127);
		Color boatBrown = new Color(139,69,19);
		Color eggWhite = new Color(255,245,195);
		super.setColors(boatBrown,eggWhite,deepSkyBlue);//,orchid1);
		
		super.setAdjustGunForRobotTurn(true);
		super.setAdjustRadarForGunTurn(true);
		super.setAdjustRadarForRobotTurn(true);
		
		playField = new Rectangle2D.Double(20,20,super.getBattleFieldWidth()-40,super.getBattleFieldHeight()-40);
		
		while(true) { turnRadarRightRadians(Double.POSITIVE_INFINITY); }
		
	}
	
	public void update(ScannedRobotEvent e){
		pos.x = this.getX();
		pos.y = this.getY();
		
		this.doRadar(e);
		
		this.velocity = getVelocity();
		
		if(this.velocity!=0){
			this.latDirection = (this.velocity*Enemy.bearing<0?-1:1);
			//this.lastLatDirection = this.latDirection;
		}
		else{
			//this.lastLatDirection = (enemy.bearing<0?-1:1);
			this.latDirection = this.lastLatDirection;
		}
		
		
		/*WaveTheory.latDirection = 
			(enemy.bearing<0?-1:1);*/
	/*	if(this.velocity!=0){
			this.lastVelocity = this.velocity;
		}
		else{
		}*/
		
		Enemy.distance = e.getDistance();
		Enemy.velocity = e.getVelocity();
		Enemy.energy = e.getEnergy();
		double absAngle = Utils.normalAbsoluteAngle(Enemy.absBearing);
		double oldAbsAngle = Utils.normalAbsoluteAngle(Enemy.lastAbsBearing);
		Enemy.absAngle = absAngle;
		Enemy.latHeading = Utils.normalRelativeAngle(Enemy.heading - Enemy.absBearing);
		Enemy.latVelocity = Enemy.velocity * Math.sin (
				Utils.normalAbsoluteAngle(Enemy.heading - Enemy.absBearing));
		
		Enemy.timeSinceDirChange ++;
		Enemy.deltaHeading = Utils.normalRelativeAngle(Enemy.heading - Enemy.lastHeading);

		if(Enemy.velocity != 0){
			//Enemy.latDirection = (Utils.normalRelativeAngle
			//						(absAngle-oldAbsAngle)>=0?1:-1);
			Enemy.latDirection = (Enemy.latVelocity<0?-1:1);
			if(Enemy.latDirection != Enemy.lastLatDirection){
				Enemy.timeSinceDirChange = 0;
			}
		}
		else {
			Enemy.latDirection = Enemy.lastLatDirection;
		}
		Enemy.lastLatDirection = Enemy.latDirection;
		Enemy.lastAbsBearing = Enemy.absBearing;

		Enemy.pos.x = Enemy.distance*Math.sin(Enemy.absBearing) + pos.x;
		Enemy.pos.y = Enemy.distance*Math.cos(Enemy.absBearing) + pos.y;
		
		Enemy.heading = e.getHeadingRadians();

		if(!isMC){
			surf.update(e);
		}
		if(!isTC){
			gun.update(e);
		}
		
		Enemy.lastVelocity = Enemy.velocity;
		Enemy.lastHeading = Enemy.heading;
		Enemy.lastEnergy = Enemy.energy;
		
		this.lastHeading = this.heading;
		
		this.lastVelocity2 = this.velocity;
		
		this.lastLatDirection = this.latDirection;
		
		execute();
	}
	
	void doRadar(ScannedRobotEvent e){
		Enemy.heading = e.getHeadingRadians();
		Enemy.bearing = e.getBearingRadians();
		this.heading = getHeadingRadians();
		
		Enemy.distance = e.getDistance();
		
		Enemy.absBearing = Utils.normalRelativeAngle(this.heading + Enemy.bearing);
		
		double radarOffset = Enemy.absBearing -
				Utils.normalRelativeAngle(this.getRadarHeadingRadians());
		radarOffset = Utils.normalRelativeAngle(radarOffset);
		
		setTurnRadarRightRadians(2*radarOffset);
	}


	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		this.update(e);
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		surf.handleHit(new Point2D.Double(e.getBullet().getX(),e.getBullet().getY()),e.getPower());
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e){
		//System.out.println("we hit a bullet with a bullet");
		surf.handleHit(new Point2D.Double(e.getHitBullet().getX(),e.getHitBullet().getY()),e.getHitBullet().getPower());
	}
	
	/**
	 * onHitWall: What to do when you hit a wall
	 */
	public void onHitWall(HitWallEvent e) {
	}
	
	public void onDeath(DeathEvent e){
		this.calcWinRate();
		gun.waveList.clear();
		surf.waveList.clear();
		surf.spotList.clear();
		surf.statsBuffer.clear();
		SurfHandler.emptyDir = this.latDirection;
		surf.flattenerVal = (winRate<.6?((int)(surf.flattenerVal/2.0)):surf.flattenerVal*2);
		surf.flattenerVal = (int)WaveUtils.limit(2,surf.flattenerVal,2);
		//System.out.println("Avg Movement Wrongness : " + treat(surf.wrongness/surf.shotsFired) + " degrees out of " + surf.shotsFired + " shots");
		System.out.println("WinRate: " + treat(winRate) + "% with " + wins + " wins");
		System.out.println("=========");
		System.out.println("Main   Gun: " + treat(gun.mainGunAcc) + " | Uses: " + gun.mainGunUses + " | Shots: " + gun.mainGunShotsFired);
		System.out.println("AS     Gun: " + treat(gun.antiSurferGunAcc) + " | Uses: " + gun.antiSurferGunUses + " | Shots: " + gun.antiSurferGunShotsFired);
		System.out.println("Theory Gun: " + treat(gun.theoryGunAcc) + " | Uses: " + gun.theoryGunUses + " | Shots: " + gun.theoryGunShotsFired);
		System.out.println("=========");
	}
	
	public void onWin(WinEvent e){
		this.wins ++;
		this.calcWinRate();
		gun.waveList.clear();
		surf.waveList.clear();
		surf.spotList.clear();
		surf.statsBuffer.clear();
		SurfHandler.emptyDir = this.latDirection;
		System.out.println("WinRate: " + treat(winRate) + "% with " + wins + " wins");
		//System.out.println("Making flatVal from: " + surf.flattenerVal);
		surf.flattenerVal = (winRate<.6?((int)(surf.flattenerVal/2.0)):surf.flattenerVal*2);
		surf.flattenerVal = (int)WaveUtils.limit(2,surf.flattenerVal,2);
		//System.out.println(surf.flattenerVal);
		//System.out.println("Avg Movement Wrongness : " + treat(surf.wrongness/surf.shotsFired) + " degrees out of " + surf.shotsFired + " shots");
		System.out.println("=========");
		System.out.println("Main   Gun: " + treat(gun.mainGunAcc) + " | Uses: " + gun.mainGunUses + " | Shots: " + gun.mainGunShotsFired);
		System.out.println("AS     Gun: " + treat(gun.antiSurferGunAcc) + " | Uses: " + gun.antiSurferGunUses + " | Shots: " + gun.antiSurferGunShotsFired);
		System.out.println("Theory Gun: " + treat(gun.theoryGunAcc) + " | Uses: " + gun.theoryGunUses + " | Shots: " + gun.theoryGunShotsFired);
		System.out.println("=========");
	}
	
	public void calcWinRate(){
		this.winRate = (double)(double)this.wins/(double)(this.getRoundNum()+1);
	}
	
	public void onPaint(Graphics2D g){
		if(!isMC){
			surf.onPaint(g);
		}
	}
	
	double treat(double num){
		return Math.round(num*10000.0)/100.0;
	}
}
