package kawigi.spare.util;

/**
 * StatBuffer - an effort to track virtual bullet statistics to find the best firing angle by experience.
 */
public class StatBuffer
{
	private double[] stats;		//representing angles from -2 to 2 in increments of .01
	private String name;
	public StatBuffer(String robot)
	{
		name = robot;
		stats = new double[400];
	}
	
	public void addStat(double newstat)
	{
		int index = (int)((newstat+2)*100+.5);
		if (index >= 0 && index < 400)
		{
			double diff = index*.01-2;
			stats[index] += 1-Math.abs(diff);
			if (diff < 0 && index > 0)
				stats[index-1] -= diff;
			else if (diff > 0 && index < 399)
				stats[index+1] += diff;
		}
	}
	
	public double findBest()
	{
		int min = 0, max = 400;
		while (min < max-1)
		{
			int divide1 = min + (max-min)/3;
			int divide2 = min + 2*(max-min)/3;
			double range1 = findRangeSum(min, divide1);
			double range2 = findRangeSum(divide1, divide2);
			double range3 = findRangeSum(divide2, max);
			if (range1 > range2 && range1 > range3)
				max = divide1;
			else if (range3 > range1 && range3 > range2)
				min = divide2;
			else
			{
				min = divide1;
				max = divide2;
			}
		}
		return (min*.01)-2;
	}
	
	private double findRangeSum(int minx, int maxx)
	{
		double temp = 0;
		for (int i=minx; i<maxx; i++)
			temp += stats[i];
		return temp;
	}
	
	public String getName()
	{
		return name;
	}
}
