package davidalves.net.math;

//Imports for all classes
import robocode.*;
import davidalves.net.*;
import davidalves.net.targeting.*;
import davidalves.net.movement.*;
import davidalves.net.util.*;
import java.util.*;
import java.awt.Color;
import java.io.*;


//A moving average
public class FiniteMovingAverage implements MovingAverageInterface, Serializable {//{{{
	final static double DEFAULT_MOVING_AVERAGE_HISTORY_SIZE = 100;
	double value = 0;
	double n = 0;
	double historySize = 0;
	
	public FiniteMovingAverage(double size){
		historySize = size;
	}
	
	public FiniteMovingAverage(){
		this(DEFAULT_MOVING_AVERAGE_HISTORY_SIZE);	
	}
	
	public double getAverage(){
		return value;
	}
	
	public void addValue(double newValue){
		if (n < historySize){
			value = (newValue + n * value)/(n + 1);
			n += 1;
		} else {
			value = (newValue + (historySize - 1) * value) / historySize;
		}
	}
	
	public void addWeightedValue(double newValue, double weight){
		if (n + weight < historySize){
			value = (newValue * weight + n * value)/(n + weight);
			n += weight;
		} else {
			value = (newValue * weight + (historySize - weight) * value) / historySize;
		}
	}
	
	public double getSize(){
		return n;
	}
	
	public void clear(){
		value = 0;
		n = 0;	
	}
	
	public String toString(){
		return DaveString.formatDouble(value) + " [" + Math.round(n) + " samples]";
	}
}//}}}