/*
 * Decompiled with CFR 0.152.
 */
package fnc.bandit;

import fnc.bandit.Analyser;
import fnc.bandit.CircularAnalyser;
import fnc.bandit.Force;
import fnc.bandit.LinearAnalyser;
import fnc.bandit.Path;
import fnc.bandit.Position;
import fnc.bandit.Util;
import java.io.PrintStream;
import java.util.Random;
import robocode.BulletHitEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;

public class Attractor {
    final int max_analysers = 2;
    Analyser[] analysers;
    String name;
    Path path;
    PrintStream output;
    Random rand;
    public int headcount;
    double width;
    double height;
    double d;
    Force force;
    Position predicted_position;
    Position position;
    Position save_position;
    Position fire_position;
    Position bandit_fire_position;
    double bullet_power;
    boolean fire_trigger;
    boolean left;
    int fire_watchdog;
    int hit_watchdog;
    int ram_watchdog;
    boolean is_target;
    int number_of_hits_taken;
    int number_of_hits_made;
    int number_of_bullets_fired_on;
    int number_of_bullets_fired;
    double hit_ratio;
    double energy;
    Analyser best_analyser;

    public Attractor(String string, Position position, double d, double d2, double d3, PrintStream printStream) {
        this.width = d2;
        this.height = d3;
        this.d = Math.sqrt(this.width * this.width + this.height * this.height);
        this.output = printStream;
        this.name = string;
        this.energy = d;
        this.position = new Position(position);
        this.save_position = new Position(position);
        this.bandit_fire_position = new Position(position);
        this.fire_position = new Position(position);
        this.fire_watchdog = 0;
        this.path = new Path(position, d2, d3, printStream);
        this.force = new Force();
        this.hit_watchdog = 0;
        this.ram_watchdog = 0;
        this.headcount = 0;
        this.rand = new Random();
        this.is_target = false;
        this.fire_trigger = false;
        this.left = false;
        this.number_of_hits_taken = 0;
        this.number_of_bullets_fired_on = 0;
        this.number_of_bullets_fired = 0;
        this.number_of_hits_made = 0;
        this.hit_ratio = 0.0;
        this.analysers = new Analyser[2];
        this.analysers[0] = new LinearAnalyser();
        this.analysers[0].setSize(d2, d3);
        this.analysers[1] = new CircularAnalyser();
        this.analysers[1].setSize(d2, d3);
        this.best_analyser = this.analysers[0];
    }

    public long getScanTime() {
        return (long)this.position.t;
    }

    public void countZero() {
        if (this.hit_watchdog > 0) {
            --this.hit_watchdog;
        }
        if (this.fire_watchdog > 0) {
            --this.fire_watchdog;
        }
        if (this.ram_watchdog > 0) {
            --this.ram_watchdog;
        }
    }

    public void hasHit(Position position) {
    }

    public void deathStatistics(PrintStream printStream) {
        printStream.println("# fired on:   " + this.number_of_bullets_fired_on);
        printStream.println("# hits taken: " + this.number_of_hits_taken);
        if (this.number_of_bullets_fired_on > 0) {
            printStream.println("ratio " + this.hit_ratio);
        }
    }

    public void hit(BulletHitEvent bulletHitEvent, long l, Position position) {
        this.energy = bulletHitEvent.getEnergy();
        ++this.number_of_hits_taken;
        if ((double)l - this.fire_position.t > 10.0) {
            this.fire(this.position, position, 3.0);
        }
        if (this.number_of_bullets_fired_on > 0) {
            this.hit_ratio = (double)this.number_of_hits_taken / (double)this.number_of_bullets_fired_on;
        }
        if (this.hit_ratio > 1.0) {
            this.output.println("Ough  hitratio > 1 : " + this.hit_ratio);
        }
    }

    public Position getFirePosition() {
        return new Position(this.fire_position);
    }

    public double sizeOfLastBullet() {
        return this.bullet_power;
    }

    public boolean fired() {
        if (this.fire_trigger) {
            this.fire_trigger = false;
            return true;
        }
        return false;
    }

    public void fire(Position position, Position position2, double d) {
        this.bullet_power = d;
        ++this.number_of_bullets_fired;
        this.fire_position.t = position.t;
        this.fire_position.x = position.x;
        this.fire_position.y = position.y;
        this.fire_position.h = position.bearing(position2);
        this.bandit_fire_position = new Position(position2);
        this.fire_trigger = true;
        this.fire_watchdog = this.rand.nextInt(6) + 6;
        this.left = this.rand.nextInt(2) == 1;
    }

    public int getNumberFired() {
        return this.number_of_bullets_fired;
    }

    public double getBanditRatio() {
        int n = this.number_of_bullets_fired_on + this.number_of_hits_taken;
        if (n > 0) {
            return (double)this.number_of_hits_taken / (double)n;
        }
        return 0.0;
    }

    public double getAttractorRatio() {
        int n = this.number_of_bullets_fired + this.number_of_hits_made;
        if (n > 0) {
            return (double)this.number_of_hits_made / (double)n;
        }
        return 0.0;
    }

    public void firedOn() {
        ++this.number_of_bullets_fired_on;
        this.hit_ratio = (double)this.number_of_hits_taken / (double)this.number_of_bullets_fired_on;
    }

    public void istarget() {
        this.is_target = true;
    }

    public void untarget() {
        this.is_target = false;
    }

    public void analyse() {
        int n = 0;
        n = 0;
        while (n < 2) {
            this.analysers[n].analyse(this.path);
            ++n;
        }
        this.best_analyser = this.analysers[0];
        double d = this.analysers[0].getAbsoluteError();
        double d2 = 0.0;
        n = 1;
        while (n < 2) {
            d2 = this.analysers[n].getAbsoluteError();
            if (d2 < d) {
                d = d2;
                this.best_analyser = this.analysers[n];
            }
            ++n;
        }
    }

    public void update(ScannedRobotEvent scannedRobotEvent, double d, double d2, long l, Position position) {
        this.position.t = l;
        this.position.x = d;
        this.position.y = d2;
        this.position.h = scannedRobotEvent.getHeadingRadians();
        this.path.add(this.position);
        if (scannedRobotEvent.getEnergy() < this.energy) {
            this.fire(this.position, position, this.energy - scannedRobotEvent.getEnergy());
        }
        this.energy = scannedRobotEvent.getEnergy();
    }

    public String getName() {
        return this.name;
    }

    public Position getPosition() {
        return new Position(this.position);
    }

    public Position getPredicted_position() {
        return new Position(this.predicted_position);
    }

    public void dump(PrintStream printStream) {
        printStream.println("--------------------------------");
        printStream.println(this.name + " " + this.position);
        int n = 0;
        while (n < 2) {
            this.analysers[n].dump(printStream);
            ++n;
        }
    }

    public double gunOffset(Position position, double d, double d2, double d3) {
        double d4 = this.impactTime(position, 1.0, 10.0, d2, d3);
        this.predicted_position = this.best_analyser.predictPosition(this.path, d4, d3);
        double d5 = position.bearing(this.predicted_position);
        double d6 = Util.offset(d, d5);
        return d6;
    }

    double impactTime(Position position, double d, double d2, double d3, double d4) {
        double d5 = d2;
        double d6 = d;
        int n = 0;
        double d7 = this.f(position, d6, d3, d4);
        double d8 = 0.0;
        while (Math.abs(d5 - d6) > 0.05 && n < 15) {
            ++n;
            d8 = this.f(position, d5, d3, d4);
            Double d9 = new Double(d8);
            if (d8 - d7 == 0.0) break;
            double d10 = d5 - d8 * (d5 - d6) / (d8 - d7);
            d6 = d5;
            d5 = d10;
            d7 = d8;
        }
        return d5;
    }

    double f(Position position, double d, double d2, double d3) {
        double d4 = 20.0 - 3.0 * d2;
        return position.distance(this.best_analyser.predictPosition(this.path, d, d3)) - d4 * d;
    }

    public final void rammed(Position position, HitRobotEvent hitRobotEvent) {
        this.energy = hitRobotEvent.getEnergy();
        this.ram_watchdog = 20;
    }

    public final Force force(Position position, long l) {
        double d = this.position.distance(position);
        if (this.ram_watchdog > 0) {
            this.force.setForce(this.position, position, -1.0);
        } else if (this.fire_watchdog > 0) {
            if (this.left) {
                this.force.setForce(this.fire_position, this.bandit_fire_position, 1.0, 1.2566370614359172);
            } else {
                this.force.setForce(this.fire_position, this.bandit_fire_position, 1.0, -1.2566370614359172);
            }
        } else if (this.position.distance(position) < 120.0) {
            this.force.setForce(this.fire_position, position, -1.0, -0.6283185307179586);
        } else if (this.position.distance(position) > 250.0) {
            this.force.setForce(this.fire_position, position, 0.3, 0.0);
        } else {
            this.force.setForce(this.fire_position, position, 0.0, 0.0);
        }
        return this.force;
    }

    public double firePower(Position position) {
        double d = this.position.distance(position);
        double d2 = this.headcount > 2 ? 3.0 : 2.0 + this.hit_ratio * 1.0;
        if (d < 200.0) {
            d2 = 3.0;
        }
        if (d > 600.0) {
            d2 = 0.1;
        }
        if (this.hit_ratio > 0.3) {
            d2 = 3.0;
        }
        if (this.ram_watchdog > 0) {
            d2 = 3.0;
        }
        return d2;
    }

    public double bounty(double d, Position position, double d2) {
        double d3 = 0.5 * d / this.position.distance(position);
        return d3;
    }
}

