/*
 * Decompiled with CFR 0.152.
 */
package bh.units;

import bh.units.interfaces.AbsoluteToRelative;
import bh.units.interfaces.Continuum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Energy
implements Continuum<Energy>,
AbsoluteToRelative<Energy, Energy> {
    public static final Energy ZERO = new Energy(0.0);
    private final double energy;

    public Energy(double energy) {
        assert (!Double.isNaN(energy));
        this.energy = (double)Math.round(energy * 1000000.0) / 1000000.0;
    }

    @Override
    public Energy negate() {
        return new Energy(-this.energy);
    }

    @Override
    public Energy abs() {
        return new Energy(Math.abs(this.energy));
    }

    @Override
    public Energy plus(Energy energy) {
        return new Energy(this.energy + energy.energy);
    }

    @Override
    public Energy minus(Energy energy) {
        return new Energy(this.energy - energy.energy);
    }

    @Override
    public Energy times(double d) {
        return new Energy(this.energy * d);
    }

    @Override
    public Energy divide(double d) {
        return new Energy(this.energy / d);
    }

    @Override
    public double divide(Energy energy) {
        return this.energy / energy.energy;
    }

    @Override
    public double toDouble() {
        return this.energy;
    }

    public String toString() {
        return String.valueOf(String.format("%1$6.4f", this.energy)) + "e";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Energy)) {
            return false;
        }
        Energy e = (Energy)o;
        return this.energy == e.energy;
    }

    public int hashCode() {
        return new Double(this.energy).hashCode();
    }
}

