/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import java.util.ArrayList;
import java.util.List;
import robocode.util.Utils;
import tcf.Bot;
import tcf.CrowdTargetting;
import tcf.Debug;
import tcf.PredState;
import tcf.Prediction;
import tcf.PredictorInfo;
import tcf.Wave;

class CrowdTargettingWave
extends Wave {
    Bot m_liveGun;
    PredState m_initialState;
    double m_targBearing;
    List<Prediction> m_predictions = new ArrayList<Prediction>();
    List<Object> m_predictData = new ArrayList<Object>();
    Prediction m_mergedPrediction = new Prediction();
    Prediction m_kernelPrediction = new Prediction();

    CrowdTargettingWave(Bot bot, PredState predState, CrowdTargetting crowdTargetting) {
        super(predState.m_gun, predState.m_shotSpeed);
        this.m_liveGun = bot;
        this.m_initialState = predState;
        this.m_targBearing = Math.atan2(predState.m_target.x() - predState.m_gun.x(), predState.m_target.y() - predState.m_gun.y());
        this.generatePrediction(crowdTargetting);
    }

    public void reinitialise(CrowdTargetting crowdTargetting) {
        this.m_predictions.clear();
        this.m_predictData.clear();
        this.m_mergedPrediction.clear();
        this.generatePrediction(crowdTargetting);
    }

    public Bot liveGun() {
        return this.m_liveGun;
    }

    public double bearing() {
        return this.m_targBearing;
    }

    public PredState state() {
        return this.m_initialState;
    }

    public Prediction getPrediction() {
        return this.m_kernelPrediction;
    }

    public double calcHitOrig(double d, double d2, double d3, int n) {
        int n2;
        double d4;
        double d5;
        double d6 = Math.hypot(d - this.gunInitX(), d2 - this.gunInitY());
        if (d6 + 50.0 < (d5 = this.shotDist() + (double)n * this.shotSpeed()) || d5 < d6 - 50.0) {
            return 0.0;
        }
        double d7 = Math.asin(30.0 / d5);
        double d8 = Math.atan2(d - this.gunInitX(), d2 - this.gunInitY());
        double d9 = Utils.normalRelativeAngle((double)(d8 - this.m_targBearing));
        int n3 = (int)(101.0 * (d9 - d7 - this.m_initialState.m_angleBehind) / (d4 = this.m_initialState.m_angleAhead - this.m_initialState.m_angleBehind));
        if (n3 > (n2 = (int)(101.0 * (d9 + d7 - this.m_initialState.m_angleBehind) / d4))) {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        double d10 = 0.0;
        int n5 = Math.max(0, n3);
        int n6 = Math.min(100, n2);
        for (int i = n5; i <= n6; ++i) {
            if (this.m_mergedPrediction.get(i) == 0.0) continue;
            double d11 = ((double)i + 0.5) / 101.0;
            double d12 = this.m_targBearing + this.m_initialState.m_angleBehind + d11 * (this.m_initialState.m_angleAhead - this.m_initialState.m_angleBehind);
            double d13 = this.m_initialState.m_gun.x() + Math.sin(d12) * d5;
            double d14 = this.m_initialState.m_gun.y() + Math.cos(d12) * d5;
            if (!(d - d3 <= d13) || !(d13 <= d + d3) || !(d2 - d3 <= d14) || !(d14 <= d2 + d3)) continue;
            d10 += this.m_mergedPrediction.get(i);
        }
        return d10;
    }

    public double calcHit2(double d, double d2, double d3, int n) {
        int n2;
        double d4;
        double d5 = d - this.gunInitX();
        double d6 = d2 - this.gunInitY();
        double d7 = Math.sqrt(d5 * d5 + d6 * d6);
        double d8 = this.shotDist() + (double)n * this.shotSpeed();
        d3 = 20.0;
        double d9 = d3 * 1.415;
        if (Math.abs(d7 - d8) > d9) {
            return 0.0;
        }
        double d10 = Math.asin(d9 / d8);
        double d11 = Math.atan2(d - this.gunInitX(), d2 - this.gunInitY());
        double d12 = Utils.normalRelativeAngle((double)(d11 - this.m_targBearing));
        int n3 = (int)(101.0 * (d12 - d10 - this.m_initialState.m_angleBehind) / (d4 = this.m_initialState.m_angleAhead - this.m_initialState.m_angleBehind));
        if (n3 > (n2 = (int)(101.0 * (d12 + d10 - this.m_initialState.m_angleBehind) / d4))) {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        double d13 = 0.0;
        int n5 = Math.max(0, n3);
        int n6 = Math.min(100, n2);
        for (int i = n5; i <= n6; ++i) {
            d13 += this.m_mergedPrediction.get(i);
        }
        return d13;
    }

    public double calcHit(double d, double d2, double d3, int n) {
        double d4 = d - this.gunInitX();
        double d5 = d2 - this.gunInitY();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = this.shotDist() + (double)n * this.shotSpeed();
        d3 = 20.0;
        double d8 = d3 * 1.415;
        if (Math.abs(d6 - d7) > d8) {
            return 0.0;
        }
        double d9 = this.m_initialState.calcGfFromPos(d, d2);
        int n2 = (int)Math.floor(101.0 * d9);
        if (n2 < 0 || n2 >= 101) {
            return 0.0;
        }
        return this.m_kernelPrediction.get(n2);
    }

    public double calcHit(double d, double d2) {
        double d3 = this.m_initialState.calcGfFromPos(d, d2);
        int n = (int)Math.floor(101.0 * d3);
        if (n < 0 || n >= 101) {
            return 0.0;
        }
        return this.m_kernelPrediction.get(n);
    }

    public double calcHit(double d) {
        int n = (int)Math.floor(101.0 * d);
        if (n < 0 || n >= 101) {
            return 0.0;
        }
        return this.m_kernelPrediction.get(n);
    }

    public void learn(CrowdTargetting crowdTargetting, PredState predState, boolean bl) {
        PredictorInfo predictorInfo;
        int n;
        double d;
        double d2;
        if (predState.m_bullet != null) {
            d2 = predState.m_bullet.getX();
            d = predState.m_bullet.getY();
        } else {
            d2 = predState.m_target.x();
            d = predState.m_target.y();
        }
        double d3 = this.m_initialState.calcGfFromPos(d2, d);
        Debug.printf("simple gf pred - learn gf %g\n", d3);
        int n2 = Prediction.gfToIndex(d3);
        List<PredictorInfo> list = crowdTargetting.getPredictorInfoList();
        double[] dArray = new double[list.size()];
        double d4 = 0.0;
        double d5 = Math.hypot(this.m_initialState.m_gun.x() - d2, this.m_initialState.m_gun.y() - d);
        double d6 = Math.abs(this.m_initialState.m_angleAhead - this.m_initialState.m_angleBehind);
        int n3 = (int)Math.ceil(101.0 * Math.asin(51.0 / d5) / d6) + 2;
        int n4 = n3 / 2;
        for (n = 0; n < list.size(); ++n) {
            predictorInfo = list.get(n);
            predictorInfo.getPredictor().learn(this.m_initialState, predState, this.m_predictData.get(n), d3, bl);
            double d7 = 0.0;
            for (int i = 0; i < n3; ++i) {
                int n5 = n2 + i - n4;
                if (n5 < 0 || n5 >= 101) continue;
                d7 += this.m_predictions.get(n).get(n5);
            }
            dArray[n] = d7;
            d4 += d7;
        }
        if (d4 == 0.0) {
            d4 = 1.0;
        }
        if (bl) {
            for (n = 0; n < list.size(); ++n) {
                predictorInfo = list.get(n);
                predictorInfo.incWeight(dArray[n] / d4);
            }
        }
    }

    private void generatePrediction(CrowdTargetting crowdTargetting) {
        for (PredictorInfo predictorInfo : crowdTargetting.getPredictorInfoList()) {
            Prediction prediction = new Prediction();
            Object object = predictorInfo.getPredictor().predict(this.m_initialState, prediction);
            this.m_predictions.add(prediction);
            this.m_predictData.add(object);
            this.m_mergedPrediction.accumulate(prediction, predictorInfo.getWeight());
        }
        double d = Math.hypot(this.m_initialState.m_gun.x() - this.m_initialState.m_target.x(), this.m_initialState.m_gun.y() - this.m_initialState.m_target.y());
        double d2 = Math.abs(this.m_initialState.m_angleAhead - this.m_initialState.m_angleBehind);
        double d3 = 101.0 * Math.asin(51.0 / d) / d2;
        this.kerneliseCosine(d3, this.m_mergedPrediction, this.m_kernelPrediction);
    }

    private void kerneliseSimple(double d, Prediction prediction, Prediction prediction2) {
        int n = (int)(d + 0.5);
        int n2 = n / 2;
        double d2 = 0.0;
        for (int i = 0; i < 101 + n; ++i) {
            int n3;
            if (i - n >= 0) {
                d2 -= prediction.get(i - n);
            }
            if (i < 101) {
                d2 += prediction.get(i);
            }
            if ((n3 = i - n2) < 0 || n3 >= 101) continue;
            prediction2.set(n3, d2);
        }
    }

    private void kerneliseCosine(double d, Prediction prediction, Prediction prediction2) {
        int n;
        int n2 = (int)(d * 1.0 + 0.5);
        int n3 = n2 * 2 + 1;
        double[] dArray = new double[n3];
        for (n = 0; n <= n2; ++n) {
            double d2 = 1.0 + Math.cos((double)n * Math.PI / (double)n2);
            dArray[n2 + n] = d2;
            dArray[n2 - n] = d2;
        }
        for (n = 0; n < 101; ++n) {
            double d3 = 0.0;
            for (int i = -n2; i <= n2; ++i) {
                int n4 = n + i;
                if (n4 < 0 || n4 >= 101) continue;
                d3 += prediction.get(n4) * dArray[n2 + i];
            }
            prediction2.set(n, d3);
        }
    }
}

