/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.gunner.aiming;

import dmh.robocode.data.Location;
import dmh.robocode.data.RadarObservation;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.gunner.aiming.CalibratedAimingStrategyUsingEnemySimulator;
import dmh.robocode.gunner.simulator.SteadyChangeEnemySimulator;
import dmh.robocode.robot.CommandBasedRobot;
import dmh.robocode.utils.Geometry;
import java.awt.Color;

public class AimByInterpolatingStraightAhead
extends CalibratedAimingStrategyUsingEnemySimulator {
    public AimByInterpolatingStraightAhead(CommandBasedRobot myRobot, EnemyRobot enemy, boolean isLearningAllowed, Color color) {
        super(myRobot, enemy, isLearningAllowed, color);
    }

    @Override
    public double getEstimatedSuccessOfShotUsingRules(double bulletSpeed) {
        return this.getDefaultEstimatedSuccess(bulletSpeed);
    }

    @Override
    public Location getTargetForShot(double bulletSpeed) {
        int period = 5;
        RadarObservation oldObservation = this.getEnemy().getObservationAtTime(this.getMyRobot().getTime() - (long)period);
        if (oldObservation != null) {
            Location oldLocation = oldObservation.getLocation();
            Location currentLocation = this.getEnemy().getLatestRadarObservation().getLocation();
            double velocity = Geometry.getDistanceBetweenLocations(oldLocation, currentLocation) / (double)period;
            double bearing = Geometry.getBearingBetweenLocations(oldLocation, currentLocation);
            SteadyChangeEnemySimulator simulator = new SteadyChangeEnemySimulator(currentLocation, velocity, bearing, 0.0, 0.0);
            return this.getSimulatorIntercept(simulator, bulletSpeed);
        }
        return null;
    }
}

