/*
 * Decompiled with CFR 0.152.
 */
package Krabb.sliNk;

import Krabb.sliNk.Bot;
import Krabb.sliNk.CustomTeamRobot;
import Krabb.sliNk.Data;
import Krabb.sliNk.DataHandling;
import Krabb.sliNk.Garm;
import Krabb.sliNk.Stats;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Scan
extends CustomTeamRobot {
    int dir_last = 0;
    Bot aim = null;
    double enemyAbsoluteBearing;
    long timeSinceLastScan;

    protected void step() {
        if (!Garm.meleegame) {
            this.doScannerWiki();
        } else {
            this.doScanner();
        }
        super.step();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        this.timeSinceLastScan = 0L;
        if (this.aim == null || this.aim.name.equals(e.getName())) {
            this.setNewAim();
        }
        super.onScannedRobot(e);
    }

    private void doScannerWiki() {
        ++this.timeSinceLastScan;
        double radarOffset = Double.POSITIVE_INFINITY;
        if (this.timeSinceLastScan < 3L) {
            radarOffset = Utils.normalRelativeAngle((double)(this.getRadarHeadingRadians() - this.enemyAbsoluteBearing));
            radarOffset += (double)this.sign(radarOffset) * 0.02;
        }
        this.setTurnRadarLeftRadians(radarOffset);
    }

    int sign(double v) {
        return v > 0.0 ? 1 : -1;
    }

    private void doScanner() {
        if (this.dir_last == 0) {
            double alpha = Math.atan2(this.getBattleFieldWidth() / 2.0 - this.getX(), this.getBattleFieldHeight() / 2.0 - this.getY());
            double alpha_delta = Utils.normalRelativeAngle((double)(alpha - this.getRadarHeadingRadians()));
            this.dir_last = (int)DataHandling.mySignum(alpha_delta);
        }
        if (this.getOthers() - Garm.nummates > Garm._enemies_array.size() || this.getOthers() == 0) {
            this.setTurnRadarRightRadians(Double.MAX_VALUE * (double)this.dir_last);
            return;
        }
        int i = 0;
        while (i < Garm._enemies_array.size()) {
            if (Garm.getEnemy(i).getNewestStats() == null) {
                this.setTurnRadarRightRadians(Double.MAX_VALUE * (double)this.dir_last);
                return;
            }
            ++i;
        }
        if (this.aim == null || this.aim.death) {
            this.setNewAim();
        }
    }

    private void setNewAim() {
        this.aim = Data.getLastScannedEnemy();
        if (this.aim == null) {
            return;
        }
        double alpha_0 = Math.atan2(this.aim.getNewestStats().getX() - this.getX(), this.aim.getNewestStats().getY() - this.getY());
        double alpha_delta_0 = Utils.normalRelativeAngle((double)(alpha_0 - this.getRadarHeadingRadians()));
        if (alpha_delta_0 > 0.0) {
            this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        } else {
            this.setTurnRadarRightRadians(Double.NEGATIVE_INFINITY);
        }
    }

    private void doOldScanner() {
        if (this.getOthers() > Garm._enemies_array.size() || this.getOthers() == 0) {
            this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            return;
        }
        int i = 0;
        while (i < Garm._enemies_array.size()) {
            if (Garm.getEnemy((int)i).stats == null) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
                return;
            }
            ++i;
        }
        if (this.getOthers() == 1) {
            Stats stats_enemy = Garm.getFirstBot().getNewestStats();
            double alpha = Math.atan2(stats_enemy.getX() - this.getX(), stats_enemy.getY() - this.getY());
            double alpha_delta = Utils.normalRelativeAngle((double)(alpha - this.getRadarHeadingRadians()));
            double alpha_new = Utils.normalRelativeAngle((double)(Math.signum(alpha_delta) * Math.PI / 14.0 + alpha_delta));
            this.setTurnRadarRightRadians(alpha_new);
            return;
        }
        Stats last = null;
        int i2 = 0;
        while (i2 < Garm._enemies_array.size()) {
            if (!(last != null && Garm.getEnemy((int)i2).getNewestStats().time >= last.time || Garm.getEnemy((int)i2).death)) {
                last = Garm.getEnemy(i2).getNewestStats();
            }
            ++i2;
        }
        double alpha = Math.atan2(last.getX() - this.getX(), last.getY() - this.getY());
        if (Utils.normalRelativeAngle((double)(alpha - this.getRadarHeadingRadians())) < 0.0) {
            this.setTurnRadarLeftRadians(Double.POSITIVE_INFINITY);
        } else {
            this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }
}

