/*
 * Decompiled with CFR 0.152.
 */
package kenran.util;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;

public class Utils {
    public static final double PI2 = Math.PI * 2;
    public static final double WALL_STICK = 160.0;

    private Utils() {
    }

    public static double sign(double d) {
        return d < 0.0 ? -1.0 : 1.0;
    }

    public static double bulletVelocity(double d) {
        return 20.0 - 3.0 * d;
    }

    public static double bulletDamage(double d) {
        return d <= 1.0 ? 4.0 * d : 4.0 * d + 2.0 * (d - 1.0);
    }

    public static double bulletTravelTime(double d, double d2) {
        return d / Utils.bulletVelocity(d2);
    }

    public static double normalAbsoluteAngle(double d) {
        return (d % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2);
    }

    public static double normalRelativeAngle(double d) {
        return Utils.normalAbsoluteAngle(d + Math.PI) - Math.PI;
    }

    public static double distance(double d, double d2, double d3, double d4) {
        return Math.sqrt((d - d3) * (d - d3) + (d2 - d4) * (d2 - d4));
    }

    public static double absoluteBearing(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        return Math.atan2(d5, d6);
    }

    public static double absoluteBearing(Point2D point2D, Point2D point2D2) {
        return Utils.absoluteBearing(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public static double limit(double d, double d2, double d3) {
        return Math.max(Math.min(d2, d3), d);
    }

    public static Point2D project(Point2D point2D, double d, double d2) {
        return new Point2D.Double(point2D.getX() + Math.sin(d) * d2, point2D.getY() + Math.cos(d) * d2);
    }

    public static double wallSmoothing(Rectangle2D rectangle2D, Point2D point2D, double d, int n) {
        while (!rectangle2D.contains(Utils.project(point2D, d, 160.0))) {
            d += (double)n * 0.05;
        }
        return d;
    }

    public static void setBackAsFront(AdvancedRobot advancedRobot, double d) {
        double d2 = Utils.normalRelativeAngle(d - advancedRobot.getHeadingRadians());
        if (Math.abs(d2) > 1.5707963267948966) {
            if (d2 < 0.0) {
                advancedRobot.setTurnRightRadians(Math.PI + d2);
            } else {
                advancedRobot.setTurnLeftRadians(Math.PI - d2);
            }
            advancedRobot.setBack(100.0);
        } else {
            if (d2 < 0.0) {
                advancedRobot.setTurnLeftRadians(-1.0 * d2);
            } else {
                advancedRobot.setTurnRightRadians(d2);
            }
            advancedRobot.setAhead(100.0);
        }
    }

    public static double maxEscapeAngle(double d) {
        return Math.asin(8.0 / d);
    }
}

