/*
 * Decompiled with CFR 0.152.
 */
package gf.Centaur.targeting;

import gf.Centaur.targeting.AdvancedGun;
import gf.Centaur.targeting.GunControll;
import gf.Centaur.targeting.LinearGun;
import gf.Centaur.utils.ExecutingRobot;
import gf.Centaur.utils.KdTree;
import gf.Centaur.utils.Tools;
import gf.Centaur.utils.VirtualRobot;
import gf.Centaur.utils.Wave;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import robocode.util.Utils;

public class ZeusLightning
extends AdvancedGun {
    private static final double GROUP_DISTANCE = 0.05;
    private static final int NEIGHBOR_NUM = 20;

    @Override
    public double getAbsoluteAngle(ExecutingRobot execRobot, KdTree.WeightedSqrEuclid<Double> guessFactors, double bulletPower, VirtualRobot target) {
        if (guessFactors.size() != 0) {
            Vector group;
            Wave thisWave = new Wave(execRobot, new GunControll[0], null, bulletPower, target, true, true);
            List nearestGuessFactors = guessFactors.nearestNeighbor(thisWave.getSegmentationLocation(), 20, false);
            Collections.sort(nearestGuessFactors, new EntryComparator());
            Vector groups = new Vector();
            for (KdTree.Entry entry : nearestGuessFactors) {
                Vector vec;
                double value = (Double)entry.value;
                if (groups.isEmpty()) {
                    vec = new Vector();
                    vec.add(entry);
                    groups.add(vec);
                    continue;
                }
                if (value > (Double)((KdTree.Entry)((Vector)groups.lastElement()).lastElement()).value + 0.05) {
                    vec = new Vector();
                    vec.add(entry);
                    groups.add(vec);
                    continue;
                }
                ((Vector)groups.lastElement()).add(entry);
            }
            int bestGroup = 0;
            double bestValue = Double.POSITIVE_INFINITY;
            int i = 0;
            while (i < groups.size()) {
                group = (Vector)groups.get(i);
                double distanceSum = 0.0;
                for (KdTree.Entry entry : group) {
                    distanceSum += entry.distance;
                }
                double averageDistance = distanceSum / (double)group.size();
                double value = averageDistance / (double)group.size();
                if (value < bestValue) {
                    bestGroup = i;
                    bestValue = value;
                }
                ++i;
            }
            this.shapes.clear();
            i = 0;
            while (i < groups.size()) {
                group = (Vector)groups.get(i);
                Color paint = i == bestGroup ? Color.green : Color.yellow;
                for (KdTree.Entry entry : group) {
                    double x = target.getX() - thisWave.getX();
                    double y = target.getY() - thisWave.getY();
                    double angleToTarget = Utils.normalRelativeAngle((double)Tools.toAbsolute(Math.atan2(y, x)));
                    double angle = Tools.toPolar(Utils.normalAbsoluteAngle((double)(angleToTarget + (Double)entry.value * Tools.getMaxEscapeAngle(thisWave.getVelocity()))));
                    double robotX = execRobot.getX();
                    double robotY = execRobot.getY();
                    this.shapes.put(new Line2D.Double(robotX, robotY, robotX + Math.cos(angle) * 100.0, robotY + Math.sin(angle) * 100.0), paint);
                }
                ++i;
            }
            double guessSum = 0.0;
            for (KdTree.Entry entry : (Vector)groups.get(bestGroup)) {
                guessSum += ((Double)entry.value).doubleValue();
            }
            double averageGuess = guessSum / (double)((Vector)groups.get(bestGroup)).size();
            double x = target.getX() - thisWave.getX();
            double y = target.getY() - thisWave.getY();
            double angleToTarget = Utils.normalRelativeAngle((double)Tools.toAbsolute(Math.atan2(y, x)));
            double angle = Utils.normalAbsoluteAngle((double)(angleToTarget + averageGuess * Tools.getMaxEscapeAngle(thisWave.getVelocity())));
            double drawAngle = Tools.toPolar(angle);
            double robotX = execRobot.getX();
            double robotY = execRobot.getY();
            this.shapes.put(new Line2D.Double(robotX, robotY, robotX + Math.cos(drawAngle) * 100.0, robotY + Math.sin(drawAngle) * 100.0), Color.red);
            return angle;
        }
        return new LinearGun().getAbsoluteAngle(target, bulletPower, execRobot);
    }

    private class EntryComparator
    implements Comparator<KdTree.Entry<Double>> {
        private EntryComparator() {
        }

        @Override
        public int compare(KdTree.Entry<Double> arg0, KdTree.Entry<Double> arg1) {
            return ((Double)arg0.value).compareTo((Double)arg1.value);
        }
    }
}

