/*
 * Decompiled with CFR 0.152.
 */
package yarhoslav;

import java.awt.Graphics2D;
import java.util.Map;
import robocode.AdvancedRobot;
import yarhoslav.Enemigo;
import yarhoslav.Entidad;
import yarhoslav.GravityPoint;

public class Piloto {
    private final Map mContexto;
    private int midpointcount;
    private double midpointstrength;
    private int pintaX;
    private int pintaY;

    public Piloto(Map pContexto) {
        this.mContexto = pContexto;
    }

    public void ejecutar() {
        double ang;
        double force;
        GravityPoint p;
        double xforce = 0.0;
        double yforce = 0.0;
        Map lEntidades = (Map)this.mContexto.get("ENTIDADES");
        AdvancedRobot lRobot = (AdvancedRobot)this.mContexto.get("PARENT");
        for (Entidad _entidad : lEntidades.values()) {
            p = _entidad instanceof Enemigo ? new GravityPoint(_entidad.getPosX(), _entidad.getPosY(), -1000.0) : new GravityPoint(_entidad.getPosX(), _entidad.getPosY(), -2000.0);
            force = p.getPower() / Math.pow(this.getRange(lRobot.getX(), lRobot.getY(), p.getX(), p.getY()), 2.0);
            ang = this.normaliseBearing(1.5707963267948966 - Math.atan2(lRobot.getY() - p.getY(), lRobot.getX() - p.getX()));
            xforce += Math.sin(ang) * force;
            yforce += Math.cos(ang) * force;
            lRobot.out.println("PILOTO_EJECUTAR: ENTIDAD:" + _entidad.getNombre() + " Punto: " + p.toString());
        }
        ++this.midpointcount;
        if (this.midpointcount > 5) {
            this.midpointcount = 0;
            this.midpointstrength = Math.random() * 2000.0 - 1000.0;
        }
        p = new GravityPoint(lRobot.getBattleFieldWidth() / 2.0, lRobot.getBattleFieldHeight() / 2.0, this.midpointstrength);
        force = p.getPower() / Math.pow(this.getRange(lRobot.getX(), lRobot.getY(), p.getX(), p.getY()), 1.5);
        ang = this.normaliseBearing(1.5707963267948966 - Math.atan2(lRobot.getY() - p.getY(), lRobot.getX() - p.getX()));
        xforce += Math.sin(ang) * force;
        yforce += Math.cos(ang) * force;
        xforce += 4000.0 / Math.pow(this.getRange(lRobot.getX(), lRobot.getY(), lRobot.getBattleFieldWidth(), lRobot.getY()), 2.0);
        yforce += 4000.0 / Math.pow(this.getRange(lRobot.getX(), lRobot.getY(), lRobot.getX(), lRobot.getBattleFieldHeight()), 2.0);
        this.goTo(lRobot.getX() - (xforce -= 4000.0 / Math.pow(this.getRange(lRobot.getX(), lRobot.getY(), 0.0, lRobot.getY()), 2.0)), lRobot.getY() - (yforce -= 4000.0 / Math.pow(this.getRange(lRobot.getX(), lRobot.getY(), lRobot.getX(), 0.0), 2.0)));
    }

    private void goTo(double x, double y) {
        AdvancedRobot lRobot = (AdvancedRobot)this.mContexto.get("PARENT");
        double dist = 20.0;
        double angle = Math.toDegrees(this.absbearing(lRobot.getX(), lRobot.getY(), x, y));
        double r = this.turnTo(angle);
        lRobot.setAhead(dist * r);
        this.pintaX = (int)x;
        this.pintaY = (int)y;
    }

    public void pintar(Graphics2D g) {
        AdvancedRobot lRobot = (AdvancedRobot)this.mContexto.get("PARENT");
        g.drawLine((int)lRobot.getX(), (int)lRobot.getY(), this.pintaX, this.pintaY);
    }

    private int turnTo(double angle) {
        int dir;
        AdvancedRobot lRobot = (AdvancedRobot)this.mContexto.get("PARENT");
        double ang = this.normaliseBearing(lRobot.getHeading() - angle);
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        lRobot.setTurnLeft(ang);
        return dir;
    }

    private double normaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    private double normaliseHeading(double ang) {
        if (ang > Math.PI * 2) {
            ang -= Math.PI * 2;
        }
        if (ang < 0.0) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    private double getRange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    private double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = this.getRange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }
}

