/*
 * Decompiled with CFR 0.152.
 */
package synnalagma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import synnalagma.BulletTracker;
import synnalagma.shooting.VirtualBullet;

public class ShootStat
implements Cloneable {
    public static float virtualFactor = 0.8f;
    private float eneratio = 0.0f;
    private float shoot = 0.0f;
    private float hit = 0.0f;
    private float reussite = 0.0f;
    private float rollRatio = 0.15f;

    public float getEnergieRatio() {
        return this.eneratio;
    }

    public float reussite() {
        return this.reussite;
    }

    public float getRollRatio() {
        return this.rollRatio;
    }

    public String toString() {
        return "Energie Ratio : " + this.getEnergieRatio() + " Reussite Ratio : " + this.reussite() + " Roll Ratio : " + this.rollRatio;
    }

    public void update(BulletTracker bulletTracker) {
        float f = 0.0f;
        if (bulletTracker.getHit()) {
            f = 1.0f;
        }
        this.eneratio = (this.eneratio * 100.0f + 3.0f * (float)bulletTracker.getBullet().getPower() * f) / (100.0f + (float)bulletTracker.getBullet().getPower());
        this.rollRatio = (this.rollRatio * 100.0f + (float)bulletTracker.getBullet().getPower() * f) / (100.0f + (float)bulletTracker.getBullet().getPower());
        this.hit += f;
        this.shoot += 1.0f;
        this.reussite = this.hit / this.shoot;
    }

    public void update(VirtualBullet virtualBullet) {
        float f = 0.0f;
        if (virtualBullet.state == 1) {
            f = 1.0f;
        }
        this.eneratio = (this.eneratio * 100.0f + 3.0f * (float)virtualBullet.currentPos.getForce() * virtualFactor * f) / (100.0f + (float)virtualBullet.currentPos.getForce() * virtualFactor);
        this.rollRatio = (this.rollRatio * 100.0f + (float)virtualBullet.currentPos.getForce() * virtualFactor * f) / (100.0f + (float)virtualBullet.currentPos.getForce() * virtualFactor);
        this.reussite = (this.reussite * 100.0f + f * virtualFactor) / 100.8f;
    }

    public float[] getData() {
        float[] fArray = new float[]{this.eneratio, this.rollRatio, this.reussite};
        return fArray;
    }

    public void setData(float[] fArray, float f) {
        this.eneratio = (1.0f - f) * this.eneratio + f * fArray[0];
        this.rollRatio = (1.0f - f) * this.rollRatio + f * fArray[1];
        this.reussite = (1.0f - f) * this.reussite + f * fArray[2];
    }

    public void save(DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeFloat(this.eneratio);
            dataOutputStream.writeFloat(this.rollRatio);
            dataOutputStream.writeFloat(this.reussite);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void load(DataInputStream dataInputStream, float f) {
        try {
            this.eneratio = (1.0f - f) * this.eneratio + f * dataInputStream.readFloat();
            this.rollRatio = (1.0f - f) * this.rollRatio + f * dataInputStream.readFloat();
            this.reussite = (1.0f - f) * this.reussite + f * dataInputStream.readFloat();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

