/*
 * Decompiled with CFR 0.152.
 */
package rjw.gun;

import java.awt.Color;
import java.awt.geom.Point2D;
import rjw.RabidWombat;
import rjw.gun.ProjectionGun;
import rjw.gun.Projector;
import rjw.radar.Enemy;
import rjw.radar.EnemyScan;
import rjw.util.Vector;

public class CircularGun
extends ProjectionGun {
    private final int NUM_TICKS = RabidWombat.getProps().getInt("gun.circular.numTicks", 5);

    @Override
    protected Projector projector(Enemy enemy) {
        return new CircularProjector(enemy);
    }

    @Override
    public Color getColor() {
        return Color.MAGENTA;
    }

    private class CircularProjector
    implements Projector {
        private double _dTheta = 0.0;
        private Point2D.Double _pos;
        private Vector _vector;

        protected CircularProjector(Enemy enemy) {
            int ticks = Math.min(enemy.size() - 1, CircularGun.this.NUM_TICKS);
            if (ticks >= 2) {
                double v = 0.0;
                int i = 0;
                while (i < ticks) {
                    Vector curVector = enemy.get(i).v();
                    Vector prevVector = enemy.get(i + 1).v();
                    this._dTheta += curVector.t - prevVector.t;
                    v += curVector.d;
                    ++i;
                }
                this._dTheta /= (double)ticks;
                EnemyScan scan = enemy.get(0);
                this._pos = scan.p();
                this._vector = new Vector(scan.v().t, v /= (double)ticks);
            } else {
                EnemyScan scan = enemy.get(0);
                this._pos = scan.p();
                this._vector = scan.v();
            }
        }

        @Override
        public Point2D.Double next() {
            this._vector = this._vector.add(this._dTheta);
            this._pos = this._vector.translate(this._pos);
            return this._pos;
        }
    }
}

