/*
 * Decompiled with CFR 0.152.
 */
package metal.shared;

import metal.shared.MAngle;
import metal.shared.MBotData;
import metal.shared.MBullet;
import metal.shared.MPoint;
import metal.shared.MProbability;
import metal.shared.MSituation;

public class MRing
extends MPoint {
    private double bearing = 0.0;
    private double bearingMax = 0.0;
    double direction = 0.0;
    double index = 0.0;
    double power = 0.0;
    MSituation situation = null;
    public double speed = 0.0;
    public int time = 0;

    public MRing(MSituation s) {
        this.setLocation(MBotData.getLocation());
        this.situation = s;
        this.time = (int)MBotData.self.getTime();
        this.speed = MBullet.getSpeed(MBullet.power);
        this.power = MBullet.power;
        this.direction = MBotData.enemy.getDirection();
        this.bearingMax = MAngle.max(8.0, this.speed) * this.direction;
        this.bearing = MBotData.enemy.bearing;
    }

    private void calcIndex() {
        double turn = MAngle.relative(MAngle.absolute(this, MBotData.enemy) - this.bearing);
        this.index = Math.round(turn / (this.bearingMax / MProbability.HALF) + MProbability.HALF);
    }

    public double getIndex() {
        return this.index;
    }

    public boolean isActive(MPoint target, int now) {
        double dist = this.speed * (double)(now - this.time);
        double distTarget = Math.abs(this.distance(target));
        return !(dist > distTarget);
    }

    public boolean isHit(MPoint target, int now) {
        return !this.isActive(target, now);
    }

    public boolean isValid() {
        this.calcIndex();
        return true;
    }
}

