/*
 * Decompiled with CFR 0.152.
 */
package bjl.radar;

import bjl.BattleField;
import bjl.Enemy;
import bjl.Point;
import bjl.SuperBlip;
import bjl.Utils;
import bjl.radar.RadarStrategy;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FieldPortion
extends RadarStrategy {
    private boolean right;
    private int curWall;

    private final int getWall() {
        int ans = 0;
        Point pos = BattleField.getPos();
        if (pos.x < 36.0) {
            ans |= 8;
        }
        if (pos.y < 36.0) {
            ans |= 4;
        }
        if (pos.x > BattleField.getWidth() - 36.0) {
            ans |= 2;
        }
        if (pos.y > BattleField.getHeight() - 36.0) {
            ans |= 1;
        }
        return ans;
    }

    public double Process(Enemy focus, boolean isCurStrategy) {
        double angle = 0.0;
        int wall = this.getWall();
        double minValue = 0.0;
        double maxValue = 359.9;
        if (wall == 1) {
            minValue = 90.0;
            maxValue = 270.0;
        } else if (wall == 2) {
            minValue = 180.0;
            maxValue = 360.0;
        } else if (wall == 3) {
            minValue = 180.0;
            maxValue = 270.0;
        } else if (wall == 4) {
            minValue = 270.0;
            maxValue = 450.0;
        } else if (wall == 6) {
            minValue = 270.0;
            maxValue = 360.0;
        } else if (wall == 8) {
            minValue = 0.0;
            maxValue = 180.0;
        } else if (wall == 9) {
            minValue = 90.0;
            maxValue = 180.0;
        } else if (wall == 12) {
            minValue = 0.0;
            maxValue = 90.0;
        }
        SuperBlip me = BattleField.getMe();
        if (!isCurStrategy || this.curWall != wall) {
            angle = Utils.normalRelativeAngle(minValue - me.radarHeading);
            this.right = true;
            this.curWall = wall;
        } else if (me.turnRadarRemain == 0.0) {
            angle = maxValue - minValue;
            if (!this.right) {
                angle = -angle;
            }
            this.right ^= true;
        }
        return angle;
    }

    public double getUsefulness(Enemy focus) {
        int w = this.getWall();
        if (w == 0) {
            return 0.0;
        }
        if (w == 1 || w == 2 || w == 4 || w == 8) {
            return 5;
        }
        return 7.5;
    }

    public String toString() {
        return "FieldPortion";
    }

    private final /* synthetic */ void this() {
        this.curWall = -1;
    }

    public FieldPortion() {
        this.this();
    }
}

